// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the configuration information to connect to websites that require basic user authentication.
 */
public class BasicAuthenticationConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an Secrets Manager secret. You create a secret to store your credentials in [Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
     *
     * You use a secret if basic authentication credentials are required to connect to a website. The secret stores your credentials of user name and password.
     */
    public val credentials: kotlin.String = requireNotNull(builder.credentials) { "A non-null value must be provided for credentials" }
    /**
     * The name of the website host you want to connect to using authentication credentials.
     *
     * For example, the host name of https://a.example.com/page1.html is "a.example.com".
     */
    public val host: kotlin.String = requireNotNull(builder.host) { "A non-null value must be provided for host" }
    /**
     * The port number of the website host you want to connect to using authentication credentials.
     *
     * For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.
     */
    public val port: kotlin.Int = requireNotNull(builder.port) { "A non-null value must be provided for port" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.BasicAuthenticationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BasicAuthenticationConfiguration(")
        append("credentials=$credentials,")
        append("host=$host,")
        append("port=$port")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = credentials.hashCode()
        result = 31 * result + (host.hashCode())
        result = 31 * result + (port)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BasicAuthenticationConfiguration

        if (credentials != other.credentials) return false
        if (host != other.host) return false
        if (port != other.port) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.BasicAuthenticationConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of an Secrets Manager secret. You create a secret to store your credentials in [Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
         *
         * You use a secret if basic authentication credentials are required to connect to a website. The secret stores your credentials of user name and password.
         */
        public var credentials: kotlin.String? = null
        /**
         * The name of the website host you want to connect to using authentication credentials.
         *
         * For example, the host name of https://a.example.com/page1.html is "a.example.com".
         */
        public var host: kotlin.String? = null
        /**
         * The port number of the website host you want to connect to using authentication credentials.
         *
         * For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.
         */
        public var port: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.BasicAuthenticationConfiguration) : this() {
            this.credentials = x.credentials
            this.host = x.host
            this.port = x.port
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.BasicAuthenticationConfiguration = BasicAuthenticationConfiguration(this)

        internal fun correctErrors(): Builder {
            if (credentials == null) credentials = ""
            if (host == null) host = ""
            if (port == null) port = 0
            return this
        }
    }
}
