// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Provides the configuration information to connect to Alfresco as your data source.
 *
 * Support for `AlfrescoConfiguration` ended May 2023. We recommend migrating to or using the Alfresco data source template schema / [TemplateConfiguration](https://docs.aws.amazon.com/kendra/latest/APIReference/API_TemplateConfiguration.html) API.
 */
public class AlfrescoConfiguration private constructor(builder: Builder) {
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Alfresco blogs to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Alfresco fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Alfresco data source field names must exist in your Alfresco custom metadata.
     */
    public val blogFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.blogFieldMappings
    /**
     * `TRUE` to index comments of blogs and other content.
     */
    public val crawlComments: kotlin.Boolean = builder.crawlComments
    /**
     * `TRUE` to index shared files.
     */
    public val crawlSystemFolders: kotlin.Boolean = builder.crawlSystemFolders
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Alfresco document libraries to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Alfresco fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Alfresco data source field names must exist in your Alfresco custom metadata.
     */
    public val documentLibraryFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.documentLibraryFieldMappings
    /**
     * Specify whether to index document libraries, wikis, or blogs. You can specify one or more of these options.
     */
    public val entityFilter: List<AlfrescoEntity>? = builder.entityFilter
    /**
     * A list of regular expression patterns to exclude certain files in your Alfresco data source. Files that match the patterns are excluded from the index. Files that don't match the patterns are included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
     */
    public val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of regular expression patterns to include certain files in your Alfresco data source. Files that match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
     */
    public val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your Alfresco data source. The secret must contain a JSON structure with the following keys:
     * + username—The user name of the Alfresco account.
     * + password—The password of the Alfresco account.
     */
    public val secretArn: kotlin.String = requireNotNull(builder.secretArn) { "A non-null value must be provided for secretArn" }
    /**
     * The identifier of the Alfresco site. For example, *my-site*.
     */
    public val siteId: kotlin.String = requireNotNull(builder.siteId) { "A non-null value must be provided for siteId" }
    /**
     * The URL of the Alfresco site. For example, *https://hostname:8080*.
     */
    public val siteUrl: kotlin.String = requireNotNull(builder.siteUrl) { "A non-null value must be provided for siteUrl" }
    /**
     * The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to Alfresco if you require a secure SSL connection.
     *
     * You can simply generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using OpenSSL to create an X509 certificate, see [Create and sign an X509 certificate](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html).
     */
    public val sslCertificateS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = builder.sslCertificateS3Path
    /**
     * Configuration information for an Amazon Virtual Private Cloud to connect to your Alfresco. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = builder.vpcConfiguration
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Alfresco wikis to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Alfresco fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Alfresco data source field names must exist in your Alfresco custom metadata.
     */
    public val wikiFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.wikiFieldMappings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.AlfrescoConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AlfrescoConfiguration(")
        append("blogFieldMappings=$blogFieldMappings,")
        append("crawlComments=$crawlComments,")
        append("crawlSystemFolders=$crawlSystemFolders,")
        append("documentLibraryFieldMappings=$documentLibraryFieldMappings,")
        append("entityFilter=$entityFilter,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("secretArn=$secretArn,")
        append("siteId=$siteId,")
        append("siteUrl=$siteUrl,")
        append("sslCertificateS3Path=$sslCertificateS3Path,")
        append("vpcConfiguration=$vpcConfiguration,")
        append("wikiFieldMappings=$wikiFieldMappings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blogFieldMappings?.hashCode() ?: 0
        result = 31 * result + (crawlComments.hashCode())
        result = 31 * result + (crawlSystemFolders.hashCode())
        result = 31 * result + (documentLibraryFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (entityFilter?.hashCode() ?: 0)
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (secretArn.hashCode())
        result = 31 * result + (siteId.hashCode())
        result = 31 * result + (siteUrl.hashCode())
        result = 31 * result + (sslCertificateS3Path?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        result = 31 * result + (wikiFieldMappings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AlfrescoConfiguration

        if (blogFieldMappings != other.blogFieldMappings) return false
        if (crawlComments != other.crawlComments) return false
        if (crawlSystemFolders != other.crawlSystemFolders) return false
        if (documentLibraryFieldMappings != other.documentLibraryFieldMappings) return false
        if (entityFilter != other.entityFilter) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (secretArn != other.secretArn) return false
        if (siteId != other.siteId) return false
        if (siteUrl != other.siteUrl) return false
        if (sslCertificateS3Path != other.sslCertificateS3Path) return false
        if (vpcConfiguration != other.vpcConfiguration) return false
        if (wikiFieldMappings != other.wikiFieldMappings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.AlfrescoConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Alfresco blogs to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Alfresco fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Alfresco data source field names must exist in your Alfresco custom metadata.
         */
        public var blogFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * `TRUE` to index comments of blogs and other content.
         */
        public var crawlComments: kotlin.Boolean = false
        /**
         * `TRUE` to index shared files.
         */
        public var crawlSystemFolders: kotlin.Boolean = false
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Alfresco document libraries to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Alfresco fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Alfresco data source field names must exist in your Alfresco custom metadata.
         */
        public var documentLibraryFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * Specify whether to index document libraries, wikis, or blogs. You can specify one or more of these options.
         */
        public var entityFilter: List<AlfrescoEntity>? = null
        /**
         * A list of regular expression patterns to exclude certain files in your Alfresco data source. Files that match the patterns are excluded from the index. Files that don't match the patterns are included in the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        public var exclusionPatterns: List<String>? = null
        /**
         * A list of regular expression patterns to include certain files in your Alfresco data source. Files that match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If a file matches both an inclusion pattern and an exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        public var inclusionPatterns: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your Alfresco data source. The secret must contain a JSON structure with the following keys:
         * + username—The user name of the Alfresco account.
         * + password—The password of the Alfresco account.
         */
        public var secretArn: kotlin.String? = null
        /**
         * The identifier of the Alfresco site. For example, *my-site*.
         */
        public var siteId: kotlin.String? = null
        /**
         * The URL of the Alfresco site. For example, *https://hostname:8080*.
         */
        public var siteUrl: kotlin.String? = null
        /**
         * The path to the SSL certificate stored in an Amazon S3 bucket. You use this to connect to Alfresco if you require a secure SSL connection.
         *
         * You can simply generate a self-signed X509 certificate on any computer using OpenSSL. For an example of using OpenSSL to create an X509 certificate, see [Create and sign an X509 certificate](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/configuring-https-ssl.html).
         */
        public var sslCertificateS3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = null
        /**
         * Configuration information for an Amazon Virtual Private Cloud to connect to your Alfresco. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Alfresco wikis to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Alfresco fields. For more information, see [ Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Alfresco data source field names must exist in your Alfresco custom metadata.
         */
        public var wikiFieldMappings: List<DataSourceToIndexFieldMapping>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.AlfrescoConfiguration) : this() {
            this.blogFieldMappings = x.blogFieldMappings
            this.crawlComments = x.crawlComments
            this.crawlSystemFolders = x.crawlSystemFolders
            this.documentLibraryFieldMappings = x.documentLibraryFieldMappings
            this.entityFilter = x.entityFilter
            this.exclusionPatterns = x.exclusionPatterns
            this.inclusionPatterns = x.inclusionPatterns
            this.secretArn = x.secretArn
            this.siteId = x.siteId
            this.siteUrl = x.siteUrl
            this.sslCertificateS3Path = x.sslCertificateS3Path
            this.vpcConfiguration = x.vpcConfiguration
            this.wikiFieldMappings = x.wikiFieldMappings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.AlfrescoConfiguration = AlfrescoConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.S3Path] inside the given [block]
         */
        public fun sslCertificateS3Path(block: aws.sdk.kotlin.services.kendra.model.S3Path.Builder.() -> kotlin.Unit) {
            this.sslCertificateS3Path = aws.sdk.kotlin.services.kendra.model.S3Path.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (secretArn == null) secretArn = ""
            if (siteId == null) siteId = ""
            if (siteUrl == null) siteUrl = ""
            return this
        }
    }
}
