// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.transform

import aws.sdk.kotlin.services.kendra.model.GetSnapshotsResponse
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.sdk.kotlin.services.kendra.model.TimeRange
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetSnapshotsOperationDeserializer: HttpDeserialize<GetSnapshotsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetSnapshotsResponse {
        if (!response.status.isSuccess()) {
            throwGetSnapshotsError(context, response)
        }
        val builder = GetSnapshotsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetSnapshotsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetSnapshotsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KendraException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetSnapshotsOperationBody(builder: GetSnapshotsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SNAPSHOTTIMEFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SnapShotTimeFilter"))
    val SNAPSHOTSDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SnapshotsData"))
    val SNAPSHOTSDATA_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val SNAPSHOTSDATAHEADER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SnapshotsDataHeader"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(SNAPSHOTTIMEFILTER_DESCRIPTOR)
        field(SNAPSHOTSDATA_DESCRIPTOR)
        field(SNAPSHOTSDATAHEADER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SNAPSHOTTIMEFILTER_DESCRIPTOR.index -> builder.snapShotTimeFilter = deserializeTimeRangeDocument(deserializer)
                SNAPSHOTSDATA_DESCRIPTOR.index -> builder.snapshotsData =
                    deserializer.deserializeList(SNAPSHOTSDATA_DESCRIPTOR) {
                        val col0 = mutableListOf<List<String>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeList(SNAPSHOTSDATA_C0_DESCRIPTOR) {
                                val col1 = mutableListOf<String>()
                                while (hasNextElement()) {
                                    val el1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                    col1.add(el1)
                                }
                                col1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                SNAPSHOTSDATAHEADER_DESCRIPTOR.index -> builder.snapshotsDataHeader =
                    deserializer.deserializeList(SNAPSHOTSDATAHEADER_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
