// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.transform

import aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsDescribeConfig
import aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsConfigResponse
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.sdk.kotlin.services.kendra.model.Mode
import aws.sdk.kotlin.services.kendra.model.QuerySuggestionsStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeQuerySuggestionsConfigOperationDeserializer: HttpDeserialize<DescribeQuerySuggestionsConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeQuerySuggestionsConfigResponse {
        if (!response.status.isSuccess()) {
            throwDescribeQuerySuggestionsConfigError(context, response)
        }
        val builder = DescribeQuerySuggestionsConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeQuerySuggestionsConfigOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeQuerySuggestionsConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KendraException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeQuerySuggestionsConfigOperationBody(builder: DescribeQuerySuggestionsConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATTRIBUTESUGGESTIONSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AttributeSuggestionsConfig"))
    val INCLUDEQUERIESWITHOUTUSERINFORMATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IncludeQueriesWithoutUserInformation"))
    val LASTCLEARTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastClearTime"))
    val LASTSUGGESTIONSBUILDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastSuggestionsBuildTime"))
    val MINIMUMNUMBEROFQUERYINGUSERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MinimumNumberOfQueryingUsers"))
    val MINIMUMQUERYCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MinimumQueryCount"))
    val MODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Mode"))
    val QUERYLOGLOOKBACKWINDOWINDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("QueryLogLookBackWindowInDays"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TOTALSUGGESTIONSCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TotalSuggestionsCount"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTESUGGESTIONSCONFIG_DESCRIPTOR)
        field(INCLUDEQUERIESWITHOUTUSERINFORMATION_DESCRIPTOR)
        field(LASTCLEARTIME_DESCRIPTOR)
        field(LASTSUGGESTIONSBUILDTIME_DESCRIPTOR)
        field(MINIMUMNUMBEROFQUERYINGUSERS_DESCRIPTOR)
        field(MINIMUMQUERYCOUNT_DESCRIPTOR)
        field(MODE_DESCRIPTOR)
        field(QUERYLOGLOOKBACKWINDOWINDAYS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TOTALSUGGESTIONSCOUNT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATTRIBUTESUGGESTIONSCONFIG_DESCRIPTOR.index -> builder.attributeSuggestionsConfig = deserializeAttributeSuggestionsDescribeConfigDocument(deserializer)
                INCLUDEQUERIESWITHOUTUSERINFORMATION_DESCRIPTOR.index -> builder.includeQueriesWithoutUserInformation = deserializeBoolean()
                LASTCLEARTIME_DESCRIPTOR.index -> builder.lastClearTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTSUGGESTIONSBUILDTIME_DESCRIPTOR.index -> builder.lastSuggestionsBuildTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MINIMUMNUMBEROFQUERYINGUSERS_DESCRIPTOR.index -> builder.minimumNumberOfQueryingUsers = deserializeInt()
                MINIMUMQUERYCOUNT_DESCRIPTOR.index -> builder.minimumQueryCount = deserializeInt()
                MODE_DESCRIPTOR.index -> builder.mode = deserializeString().let { Mode.fromValue(it) }
                QUERYLOGLOOKBACKWINDOWINDAYS_DESCRIPTOR.index -> builder.queryLogLookBackWindowInDays = deserializeInt()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { QuerySuggestionsStatus.fromValue(it) }
                TOTALSUGGESTIONSCOUNT_DESCRIPTOR.index -> builder.totalSuggestionsCount = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
