// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.transform

import aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration
import aws.sdk.kotlin.services.kendra.model.DescribeIndexResponse
import aws.sdk.kotlin.services.kendra.model.DocumentMetadataConfiguration
import aws.sdk.kotlin.services.kendra.model.IndexEdition
import aws.sdk.kotlin.services.kendra.model.IndexStatistics
import aws.sdk.kotlin.services.kendra.model.IndexStatus
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration
import aws.sdk.kotlin.services.kendra.model.UserContextPolicy
import aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration
import aws.sdk.kotlin.services.kendra.model.UserTokenConfiguration
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class DescribeIndexOperationDeserializer: HttpDeserialize<DescribeIndexResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeIndexResponse {
        if (!response.status.isSuccess()) {
            throwDescribeIndexError(context, response)
        }
        val builder = DescribeIndexResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeIndexOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeIndexError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KendraException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeIndexOperationBody(builder: DescribeIndexResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAPACITYUNITS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CapacityUnits"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val DOCUMENTMETADATACONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DocumentMetadataConfigurations"))
    val EDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Edition"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val INDEXSTATISTICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("IndexStatistics"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val SERVERSIDEENCRYPTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ServerSideEncryptionConfiguration"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdatedAt"))
    val USERCONTEXTPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("UserContextPolicy"))
    val USERGROUPRESOLUTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UserGroupResolutionConfiguration"))
    val USERTOKENCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UserTokenConfigurations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPACITYUNITS_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DOCUMENTMETADATACONFIGURATIONS_DESCRIPTOR)
        field(EDITION_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(INDEXSTATISTICS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SERVERSIDEENCRYPTIONCONFIGURATION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
        field(USERCONTEXTPOLICY_DESCRIPTOR)
        field(USERGROUPRESOLUTIONCONFIGURATION_DESCRIPTOR)
        field(USERTOKENCONFIGURATIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPACITYUNITS_DESCRIPTOR.index -> builder.capacityUnits = deserializeCapacityUnitsConfigurationDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DOCUMENTMETADATACONFIGURATIONS_DESCRIPTOR.index -> builder.documentMetadataConfigurations =
                    deserializer.deserializeList(DOCUMENTMETADATACONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<DocumentMetadataConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDocumentMetadataConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                EDITION_DESCRIPTOR.index -> builder.edition = deserializeString().let { IndexEdition.fromValue(it) }
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                INDEXSTATISTICS_DESCRIPTOR.index -> builder.indexStatistics = deserializeIndexStatisticsDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                SERVERSIDEENCRYPTIONCONFIGURATION_DESCRIPTOR.index -> builder.serverSideEncryptionConfiguration = deserializeServerSideEncryptionConfigurationDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { IndexStatus.fromValue(it) }
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                USERCONTEXTPOLICY_DESCRIPTOR.index -> builder.userContextPolicy = deserializeString().let { UserContextPolicy.fromValue(it) }
                USERGROUPRESOLUTIONCONFIGURATION_DESCRIPTOR.index -> builder.userGroupResolutionConfiguration = deserializeUserGroupResolutionConfigurationDocument(deserializer)
                USERTOKENCONFIGURATIONS_DESCRIPTOR.index -> builder.userTokenConfigurations =
                    deserializer.deserializeList(USERTOKENCONFIGURATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<UserTokenConfiguration>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUserTokenConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
