// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.transform

import aws.sdk.kotlin.services.kendra.model.DescribeFeaturedResultsSetResponse
import aws.sdk.kotlin.services.kendra.model.FeaturedDocumentMissing
import aws.sdk.kotlin.services.kendra.model.FeaturedDocumentWithMetadata
import aws.sdk.kotlin.services.kendra.model.FeaturedResultsSetStatus
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeFeaturedResultsSetOperationDeserializer: HttpDeserialize<DescribeFeaturedResultsSetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeFeaturedResultsSetResponse {
        if (!response.status.isSuccess()) {
            throwDescribeFeaturedResultsSetError(context, response)
        }
        val builder = DescribeFeaturedResultsSetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeFeaturedResultsSetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeFeaturedResultsSetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KendraException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeFeaturedResultsSetOperationBody(builder: DescribeFeaturedResultsSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("CreationTimestamp"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val FEATUREDDOCUMENTSMISSING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FeaturedDocumentsMissing"))
    val FEATUREDDOCUMENTSWITHMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FeaturedDocumentsWithMetadata"))
    val FEATUREDRESULTSSETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FeaturedResultsSetId"))
    val FEATUREDRESULTSSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FeaturedResultsSetName"))
    val LASTUPDATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("LastUpdatedTimestamp"))
    val QUERYTEXTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("QueryTexts"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIMESTAMP_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(FEATUREDDOCUMENTSMISSING_DESCRIPTOR)
        field(FEATUREDDOCUMENTSWITHMETADATA_DESCRIPTOR)
        field(FEATUREDRESULTSSETID_DESCRIPTOR)
        field(FEATUREDRESULTSSETNAME_DESCRIPTOR)
        field(LASTUPDATEDTIMESTAMP_DESCRIPTOR)
        field(QUERYTEXTS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIMESTAMP_DESCRIPTOR.index -> builder.creationTimestamp = deserializeLong()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                FEATUREDDOCUMENTSMISSING_DESCRIPTOR.index -> builder.featuredDocumentsMissing =
                    deserializer.deserializeList(FEATUREDDOCUMENTSMISSING_DESCRIPTOR) {
                        val col0 = mutableListOf<FeaturedDocumentMissing>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFeaturedDocumentMissingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FEATUREDDOCUMENTSWITHMETADATA_DESCRIPTOR.index -> builder.featuredDocumentsWithMetadata =
                    deserializer.deserializeList(FEATUREDDOCUMENTSWITHMETADATA_DESCRIPTOR) {
                        val col0 = mutableListOf<FeaturedDocumentWithMetadata>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFeaturedDocumentWithMetadataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FEATUREDRESULTSSETID_DESCRIPTOR.index -> builder.featuredResultsSetId = deserializeString()
                FEATUREDRESULTSSETNAME_DESCRIPTOR.index -> builder.featuredResultsSetName = deserializeString()
                LASTUPDATEDTIMESTAMP_DESCRIPTOR.index -> builder.lastUpdatedTimestamp = deserializeLong()
                QUERYTEXTS_DESCRIPTOR.index -> builder.queryTexts =
                    deserializer.deserializeList(QUERYTEXTS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { FeaturedResultsSetStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
