// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.transform

import aws.sdk.kotlin.services.kendra.model.BatchDeleteDocumentResponse
import aws.sdk.kotlin.services.kendra.model.BatchDeleteDocumentResponseFailedDocument
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchDeleteDocumentOperationDeserializer: HttpDeserialize<BatchDeleteDocumentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchDeleteDocumentResponse {
        if (!response.status.isSuccess()) {
            throwBatchDeleteDocumentError(context, response)
        }
        val builder = BatchDeleteDocumentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchDeleteDocumentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchDeleteDocumentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KendraException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchDeleteDocumentOperationBody(builder: BatchDeleteDocumentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILEDDOCUMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FailedDocuments"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILEDDOCUMENTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILEDDOCUMENTS_DESCRIPTOR.index -> builder.failedDocuments =
                    deserializer.deserializeList(FAILEDDOCUMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchDeleteDocumentResponseFailedDocument>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchDeleteDocumentResponseFailedDocumentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
