// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.paginators

import aws.sdk.kotlin.services.kendra.KendraClient
import aws.sdk.kotlin.services.kendra.model.GetSnapshotsRequest
import aws.sdk.kotlin.services.kendra.model.GetSnapshotsResponse
import aws.sdk.kotlin.services.kendra.model.ListAccessControlConfigurationsRequest
import aws.sdk.kotlin.services.kendra.model.ListAccessControlConfigurationsResponse
import aws.sdk.kotlin.services.kendra.model.ListDataSourceSyncJobsRequest
import aws.sdk.kotlin.services.kendra.model.ListDataSourceSyncJobsResponse
import aws.sdk.kotlin.services.kendra.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.kendra.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.kendra.model.ListEntityPersonasRequest
import aws.sdk.kotlin.services.kendra.model.ListEntityPersonasResponse
import aws.sdk.kotlin.services.kendra.model.ListExperienceEntitiesRequest
import aws.sdk.kotlin.services.kendra.model.ListExperienceEntitiesResponse
import aws.sdk.kotlin.services.kendra.model.ListExperiencesRequest
import aws.sdk.kotlin.services.kendra.model.ListExperiencesResponse
import aws.sdk.kotlin.services.kendra.model.ListFaqsRequest
import aws.sdk.kotlin.services.kendra.model.ListFaqsResponse
import aws.sdk.kotlin.services.kendra.model.ListGroupsOlderThanOrderingIdRequest
import aws.sdk.kotlin.services.kendra.model.ListGroupsOlderThanOrderingIdResponse
import aws.sdk.kotlin.services.kendra.model.ListIndicesRequest
import aws.sdk.kotlin.services.kendra.model.ListIndicesResponse
import aws.sdk.kotlin.services.kendra.model.ListQuerySuggestionsBlockListsRequest
import aws.sdk.kotlin.services.kendra.model.ListQuerySuggestionsBlockListsResponse
import aws.sdk.kotlin.services.kendra.model.ListThesauriRequest
import aws.sdk.kotlin.services.kendra.model.ListThesauriResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [GetSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetSnapshotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSnapshotsResponse]
 */
public fun KendraClient.getSnapshotsPaginated(initialRequest: GetSnapshotsRequest): Flow<GetSnapshotsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getSnapshotsPaginated.getSnapshots(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSnapshotsResponse]
 */
public fun KendraClient.getSnapshotsPaginated(block: GetSnapshotsRequest.Builder.() -> Unit): Flow<GetSnapshotsResponse> =
    getSnapshotsPaginated(GetSnapshotsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAccessControlConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessControlConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessControlConfigurationsResponse]
 */
public fun KendraClient.listAccessControlConfigurationsPaginated(initialRequest: ListAccessControlConfigurationsRequest): Flow<ListAccessControlConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessControlConfigurationsPaginated.listAccessControlConfigurations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessControlConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessControlConfigurationsResponse]
 */
public fun KendraClient.listAccessControlConfigurationsPaginated(block: ListAccessControlConfigurationsRequest.Builder.() -> Unit): Flow<ListAccessControlConfigurationsResponse> =
    listAccessControlConfigurationsPaginated(ListAccessControlConfigurationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDataSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataSourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourcesResponse]
 */
public fun KendraClient.listDataSourcesPaginated(initialRequest: ListDataSourcesRequest): Flow<ListDataSourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSourcesPaginated.listDataSources(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourcesResponse]
 */
public fun KendraClient.listDataSourcesPaginated(block: ListDataSourcesRequest.Builder.() -> Unit): Flow<ListDataSourcesResponse> =
    listDataSourcesPaginated(ListDataSourcesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListDataSourceSyncJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataSourceSyncJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourceSyncJobsResponse]
 */
public fun KendraClient.listDataSourceSyncJobsPaginated(initialRequest: ListDataSourceSyncJobsRequest): Flow<ListDataSourceSyncJobsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSourceSyncJobsPaginated.listDataSourceSyncJobs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSourceSyncJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourceSyncJobsResponse]
 */
public fun KendraClient.listDataSourceSyncJobsPaginated(block: ListDataSourceSyncJobsRequest.Builder.() -> Unit): Flow<ListDataSourceSyncJobsResponse> =
    listDataSourceSyncJobsPaginated(ListDataSourceSyncJobsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListEntityPersonasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEntityPersonasRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntityPersonasResponse]
 */
public fun KendraClient.listEntityPersonasPaginated(initialRequest: ListEntityPersonasRequest): Flow<ListEntityPersonasResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEntityPersonasPaginated.listEntityPersonas(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEntityPersonasResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEntityPersonasResponse]
 */
public fun KendraClient.listEntityPersonasPaginated(block: ListEntityPersonasRequest.Builder.() -> Unit): Flow<ListEntityPersonasResponse> =
    listEntityPersonasPaginated(ListEntityPersonasRequest.Builder().apply(block).build())

/**
 * Paginate over [ListExperienceEntitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExperienceEntitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExperienceEntitiesResponse]
 */
public fun KendraClient.listExperienceEntitiesPaginated(initialRequest: ListExperienceEntitiesRequest): Flow<ListExperienceEntitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExperienceEntitiesPaginated.listExperienceEntities(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListExperienceEntitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExperienceEntitiesResponse]
 */
public fun KendraClient.listExperienceEntitiesPaginated(block: ListExperienceEntitiesRequest.Builder.() -> Unit): Flow<ListExperienceEntitiesResponse> =
    listExperienceEntitiesPaginated(ListExperienceEntitiesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListExperiencesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExperiencesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExperiencesResponse]
 */
public fun KendraClient.listExperiencesPaginated(initialRequest: ListExperiencesRequest): Flow<ListExperiencesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExperiencesPaginated.listExperiences(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListExperiencesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExperiencesResponse]
 */
public fun KendraClient.listExperiencesPaginated(block: ListExperiencesRequest.Builder.() -> Unit): Flow<ListExperiencesResponse> =
    listExperiencesPaginated(ListExperiencesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFaqsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFaqsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFaqsResponse]
 */
public fun KendraClient.listFaqsPaginated(initialRequest: ListFaqsRequest): Flow<ListFaqsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFaqsPaginated.listFaqs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListFaqsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFaqsResponse]
 */
public fun KendraClient.listFaqsPaginated(block: ListFaqsRequest.Builder.() -> Unit): Flow<ListFaqsResponse> =
    listFaqsPaginated(ListFaqsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListGroupsOlderThanOrderingIdResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupsOlderThanOrderingIdRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsOlderThanOrderingIdResponse]
 */
public fun KendraClient.listGroupsOlderThanOrderingIdPaginated(initialRequest: ListGroupsOlderThanOrderingIdRequest): Flow<ListGroupsOlderThanOrderingIdResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroupsOlderThanOrderingIdPaginated.listGroupsOlderThanOrderingId(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupsOlderThanOrderingIdResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsOlderThanOrderingIdResponse]
 */
public fun KendraClient.listGroupsOlderThanOrderingIdPaginated(block: ListGroupsOlderThanOrderingIdRequest.Builder.() -> Unit): Flow<ListGroupsOlderThanOrderingIdResponse> =
    listGroupsOlderThanOrderingIdPaginated(ListGroupsOlderThanOrderingIdRequest.Builder().apply(block).build())

/**
 * Paginate over [ListIndicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIndicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIndicesResponse]
 */
public fun KendraClient.listIndicesPaginated(initialRequest: ListIndicesRequest): Flow<ListIndicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIndicesPaginated.listIndices(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListIndicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIndicesResponse]
 */
public fun KendraClient.listIndicesPaginated(block: ListIndicesRequest.Builder.() -> Unit): Flow<ListIndicesResponse> =
    listIndicesPaginated(ListIndicesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListQuerySuggestionsBlockListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQuerySuggestionsBlockListsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQuerySuggestionsBlockListsResponse]
 */
public fun KendraClient.listQuerySuggestionsBlockListsPaginated(initialRequest: ListQuerySuggestionsBlockListsRequest): Flow<ListQuerySuggestionsBlockListsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQuerySuggestionsBlockListsPaginated.listQuerySuggestionsBlockLists(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListQuerySuggestionsBlockListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQuerySuggestionsBlockListsResponse]
 */
public fun KendraClient.listQuerySuggestionsBlockListsPaginated(block: ListQuerySuggestionsBlockListsRequest.Builder.() -> Unit): Flow<ListQuerySuggestionsBlockListsResponse> =
    listQuerySuggestionsBlockListsPaginated(ListQuerySuggestionsBlockListsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListThesauriResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListThesauriRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListThesauriResponse]
 */
public fun KendraClient.listThesauriPaginated(initialRequest: ListThesauriRequest): Flow<ListThesauriResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listThesauriPaginated.listThesauri(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListThesauriResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListThesauriResponse]
 */
public fun KendraClient.listThesauriPaginated(block: ListThesauriRequest.Builder.() -> Unit): Flow<ListThesauriResponse> =
    listThesauriPaginated(ListThesauriRequest.Builder().apply(block).build())
