// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to get users and groups from an IAM Identity Center (successor to Single Sign-On) identity source. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents. You can also use the [PutPrincipalMapping](https://docs.aws.amazon.com/kendra/latest/dg/API_PutPrincipalMapping.html) API to map users to their groups so that you only need to provide the user ID when you issue the query.
 *
 * To set up an IAM Identity Center identity source in the console to use with Amazon Kendra, see [Getting started with an IAM Identity Center identity source](https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html). You must also grant the required permissions to use IAM Identity Center with Amazon Kendra. For more information, see [IAM roles for IAM Identity Center](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-aws-sso).
 *
 * Amazon Kendra currently does not support using `UserGroupResolutionConfiguration` with an Amazon Web Services organization member account for your IAM Identity Center identify source. You must create your index in the management account for the organization in order to use `UserGroupResolutionConfiguration`.
 */
public class UserGroupResolutionConfiguration private constructor(builder: Builder) {
    /**
     * The identity store provider (mode) you want to use to get users and groups. IAM Identity Center (successor to Single Sign-On) is currently the only available mode. Your users and groups must exist in an IAM Identity Center identity source in order to use this mode.
     */
    public val userGroupResolutionMode: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionMode? = builder.userGroupResolutionMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserGroupResolutionConfiguration(")
        append("userGroupResolutionMode=$userGroupResolutionMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = userGroupResolutionMode?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserGroupResolutionConfiguration

        if (userGroupResolutionMode != other.userGroupResolutionMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identity store provider (mode) you want to use to get users and groups. IAM Identity Center (successor to Single Sign-On) is currently the only available mode. Your users and groups must exist in an IAM Identity Center identity source in order to use this mode.
         */
        public var userGroupResolutionMode: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration) : this() {
            this.userGroupResolutionMode = x.userGroupResolutionMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration = UserGroupResolutionConfiguration(this)
    }
}
