// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



public class UpdateQuerySuggestionsConfigRequest private constructor(builder: Builder) {
    /**
     * Configuration information for the document fields/attributes that you want to base query suggestions on.
     */
    public val attributeSuggestionsConfig: aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsUpdateConfig? = builder.attributeSuggestionsConfig
    /**
     * `TRUE` to include queries without user information (i.e. all queries, irrespective of the user), otherwise `FALSE` to only include queries with user information.
     *
     * If you pass user information to Amazon Kendra along with the queries, you can set this flag to `FALSE` and instruct Amazon Kendra to only consider queries with user information.
     *
     * If you set to `FALSE`, Amazon Kendra only considers queries searched at least `MinimumQueryCount` times across `MinimumNumberOfQueryingUsers` unique users for suggestions.
     *
     * If you set to `TRUE`, Amazon Kendra ignores all user information and learns from all queries.
     */
    public val includeQueriesWithoutUserInformation: kotlin.Boolean? = builder.includeQueriesWithoutUserInformation
    /**
     * The identifier of the index with query suggestions you want to update.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.
     *
     * Increasing this number might decrease the number of suggestions. However, this ensures a query is searched by many users and is truly popular to suggest to users.
     *
     * How you tune this setting depends on your specific needs.
     */
    public val minimumNumberOfQueryingUsers: kotlin.Int? = builder.minimumNumberOfQueryingUsers
    /**
     * The the minimum number of times a query must be searched in order to be eligible to suggest to your users.
     *
     * Decreasing this number increases the number of suggestions. However, this affects the quality of suggestions as it sets a low bar for a query to be considered popular to suggest to users.
     *
     * How you tune this setting depends on your specific needs.
     */
    public val minimumQueryCount: kotlin.Int? = builder.minimumQueryCount
    /**
     * Set the mode to `ENABLED` or `LEARN_ONLY`.
     *
     * By default, Amazon Kendra enables query suggestions. `LEARN_ONLY` mode allows you to turn off query suggestions. You can to update this at any time.
     *
     * In `LEARN_ONLY` mode, Amazon Kendra continues to learn from new queries to keep suggestions up to date for when you are ready to switch to ENABLED mode again.
     */
    public val mode: aws.sdk.kotlin.services.kendra.model.Mode? = builder.mode
    /**
     * How recent your queries are in your query log time window.
     *
     * The time window is the number of days from current day to past days.
     *
     * By default, Amazon Kendra sets this to 180.
     */
    public val queryLogLookBackWindowInDays: kotlin.Int? = builder.queryLogLookBackWindowInDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateQuerySuggestionsConfigRequest(")
        append("attributeSuggestionsConfig=$attributeSuggestionsConfig,")
        append("includeQueriesWithoutUserInformation=$includeQueriesWithoutUserInformation,")
        append("indexId=$indexId,")
        append("minimumNumberOfQueryingUsers=$minimumNumberOfQueryingUsers,")
        append("minimumQueryCount=$minimumQueryCount,")
        append("mode=$mode,")
        append("queryLogLookBackWindowInDays=$queryLogLookBackWindowInDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeSuggestionsConfig?.hashCode() ?: 0
        result = 31 * result + (includeQueriesWithoutUserInformation?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (minimumNumberOfQueryingUsers ?: 0)
        result = 31 * result + (minimumQueryCount ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (queryLogLookBackWindowInDays ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateQuerySuggestionsConfigRequest

        if (attributeSuggestionsConfig != other.attributeSuggestionsConfig) return false
        if (includeQueriesWithoutUserInformation != other.includeQueriesWithoutUserInformation) return false
        if (indexId != other.indexId) return false
        if (minimumNumberOfQueryingUsers != other.minimumNumberOfQueryingUsers) return false
        if (minimumQueryCount != other.minimumQueryCount) return false
        if (mode != other.mode) return false
        if (queryLogLookBackWindowInDays != other.queryLogLookBackWindowInDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsConfigRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configuration information for the document fields/attributes that you want to base query suggestions on.
         */
        public var attributeSuggestionsConfig: aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsUpdateConfig? = null
        /**
         * `TRUE` to include queries without user information (i.e. all queries, irrespective of the user), otherwise `FALSE` to only include queries with user information.
         *
         * If you pass user information to Amazon Kendra along with the queries, you can set this flag to `FALSE` and instruct Amazon Kendra to only consider queries with user information.
         *
         * If you set to `FALSE`, Amazon Kendra only considers queries searched at least `MinimumQueryCount` times across `MinimumNumberOfQueryingUsers` unique users for suggestions.
         *
         * If you set to `TRUE`, Amazon Kendra ignores all user information and learns from all queries.
         */
        public var includeQueriesWithoutUserInformation: kotlin.Boolean? = null
        /**
         * The identifier of the index with query suggestions you want to update.
         */
        public var indexId: kotlin.String? = null
        /**
         * The minimum number of unique users who must search a query in order for the query to be eligible to suggest to your users.
         *
         * Increasing this number might decrease the number of suggestions. However, this ensures a query is searched by many users and is truly popular to suggest to users.
         *
         * How you tune this setting depends on your specific needs.
         */
        public var minimumNumberOfQueryingUsers: kotlin.Int? = null
        /**
         * The the minimum number of times a query must be searched in order to be eligible to suggest to your users.
         *
         * Decreasing this number increases the number of suggestions. However, this affects the quality of suggestions as it sets a low bar for a query to be considered popular to suggest to users.
         *
         * How you tune this setting depends on your specific needs.
         */
        public var minimumQueryCount: kotlin.Int? = null
        /**
         * Set the mode to `ENABLED` or `LEARN_ONLY`.
         *
         * By default, Amazon Kendra enables query suggestions. `LEARN_ONLY` mode allows you to turn off query suggestions. You can to update this at any time.
         *
         * In `LEARN_ONLY` mode, Amazon Kendra continues to learn from new queries to keep suggestions up to date for when you are ready to switch to ENABLED mode again.
         */
        public var mode: aws.sdk.kotlin.services.kendra.model.Mode? = null
        /**
         * How recent your queries are in your query log time window.
         *
         * The time window is the number of days from current day to past days.
         *
         * By default, Amazon Kendra sets this to 180.
         */
        public var queryLogLookBackWindowInDays: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsConfigRequest) : this() {
            this.attributeSuggestionsConfig = x.attributeSuggestionsConfig
            this.includeQueriesWithoutUserInformation = x.includeQueriesWithoutUserInformation
            this.indexId = x.indexId
            this.minimumNumberOfQueryingUsers = x.minimumNumberOfQueryingUsers
            this.minimumQueryCount = x.minimumQueryCount
            this.mode = x.mode
            this.queryLogLookBackWindowInDays = x.queryLogLookBackWindowInDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsConfigRequest = UpdateQuerySuggestionsConfigRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsUpdateConfig] inside the given [block]
         */
        public fun attributeSuggestionsConfig(block: aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsUpdateConfig.Builder.() -> kotlin.Unit) {
            this.attributeSuggestionsConfig = aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsUpdateConfig.invoke(block)
        }
    }
}
