// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



public class UpdateIndexRequest private constructor(builder: Builder) {
    /**
     * Sets the number of additional document storage and query capacity units that should be used by the index. You can change the capacity of the index up to 5 times per day, or make 5 API calls.
     *
     * If you are using extra storage units, you can't reduce the storage capacity below what is required to meet the storage needs for your index.
     */
    public val capacityUnits: aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration? = builder.capacityUnits
    /**
     * A new description for the index.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The document metadata configuration you want to update for the index. Document metadata are fields or attributes associated with your documents. For example, the company department name associated with each document.
     */
    public val documentMetadataConfigurationUpdates: List<DocumentMetadataConfiguration>? = builder.documentMetadataConfigurationUpdates
    /**
     * The identifier of the index you want to update.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the index you want to update.
     */
    public val name: kotlin.String? = builder.name
    /**
     * An Identity and Access Management (IAM) role that gives Amazon Kendra permission to access Amazon CloudWatch logs and metrics.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The user context policy.
     */
    public val userContextPolicy: aws.sdk.kotlin.services.kendra.model.UserContextPolicy? = builder.userContextPolicy
    /**
     * Enables fetching access levels of groups and users from an IAM Identity Center (successor to Single Sign-On) identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html).
     */
    public val userGroupResolutionConfiguration: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration? = builder.userGroupResolutionConfiguration
    /**
     * The user token configuration.
     */
    public val userTokenConfigurations: List<UserTokenConfiguration>? = builder.userTokenConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.UpdateIndexRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateIndexRequest(")
        append("capacityUnits=$capacityUnits,")
        append("description=$description,")
        append("documentMetadataConfigurationUpdates=$documentMetadataConfigurationUpdates,")
        append("id=$id,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("userContextPolicy=$userContextPolicy,")
        append("userGroupResolutionConfiguration=$userGroupResolutionConfiguration,")
        append("userTokenConfigurations=$userTokenConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityUnits?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (documentMetadataConfigurationUpdates?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (userContextPolicy?.hashCode() ?: 0)
        result = 31 * result + (userGroupResolutionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (userTokenConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateIndexRequest

        if (capacityUnits != other.capacityUnits) return false
        if (description != other.description) return false
        if (documentMetadataConfigurationUpdates != other.documentMetadataConfigurationUpdates) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (userContextPolicy != other.userContextPolicy) return false
        if (userGroupResolutionConfiguration != other.userGroupResolutionConfiguration) return false
        if (userTokenConfigurations != other.userTokenConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.UpdateIndexRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Sets the number of additional document storage and query capacity units that should be used by the index. You can change the capacity of the index up to 5 times per day, or make 5 API calls.
         *
         * If you are using extra storage units, you can't reduce the storage capacity below what is required to meet the storage needs for your index.
         */
        public var capacityUnits: aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration? = null
        /**
         * A new description for the index.
         */
        public var description: kotlin.String? = null
        /**
         * The document metadata configuration you want to update for the index. Document metadata are fields or attributes associated with your documents. For example, the company department name associated with each document.
         */
        public var documentMetadataConfigurationUpdates: List<DocumentMetadataConfiguration>? = null
        /**
         * The identifier of the index you want to update.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the index you want to update.
         */
        public var name: kotlin.String? = null
        /**
         * An Identity and Access Management (IAM) role that gives Amazon Kendra permission to access Amazon CloudWatch logs and metrics.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The user context policy.
         */
        public var userContextPolicy: aws.sdk.kotlin.services.kendra.model.UserContextPolicy? = null
        /**
         * Enables fetching access levels of groups and users from an IAM Identity Center (successor to Single Sign-On) identity source. To configure this, see [UserGroupResolutionConfiguration](https://docs.aws.amazon.com/kendra/latest/dg/API_UserGroupResolutionConfiguration.html).
         */
        public var userGroupResolutionConfiguration: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration? = null
        /**
         * The user token configuration.
         */
        public var userTokenConfigurations: List<UserTokenConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.UpdateIndexRequest) : this() {
            this.capacityUnits = x.capacityUnits
            this.description = x.description
            this.documentMetadataConfigurationUpdates = x.documentMetadataConfigurationUpdates
            this.id = x.id
            this.name = x.name
            this.roleArn = x.roleArn
            this.userContextPolicy = x.userContextPolicy
            this.userGroupResolutionConfiguration = x.userGroupResolutionConfiguration
            this.userTokenConfigurations = x.userTokenConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.UpdateIndexRequest = UpdateIndexRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration] inside the given [block]
         */
        public fun capacityUnits(block: aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration.Builder.() -> kotlin.Unit) {
            this.capacityUnits = aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration] inside the given [block]
         */
        public fun userGroupResolutionConfiguration(block: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration.Builder.() -> kotlin.Unit) {
            this.userGroupResolutionConfiguration = aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration.invoke(block)
        }
    }
}
