// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides information about a table cell in a table excerpt.
 */
public class TableCell private constructor(builder: Builder) {
    /**
     * `TRUE` means that the table cell should be treated as a header.
     */
    public val header: kotlin.Boolean = builder.header
    /**
     * `TRUE` means that the table cell has a high enough confidence and is relevant to the query, so the value or content should be highlighted.
     */
    public val highlighted: kotlin.Boolean = builder.highlighted
    /**
     * `TRUE` if the response of the table cell is the top answer. This is the cell value or content with the highest confidence score or is the most relevant to the query.
     */
    public val topAnswer: kotlin.Boolean = builder.topAnswer
    /**
     * The actual value or content within a table cell. A table cell could contain a date value of a year, or a string value of text, for example.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.TableCell = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TableCell(")
        append("header=$header,")
        append("highlighted=$highlighted,")
        append("topAnswer=$topAnswer,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = header.hashCode()
        result = 31 * result + (highlighted.hashCode())
        result = 31 * result + (topAnswer.hashCode())
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TableCell

        if (header != other.header) return false
        if (highlighted != other.highlighted) return false
        if (topAnswer != other.topAnswer) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.TableCell = Builder(this).apply(block).build()

    public class Builder {
        /**
         * `TRUE` means that the table cell should be treated as a header.
         */
        public var header: kotlin.Boolean = false
        /**
         * `TRUE` means that the table cell has a high enough confidence and is relevant to the query, so the value or content should be highlighted.
         */
        public var highlighted: kotlin.Boolean = false
        /**
         * `TRUE` if the response of the table cell is the top answer. This is the cell value or content with the highest confidence score or is the most relevant to the query.
         */
        public var topAnswer: kotlin.Boolean = false
        /**
         * The actual value or content within a table cell. A table cell could contain a date value of a year, or a string value of text, for example.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.TableCell) : this() {
            this.header = x.header
            this.highlighted = x.highlighted
            this.topAnswer = x.topAnswer
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.TableCell = TableCell(this)
    }
}
