// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to connect to Slack as your data source.
 */
public class SlackConfiguration private constructor(builder: Builder) {
    /**
     * `TRUE` to index bot messages from your Slack workspace team.
     */
    public val crawlBotMessage: kotlin.Boolean = builder.crawlBotMessage
    /**
     * `TRUE` to exclude archived messages to index from your Slack workspace team.
     */
    public val excludeArchived: kotlin.Boolean = builder.excludeArchived
    /**
     * A list of regular expression patterns to exclude certain attached files in your Slack workspace team. Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
     */
    public val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map Slack data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Slack fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Slack data source field names must exist in your Slack custom metadata.
     */
    public val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings
    /**
     * A list of regular expression patterns to include certain attached files in your Slack workspace team. Files that match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
     */
    public val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * The number of hours for change log to look back from when you last synchronized your data. You can look back up to 7 days or 168 hours.
     *
     * Change log updates your index only if new content was added since you last synced your data. Updated or deleted content from before you last synced does not get updated in your index. To capture updated or deleted content before you last synced, set the `LookBackPeriod` to the number of hours you want change log to look back.
     */
    public val lookBackPeriod: kotlin.Int? = builder.lookBackPeriod
    /**
     * The list of private channel names from your Slack workspace team. You use this if you want to index specific private channels, not all private channels. You can also use regular expression patterns to filter private channels.
     */
    public val privateChannelFilter: List<String>? = builder.privateChannelFilter
    /**
     * The list of public channel names to index from your Slack workspace team. You use this if you want to index specific public channels, not all public channels. You can also use regular expression patterns to filter public channels.
     */
    public val publicChannelFilter: List<String>? = builder.publicChannelFilter
    /**
     * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your Slack workspace team. The secret must contain a JSON structure with the following keys:
     * + slackToken—The user or bot token created in Slack. For more information on creating a token in Slack, see [Authentication for a Slack data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html#slack-authentication).
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * The date to start crawling your data from your Slack workspace team. The date must follow this format: `yyyy-mm-dd`.
     */
    public val sinceCrawlDate: kotlin.String? = builder.sinceCrawlDate
    /**
     * Specify whether to index public channels, private channels, group messages, and direct messages. You can specify one or more of these options.
     */
    public val slackEntityList: List<SlackEntity>? = builder.slackEntityList
    /**
     * The identifier of the team in the Slack workspace. For example, *T0123456789*.
     *
     * You can find your team ID in the URL of the main page of your Slack workspace. When you log in to Slack via a browser, you are directed to the URL of the main page. For example, *https://app.slack.com/client&#47;**T0123456789**&#47;...*.
     */
    public val teamId: kotlin.String? = builder.teamId
    /**
     * `TRUE` to use the Slack change log to determine which documents require updating in the index. Depending on the Slack change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in Slack.
     */
    public val useChangeLog: kotlin.Boolean = builder.useChangeLog
    /**
     * Configuration information for an Amazon Virtual Private Cloud to connect to your Slack. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.SlackConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SlackConfiguration(")
        append("crawlBotMessage=$crawlBotMessage,")
        append("excludeArchived=$excludeArchived,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("fieldMappings=$fieldMappings,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("lookBackPeriod=$lookBackPeriod,")
        append("privateChannelFilter=$privateChannelFilter,")
        append("publicChannelFilter=$publicChannelFilter,")
        append("secretArn=$secretArn,")
        append("sinceCrawlDate=$sinceCrawlDate,")
        append("slackEntityList=$slackEntityList,")
        append("teamId=$teamId,")
        append("useChangeLog=$useChangeLog,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = crawlBotMessage.hashCode()
        result = 31 * result + (excludeArchived.hashCode())
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (lookBackPeriod ?: 0)
        result = 31 * result + (privateChannelFilter?.hashCode() ?: 0)
        result = 31 * result + (publicChannelFilter?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (sinceCrawlDate?.hashCode() ?: 0)
        result = 31 * result + (slackEntityList?.hashCode() ?: 0)
        result = 31 * result + (teamId?.hashCode() ?: 0)
        result = 31 * result + (useChangeLog.hashCode())
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SlackConfiguration

        if (crawlBotMessage != other.crawlBotMessage) return false
        if (excludeArchived != other.excludeArchived) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (fieldMappings != other.fieldMappings) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (lookBackPeriod != other.lookBackPeriod) return false
        if (privateChannelFilter != other.privateChannelFilter) return false
        if (publicChannelFilter != other.publicChannelFilter) return false
        if (secretArn != other.secretArn) return false
        if (sinceCrawlDate != other.sinceCrawlDate) return false
        if (slackEntityList != other.slackEntityList) return false
        if (teamId != other.teamId) return false
        if (useChangeLog != other.useChangeLog) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.SlackConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * `TRUE` to index bot messages from your Slack workspace team.
         */
        public var crawlBotMessage: kotlin.Boolean = false
        /**
         * `TRUE` to exclude archived messages to index from your Slack workspace team.
         */
        public var excludeArchived: kotlin.Boolean = false
        /**
         * A list of regular expression patterns to exclude certain attached files in your Slack workspace team. Files that match the patterns are excluded from the index. Files that don’t match the patterns are included in the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        public var exclusionPatterns: List<String>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map Slack data source attributes or field names to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Slack fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Slack data source field names must exist in your Slack custom metadata.
         */
        public var fieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of regular expression patterns to include certain attached files in your Slack workspace team. Files that match the patterns are included in the index. Files that don't match the patterns are excluded from the index. If a file matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file isn't included in the index.
         */
        public var inclusionPatterns: List<String>? = null
        /**
         * The number of hours for change log to look back from when you last synchronized your data. You can look back up to 7 days or 168 hours.
         *
         * Change log updates your index only if new content was added since you last synced your data. Updated or deleted content from before you last synced does not get updated in your index. To capture updated or deleted content before you last synced, set the `LookBackPeriod` to the number of hours you want change log to look back.
         */
        public var lookBackPeriod: kotlin.Int? = null
        /**
         * The list of private channel names from your Slack workspace team. You use this if you want to index specific private channels, not all private channels. You can also use regular expression patterns to filter private channels.
         */
        public var privateChannelFilter: List<String>? = null
        /**
         * The list of public channel names to index from your Slack workspace team. You use this if you want to index specific public channels, not all public channels. You can also use regular expression patterns to filter public channels.
         */
        public var publicChannelFilter: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your Slack workspace team. The secret must contain a JSON structure with the following keys:
         * + slackToken—The user or bot token created in Slack. For more information on creating a token in Slack, see [Authentication for a Slack data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-slack.html#slack-authentication).
         */
        public var secretArn: kotlin.String? = null
        /**
         * The date to start crawling your data from your Slack workspace team. The date must follow this format: `yyyy-mm-dd`.
         */
        public var sinceCrawlDate: kotlin.String? = null
        /**
         * Specify whether to index public channels, private channels, group messages, and direct messages. You can specify one or more of these options.
         */
        public var slackEntityList: List<SlackEntity>? = null
        /**
         * The identifier of the team in the Slack workspace. For example, *T0123456789*.
         *
         * You can find your team ID in the URL of the main page of your Slack workspace. When you log in to Slack via a browser, you are directed to the URL of the main page. For example, *https://app.slack.com/client&#47;**T0123456789**&#47;...*.
         */
        public var teamId: kotlin.String? = null
        /**
         * `TRUE` to use the Slack change log to determine which documents require updating in the index. Depending on the Slack change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents in Slack.
         */
        public var useChangeLog: kotlin.Boolean = false
        /**
         * Configuration information for an Amazon Virtual Private Cloud to connect to your Slack. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.SlackConfiguration) : this() {
            this.crawlBotMessage = x.crawlBotMessage
            this.excludeArchived = x.excludeArchived
            this.exclusionPatterns = x.exclusionPatterns
            this.fieldMappings = x.fieldMappings
            this.inclusionPatterns = x.inclusionPatterns
            this.lookBackPeriod = x.lookBackPeriod
            this.privateChannelFilter = x.privateChannelFilter
            this.publicChannelFilter = x.publicChannelFilter
            this.secretArn = x.secretArn
            this.sinceCrawlDate = x.sinceCrawlDate
            this.slackEntityList = x.slackEntityList
            this.teamId = x.teamId
            this.useChangeLog = x.useChangeLog
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.SlackConfiguration = SlackConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.invoke(block)
        }
    }
}
