// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to connect to ServiceNow as your data source.
 */
public class ServiceNowConfiguration private constructor(builder: Builder) {
    /**
     * The type of authentication used to connect to the ServiceNow instance. If you choose `HTTP_BASIC`, Amazon Kendra is authenticated using the user name and password provided in the Secrets Manager secret in the `SecretArn` field. If you choose `OAUTH2`, Amazon Kendra is authenticated using the credentials of client ID, client secret, user name and password.
     *
     * When you use `OAUTH2` authentication, you must generate a token and a client secret using the ServiceNow console. For more information, see [Using a ServiceNow data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html).
     */
    public val authenticationType: aws.sdk.kotlin.services.kendra.model.ServiceNowAuthenticationType? = builder.authenticationType
    /**
     * The ServiceNow instance that the data source connects to. The host endpoint should look like the following: *{instance}.service-now.com.*
     */
    public val hostUrl: kotlin.String? = builder.hostUrl
    /**
     * Configuration information for crawling knowledge articles in the ServiceNow site.
     */
    public val knowledgeArticleConfiguration: aws.sdk.kotlin.services.kendra.model.ServiceNowKnowledgeArticleConfiguration? = builder.knowledgeArticleConfiguration
    /**
     * The Amazon Resource Name (ARN) of the Secrets Manager secret that contains the user name and password required to connect to the ServiceNow instance. You can also provide OAuth authentication credentials of user name, password, client ID, and client secret. For more information, see [Using a ServiceNow data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html).
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * Configuration information for crawling service catalogs in the ServiceNow site.
     */
    public val serviceCatalogConfiguration: aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration? = builder.serviceCatalogConfiguration
    /**
     * The identifier of the release that the ServiceNow host is running. If the host is not running the `LONDON` release, use `OTHERS`.
     */
    public val serviceNowBuildVersion: aws.sdk.kotlin.services.kendra.model.ServiceNowBuildVersionType? = builder.serviceNowBuildVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ServiceNowConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceNowConfiguration(")
        append("authenticationType=$authenticationType,")
        append("hostUrl=$hostUrl,")
        append("knowledgeArticleConfiguration=$knowledgeArticleConfiguration,")
        append("secretArn=$secretArn,")
        append("serviceCatalogConfiguration=$serviceCatalogConfiguration,")
        append("serviceNowBuildVersion=$serviceNowBuildVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationType?.hashCode() ?: 0
        result = 31 * result + (hostUrl?.hashCode() ?: 0)
        result = 31 * result + (knowledgeArticleConfiguration?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (serviceCatalogConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceNowBuildVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceNowConfiguration

        if (authenticationType != other.authenticationType) return false
        if (hostUrl != other.hostUrl) return false
        if (knowledgeArticleConfiguration != other.knowledgeArticleConfiguration) return false
        if (secretArn != other.secretArn) return false
        if (serviceCatalogConfiguration != other.serviceCatalogConfiguration) return false
        if (serviceNowBuildVersion != other.serviceNowBuildVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ServiceNowConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of authentication used to connect to the ServiceNow instance. If you choose `HTTP_BASIC`, Amazon Kendra is authenticated using the user name and password provided in the Secrets Manager secret in the `SecretArn` field. If you choose `OAUTH2`, Amazon Kendra is authenticated using the credentials of client ID, client secret, user name and password.
         *
         * When you use `OAUTH2` authentication, you must generate a token and a client secret using the ServiceNow console. For more information, see [Using a ServiceNow data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html).
         */
        public var authenticationType: aws.sdk.kotlin.services.kendra.model.ServiceNowAuthenticationType? = null
        /**
         * The ServiceNow instance that the data source connects to. The host endpoint should look like the following: *{instance}.service-now.com.*
         */
        public var hostUrl: kotlin.String? = null
        /**
         * Configuration information for crawling knowledge articles in the ServiceNow site.
         */
        public var knowledgeArticleConfiguration: aws.sdk.kotlin.services.kendra.model.ServiceNowKnowledgeArticleConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the Secrets Manager secret that contains the user name and password required to connect to the ServiceNow instance. You can also provide OAuth authentication credentials of user name, password, client ID, and client secret. For more information, see [Using a ServiceNow data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html).
         */
        public var secretArn: kotlin.String? = null
        /**
         * Configuration information for crawling service catalogs in the ServiceNow site.
         */
        public var serviceCatalogConfiguration: aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration? = null
        /**
         * The identifier of the release that the ServiceNow host is running. If the host is not running the `LONDON` release, use `OTHERS`.
         */
        public var serviceNowBuildVersion: aws.sdk.kotlin.services.kendra.model.ServiceNowBuildVersionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ServiceNowConfiguration) : this() {
            this.authenticationType = x.authenticationType
            this.hostUrl = x.hostUrl
            this.knowledgeArticleConfiguration = x.knowledgeArticleConfiguration
            this.secretArn = x.secretArn
            this.serviceCatalogConfiguration = x.serviceCatalogConfiguration
            this.serviceNowBuildVersion = x.serviceNowBuildVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ServiceNowConfiguration = ServiceNowConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ServiceNowKnowledgeArticleConfiguration] inside the given [block]
         */
        public fun knowledgeArticleConfiguration(block: aws.sdk.kotlin.services.kendra.model.ServiceNowKnowledgeArticleConfiguration.Builder.() -> kotlin.Unit) {
            this.knowledgeArticleConfiguration = aws.sdk.kotlin.services.kendra.model.ServiceNowKnowledgeArticleConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration] inside the given [block]
         */
        public fun serviceCatalogConfiguration(block: aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration.Builder.() -> kotlin.Unit) {
            this.serviceCatalogConfiguration = aws.sdk.kotlin.services.kendra.model.ServiceNowServiceCatalogConfiguration.invoke(block)
        }
    }
}
