// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides information about how a custom index field is used during a search.
 */
public class Search private constructor(builder: Builder) {
    /**
     * Determines whether the field is returned in the query response. The default is `true`.
     */
    public val displayable: kotlin.Boolean = builder.displayable
    /**
     * Indicates that the field can be used to create search facets, a count of results for each value in the field. The default is `false` .
     */
    public val facetable: kotlin.Boolean = builder.facetable
    /**
     * Determines whether the field is used in the search. If the `Searchable` field is `true`, you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is `true` for string fields and `false` for number and date fields.
     */
    public val searchable: kotlin.Boolean = builder.searchable
    /**
     * Determines whether the field can be used to sort the results of a query. If you specify sorting on a field that does not have `Sortable` set to `true`, Amazon Kendra returns an exception. The default is `false`.
     */
    public val sortable: kotlin.Boolean = builder.sortable

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.Search = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Search(")
        append("displayable=$displayable,")
        append("facetable=$facetable,")
        append("searchable=$searchable,")
        append("sortable=$sortable")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = displayable.hashCode()
        result = 31 * result + (facetable.hashCode())
        result = 31 * result + (searchable.hashCode())
        result = 31 * result + (sortable.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Search

        if (displayable != other.displayable) return false
        if (facetable != other.facetable) return false
        if (searchable != other.searchable) return false
        if (sortable != other.sortable) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.Search = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Determines whether the field is returned in the query response. The default is `true`.
         */
        public var displayable: kotlin.Boolean = false
        /**
         * Indicates that the field can be used to create search facets, a count of results for each value in the field. The default is `false` .
         */
        public var facetable: kotlin.Boolean = false
        /**
         * Determines whether the field is used in the search. If the `Searchable` field is `true`, you can use relevance tuning to manually tune how Amazon Kendra weights the field in the search. The default is `true` for string fields and `false` for number and date fields.
         */
        public var searchable: kotlin.Boolean = false
        /**
         * Determines whether the field can be used to sort the results of a query. If you specify sorting on a field that does not have `Sortable` set to `true`, Amazon Kendra returns an exception. The default is `false`.
         */
        public var sortable: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.Search) : this() {
            this.displayable = x.displayable
            this.facetable = x.facetable
            this.searchable = x.searchable
            this.sortable = x.sortable
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.Search = Search(this)
    }
}
