// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information for indexing Salesforce custom articles.
 */
public class SalesforceCustomKnowledgeArticleTypeConfiguration private constructor(builder: Builder) {
    /**
     * The name of the field in the custom knowledge article that contains the document data to index.
     */
    public val documentDataFieldName: kotlin.String? = builder.documentDataFieldName
    /**
     * The name of the field in the custom knowledge article that contains the document title.
     */
    public val documentTitleFieldName: kotlin.String? = builder.documentTitleFieldName
    /**
     * Maps attributes or field names of the custom knowledge article to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Salesforce fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Salesforce data source field names must exist in your Salesforce custom metadata.
     */
    public val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings
    /**
     * The name of the configuration.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SalesforceCustomKnowledgeArticleTypeConfiguration(")
        append("documentDataFieldName=$documentDataFieldName,")
        append("documentTitleFieldName=$documentTitleFieldName,")
        append("fieldMappings=$fieldMappings,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentDataFieldName?.hashCode() ?: 0
        result = 31 * result + (documentTitleFieldName?.hashCode() ?: 0)
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SalesforceCustomKnowledgeArticleTypeConfiguration

        if (documentDataFieldName != other.documentDataFieldName) return false
        if (documentTitleFieldName != other.documentTitleFieldName) return false
        if (fieldMappings != other.fieldMappings) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the field in the custom knowledge article that contains the document data to index.
         */
        public var documentDataFieldName: kotlin.String? = null
        /**
         * The name of the field in the custom knowledge article that contains the document title.
         */
        public var documentTitleFieldName: kotlin.String? = null
        /**
         * Maps attributes or field names of the custom knowledge article to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Salesforce fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Salesforce data source field names must exist in your Salesforce custom metadata.
         */
        public var fieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * The name of the configuration.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration) : this() {
            this.documentDataFieldName = x.documentDataFieldName
            this.documentTitleFieldName = x.documentTitleFieldName
            this.fieldMappings = x.fieldMappings
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.SalesforceCustomKnowledgeArticleTypeConfiguration = SalesforceCustomKnowledgeArticleTypeConfiguration(this)
    }
}
