// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * A single query result.
 *
 * A query result contains information about a document returned by the query. This includes the original location of the document, a list of attributes assigned to the document, and relevant text from the document that satisfies the query.
 */
public class QueryResultItem private constructor(builder: Builder) {
    /**
     * One or more additional attributes associated with the query result.
     */
    public val additionalAttributes: List<AdditionalResultAttribute>? = builder.additionalAttributes
    /**
     * An array of document attributes assigned to a document in the search results. For example, the document author (`_author`) or the source URI (`_source_uri`) of the document.
     */
    public val documentAttributes: List<DocumentAttribute>? = builder.documentAttributes
    /**
     * An extract of the text in the document. Contains information about highlighting the relevant terms in the excerpt.
     */
    public val documentExcerpt: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = builder.documentExcerpt
    /**
     * The identifier for the document.
     */
    public val documentId: kotlin.String? = builder.documentId
    /**
     * The title of the document. Contains the text of the title and information for highlighting the relevant terms in the title.
     */
    public val documentTitle: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = builder.documentTitle
    /**
     * The URI of the original location of the document.
     */
    public val documentUri: kotlin.String? = builder.documentUri
    /**
     * A token that identifies a particular result from a particular query. Use this token to provide click-through feedback for the result. For more information, see [Submitting feedback ](https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html).
     */
    public val feedbackToken: kotlin.String? = builder.feedbackToken
    /**
     * If the `Type` of document within the response is `ANSWER`, then it is either a `TABLE` answer or `TEXT` answer. If it's a table answer, a table excerpt is returned in `TableExcerpt`. If it's a text answer, a text excerpt is returned in `DocumentExcerpt`.
     */
    public val format: aws.sdk.kotlin.services.kendra.model.QueryResultFormat? = builder.format
    /**
     * The identifier for the query result.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Indicates the confidence that Amazon Kendra has that a result matches the query that you provided. Each result is placed into a bin that indicates the confidence, `VERY_HIGH`, `HIGH`, `MEDIUM` and `LOW`. You can use the score to determine if a response meets the confidence needed for your application.
     *
     * The field is only set to `LOW` when the `Type` field is set to `DOCUMENT` and Amazon Kendra is not confident that the result matches the query.
     */
    public val scoreAttributes: aws.sdk.kotlin.services.kendra.model.ScoreAttributes? = builder.scoreAttributes
    /**
     * An excerpt from a table within a document.
     */
    public val tableExcerpt: aws.sdk.kotlin.services.kendra.model.TableExcerpt? = builder.tableExcerpt
    /**
     * The type of document within the response. For example, a response could include a question-answer that's relevant to the query.
     */
    public val type: aws.sdk.kotlin.services.kendra.model.QueryResultType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.QueryResultItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryResultItem(")
        append("additionalAttributes=$additionalAttributes,")
        append("documentAttributes=$documentAttributes,")
        append("documentExcerpt=$documentExcerpt,")
        append("documentId=$documentId,")
        append("documentTitle=$documentTitle,")
        append("documentUri=$documentUri,")
        append("feedbackToken=$feedbackToken,")
        append("format=$format,")
        append("id=$id,")
        append("scoreAttributes=$scoreAttributes,")
        append("tableExcerpt=$tableExcerpt,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalAttributes?.hashCode() ?: 0
        result = 31 * result + (documentAttributes?.hashCode() ?: 0)
        result = 31 * result + (documentExcerpt?.hashCode() ?: 0)
        result = 31 * result + (documentId?.hashCode() ?: 0)
        result = 31 * result + (documentTitle?.hashCode() ?: 0)
        result = 31 * result + (documentUri?.hashCode() ?: 0)
        result = 31 * result + (feedbackToken?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (scoreAttributes?.hashCode() ?: 0)
        result = 31 * result + (tableExcerpt?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryResultItem

        if (additionalAttributes != other.additionalAttributes) return false
        if (documentAttributes != other.documentAttributes) return false
        if (documentExcerpt != other.documentExcerpt) return false
        if (documentId != other.documentId) return false
        if (documentTitle != other.documentTitle) return false
        if (documentUri != other.documentUri) return false
        if (feedbackToken != other.feedbackToken) return false
        if (format != other.format) return false
        if (id != other.id) return false
        if (scoreAttributes != other.scoreAttributes) return false
        if (tableExcerpt != other.tableExcerpt) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.QueryResultItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * One or more additional attributes associated with the query result.
         */
        public var additionalAttributes: List<AdditionalResultAttribute>? = null
        /**
         * An array of document attributes assigned to a document in the search results. For example, the document author (`_author`) or the source URI (`_source_uri`) of the document.
         */
        public var documentAttributes: List<DocumentAttribute>? = null
        /**
         * An extract of the text in the document. Contains information about highlighting the relevant terms in the excerpt.
         */
        public var documentExcerpt: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = null
        /**
         * The identifier for the document.
         */
        public var documentId: kotlin.String? = null
        /**
         * The title of the document. Contains the text of the title and information for highlighting the relevant terms in the title.
         */
        public var documentTitle: aws.sdk.kotlin.services.kendra.model.TextWithHighlights? = null
        /**
         * The URI of the original location of the document.
         */
        public var documentUri: kotlin.String? = null
        /**
         * A token that identifies a particular result from a particular query. Use this token to provide click-through feedback for the result. For more information, see [Submitting feedback ](https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html).
         */
        public var feedbackToken: kotlin.String? = null
        /**
         * If the `Type` of document within the response is `ANSWER`, then it is either a `TABLE` answer or `TEXT` answer. If it's a table answer, a table excerpt is returned in `TableExcerpt`. If it's a text answer, a text excerpt is returned in `DocumentExcerpt`.
         */
        public var format: aws.sdk.kotlin.services.kendra.model.QueryResultFormat? = null
        /**
         * The identifier for the query result.
         */
        public var id: kotlin.String? = null
        /**
         * Indicates the confidence that Amazon Kendra has that a result matches the query that you provided. Each result is placed into a bin that indicates the confidence, `VERY_HIGH`, `HIGH`, `MEDIUM` and `LOW`. You can use the score to determine if a response meets the confidence needed for your application.
         *
         * The field is only set to `LOW` when the `Type` field is set to `DOCUMENT` and Amazon Kendra is not confident that the result matches the query.
         */
        public var scoreAttributes: aws.sdk.kotlin.services.kendra.model.ScoreAttributes? = null
        /**
         * An excerpt from a table within a document.
         */
        public var tableExcerpt: aws.sdk.kotlin.services.kendra.model.TableExcerpt? = null
        /**
         * The type of document within the response. For example, a response could include a question-answer that's relevant to the query.
         */
        public var type: aws.sdk.kotlin.services.kendra.model.QueryResultType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.QueryResultItem) : this() {
            this.additionalAttributes = x.additionalAttributes
            this.documentAttributes = x.documentAttributes
            this.documentExcerpt = x.documentExcerpt
            this.documentId = x.documentId
            this.documentTitle = x.documentTitle
            this.documentUri = x.documentUri
            this.feedbackToken = x.feedbackToken
            this.format = x.format
            this.id = x.id
            this.scoreAttributes = x.scoreAttributes
            this.tableExcerpt = x.tableExcerpt
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.QueryResultItem = QueryResultItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.TextWithHighlights] inside the given [block]
         */
        public fun documentExcerpt(block: aws.sdk.kotlin.services.kendra.model.TextWithHighlights.Builder.() -> kotlin.Unit) {
            this.documentExcerpt = aws.sdk.kotlin.services.kendra.model.TextWithHighlights.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.TextWithHighlights] inside the given [block]
         */
        public fun documentTitle(block: aws.sdk.kotlin.services.kendra.model.TextWithHighlights.Builder.() -> kotlin.Unit) {
            this.documentTitle = aws.sdk.kotlin.services.kendra.model.TextWithHighlights.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ScoreAttributes] inside the given [block]
         */
        public fun scoreAttributes(block: aws.sdk.kotlin.services.kendra.model.ScoreAttributes.Builder.() -> kotlin.Unit) {
            this.scoreAttributes = aws.sdk.kotlin.services.kendra.model.ScoreAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.TableExcerpt] inside the given [block]
         */
        public fun tableExcerpt(block: aws.sdk.kotlin.services.kendra.model.TableExcerpt.Builder.() -> kotlin.Unit) {
            this.tableExcerpt = aws.sdk.kotlin.services.kendra.model.TableExcerpt.invoke(block)
        }
    }
}
