// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



public class QueryResponse private constructor(builder: Builder) {
    /**
     * Contains the facet results. A `FacetResult` contains the counts for each attribute key that was specified in the `Facets` input parameter.
     */
    public val facetResults: List<FacetResult>? = builder.facetResults
    /**
     * The list of featured result items. Featured results are displayed at the top of the search results page, placed above all other results for certain queries. If there's an exact match of a query, then certain documents are featured in the search results.
     */
    public val featuredResultsItems: List<FeaturedResultsItem>? = builder.featuredResultsItems
    /**
     * The identifier for the search. You use `QueryId` to identify the search when using the feedback API.
     */
    public val queryId: kotlin.String? = builder.queryId
    /**
     * The results of the search.
     */
    public val resultItems: List<QueryResultItem>? = builder.resultItems
    /**
     * A list of information related to suggested spell corrections for a query.
     */
    public val spellCorrectedQueries: List<SpellCorrectedQuery>? = builder.spellCorrectedQueries
    /**
     * The total number of items found by the search; however, you can only retrieve up to 100 items. For example, if the search found 192 items, you can only retrieve the first 100 of the items.
     */
    public val totalNumberOfResults: kotlin.Int? = builder.totalNumberOfResults
    /**
     * A list of warning codes and their messages on problems with your query.
     *
     * Amazon Kendra currently only supports one type of warning, which is a warning on invalid syntax used in the query. For examples of invalid query syntax, see [Searching with advanced query syntax](https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax).
     */
    public val warnings: List<Warning>? = builder.warnings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.QueryResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryResponse(")
        append("facetResults=$facetResults,")
        append("featuredResultsItems=$featuredResultsItems,")
        append("queryId=$queryId,")
        append("resultItems=$resultItems,")
        append("spellCorrectedQueries=$spellCorrectedQueries,")
        append("totalNumberOfResults=$totalNumberOfResults,")
        append("warnings=$warnings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = facetResults?.hashCode() ?: 0
        result = 31 * result + (featuredResultsItems?.hashCode() ?: 0)
        result = 31 * result + (queryId?.hashCode() ?: 0)
        result = 31 * result + (resultItems?.hashCode() ?: 0)
        result = 31 * result + (spellCorrectedQueries?.hashCode() ?: 0)
        result = 31 * result + (totalNumberOfResults ?: 0)
        result = 31 * result + (warnings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryResponse

        if (facetResults != other.facetResults) return false
        if (featuredResultsItems != other.featuredResultsItems) return false
        if (queryId != other.queryId) return false
        if (resultItems != other.resultItems) return false
        if (spellCorrectedQueries != other.spellCorrectedQueries) return false
        if (totalNumberOfResults != other.totalNumberOfResults) return false
        if (warnings != other.warnings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.QueryResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains the facet results. A `FacetResult` contains the counts for each attribute key that was specified in the `Facets` input parameter.
         */
        public var facetResults: List<FacetResult>? = null
        /**
         * The list of featured result items. Featured results are displayed at the top of the search results page, placed above all other results for certain queries. If there's an exact match of a query, then certain documents are featured in the search results.
         */
        public var featuredResultsItems: List<FeaturedResultsItem>? = null
        /**
         * The identifier for the search. You use `QueryId` to identify the search when using the feedback API.
         */
        public var queryId: kotlin.String? = null
        /**
         * The results of the search.
         */
        public var resultItems: List<QueryResultItem>? = null
        /**
         * A list of information related to suggested spell corrections for a query.
         */
        public var spellCorrectedQueries: List<SpellCorrectedQuery>? = null
        /**
         * The total number of items found by the search; however, you can only retrieve up to 100 items. For example, if the search found 192 items, you can only retrieve the first 100 of the items.
         */
        public var totalNumberOfResults: kotlin.Int? = null
        /**
         * A list of warning codes and their messages on problems with your query.
         *
         * Amazon Kendra currently only supports one type of warning, which is a warning on invalid syntax used in the query. For examples of invalid query syntax, see [Searching with advanced query syntax](https://docs.aws.amazon.com/kendra/latest/dg/searching-example.html#searching-index-query-syntax).
         */
        public var warnings: List<Warning>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.QueryResponse) : this() {
            this.facetResults = x.facetResults
            this.featuredResultsItems = x.featuredResultsItems
            this.queryId = x.queryId
            this.resultItems = x.resultItems
            this.spellCorrectedQueries = x.spellCorrectedQueries
            this.totalNumberOfResults = x.totalNumberOfResults
            this.warnings = x.warnings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.QueryResponse = QueryResponse(this)
    }
}
