// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Summary information for a set of featured results. Featured results are placed above all other results for certain queries. If there's an exact match of a query, then one or more specific documents are featured in the search results.
 */
public class FeaturedResultsSetSummary private constructor(builder: Builder) {
    /**
     * The Unix timestamp when the set of featured results was created.
     */
    public val creationTimestamp: kotlin.Long? = builder.creationTimestamp
    /**
     * The identifier of the set of featured results.
     */
    public val featuredResultsSetId: kotlin.String? = builder.featuredResultsSetId
    /**
     * The name for the set of featured results.
     */
    public val featuredResultsSetName: kotlin.String? = builder.featuredResultsSetName
    /**
     * The Unix timestamp when the set of featured results was last updated.
     */
    public val lastUpdatedTimestamp: kotlin.Long? = builder.lastUpdatedTimestamp
    /**
     * The current status of the set of featured results. When the value is `ACTIVE`, featured results are ready for use. You can still configure your settings before setting the status to `ACTIVE`. You can set the status to `ACTIVE` or `INACTIVE` using the [UpdateFeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html) API. The queries you specify for featured results must be unique per featured results set for each index, whether the status is `ACTIVE` or `INACTIVE`.
     */
    public val status: aws.sdk.kotlin.services.kendra.model.FeaturedResultsSetStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.FeaturedResultsSetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FeaturedResultsSetSummary(")
        append("creationTimestamp=$creationTimestamp,")
        append("featuredResultsSetId=$featuredResultsSetId,")
        append("featuredResultsSetName=$featuredResultsSetName,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (featuredResultsSetId?.hashCode() ?: 0)
        result = 31 * result + (featuredResultsSetName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FeaturedResultsSetSummary

        if (creationTimestamp != other.creationTimestamp) return false
        if (featuredResultsSetId != other.featuredResultsSetId) return false
        if (featuredResultsSetName != other.featuredResultsSetName) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.FeaturedResultsSetSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Unix timestamp when the set of featured results was created.
         */
        public var creationTimestamp: kotlin.Long? = null
        /**
         * The identifier of the set of featured results.
         */
        public var featuredResultsSetId: kotlin.String? = null
        /**
         * The name for the set of featured results.
         */
        public var featuredResultsSetName: kotlin.String? = null
        /**
         * The Unix timestamp when the set of featured results was last updated.
         */
        public var lastUpdatedTimestamp: kotlin.Long? = null
        /**
         * The current status of the set of featured results. When the value is `ACTIVE`, featured results are ready for use. You can still configure your settings before setting the status to `ACTIVE`. You can set the status to `ACTIVE` or `INACTIVE` using the [UpdateFeaturedResultsSet](https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateFeaturedResultsSet.html) API. The queries you specify for featured results must be unique per featured results set for each index, whether the status is `ACTIVE` or `INACTIVE`.
         */
        public var status: aws.sdk.kotlin.services.kendra.model.FeaturedResultsSetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.FeaturedResultsSetSummary) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.featuredResultsSetId = x.featuredResultsSetId
            this.featuredResultsSetName = x.featuredResultsSetName
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.FeaturedResultsSetSummary = FeaturedResultsSetSummary(this)
    }
}
