// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * An error message with a list of conflicting queries used across different sets of featured results. This occurred with the request for a new featured results set. Check that the queries you specified for featured results are unique per featured results set for each index.
 */
public class FeaturedResultsConflictException private constructor(builder: Builder) : KendraException() {

    /**
     * A list of the conflicting queries, including the query text, the name for the featured results set, and the identifier of the featured results set.
     */
    public val conflictingItems: List<ConflictingItem>? = builder.conflictingItems
    /**
     * An explanation for the conflicting queries.
     */
    override val message: kotlin.String? = builder.message

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.FeaturedResultsConflictException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FeaturedResultsConflictException(")
        append("conflictingItems=$conflictingItems,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = conflictingItems?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FeaturedResultsConflictException

        if (conflictingItems != other.conflictingItems) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.FeaturedResultsConflictException = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of the conflicting queries, including the query text, the name for the featured results set, and the identifier of the featured results set.
         */
        public var conflictingItems: List<ConflictingItem>? = null
        /**
         * An explanation for the conflicting queries.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.FeaturedResultsConflictException) : this() {
            this.conflictingItems = x.conflictingItems
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.FeaturedResultsConflictException = FeaturedResultsConflictException(this)
    }
}
