// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information for users or groups in your IAM Identity Center identity source for access to your Amazon Kendra experience. Specific permissions are defined for each user or group once they are granted access to your Amazon Kendra experience.
 */
public class EntityPersonaConfiguration private constructor(builder: Builder) {
    /**
     * The identifier of a user or group in your IAM Identity Center identity source. For example, a user ID could be an email.
     */
    public val entityId: kotlin.String? = builder.entityId
    /**
     * The persona that defines the specific permissions of the user or group in your IAM Identity Center identity source. The available personas or access roles are `Owner` and `Viewer`. For more information on these personas, see [Providing access to your search page](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience).
     */
    public val persona: aws.sdk.kotlin.services.kendra.model.Persona? = builder.persona

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.EntityPersonaConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntityPersonaConfiguration(")
        append("entityId=$entityId,")
        append("persona=$persona")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = entityId?.hashCode() ?: 0
        result = 31 * result + (persona?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntityPersonaConfiguration

        if (entityId != other.entityId) return false
        if (persona != other.persona) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.EntityPersonaConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of a user or group in your IAM Identity Center identity source. For example, a user ID could be an email.
         */
        public var entityId: kotlin.String? = null
        /**
         * The persona that defines the specific permissions of the user or group in your IAM Identity Center identity source. The available personas or access roles are `Owner` and `Viewer`. For more information on these personas, see [Providing access to your search page](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience).
         */
        public var persona: aws.sdk.kotlin.services.kendra.model.Persona? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.EntityPersonaConfiguration) : this() {
            this.entityId = x.entityId
            this.persona = x.persona
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.EntityPersonaConfiguration = EntityPersonaConfiguration(this)
    }
}
