// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * A document in an index.
 */
public class Document private constructor(builder: Builder) {
    /**
     * The identifier of the access control configuration that you want to apply to the document.
     */
    public val accessControlConfigurationId: kotlin.String? = builder.accessControlConfigurationId
    /**
     * Information on principals (users and/or groups) and which documents they should have access to. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
     */
    public val accessControlList: List<Principal>? = builder.accessControlList
    /**
     * Custom attributes to apply to the document. Use the custom attributes to provide additional information for searching, to provide facets for refining searches, and to provide additional information in the query response.
     *
     * For example, 'DataSourceId' and 'DataSourceSyncJobId' are custom attributes that provide information on the synchronization of documents running on a data source. Note, 'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use the ID of a running sync job.
     */
    public val attributes: List<DocumentAttribute>? = builder.attributes
    /**
     * The contents of the document.
     *
     * Documents passed to the `Blob` parameter must be base64 encoded. Your code might not need to encode the document file bytes if you're using an Amazon Web Services SDK to call Amazon Kendra APIs. If you are calling the Amazon Kendra endpoint directly using REST, you must base64 encode the contents before sending.
     */
    public val blob: kotlin.ByteArray? = builder.blob
    /**
     * The file type of the document in the `Blob` field.
     */
    public val contentType: aws.sdk.kotlin.services.kendra.model.ContentType? = builder.contentType
    /**
     * The list of [principal](https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html) lists that define the hierarchy for which documents users should have access to.
     */
    public val hierarchicalAccessControlList: List<HierarchicalPrincipal>? = builder.hierarchicalAccessControlList
    /**
     * A identifier of the document in the index.
     *
     * Note, each document ID must be unique per index. You cannot create a data source to index your documents with their unique IDs and then use the `BatchPutDocument` API to index the same documents, or vice versa. You can delete a data source and then use the `BatchPutDocument` API to index the same documents, or vice versa.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Information required to find a specific file in an Amazon S3 bucket.
     */
    public val s3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = builder.s3Path
    /**
     * The title of the document.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.Document = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Document(")
        append("accessControlConfigurationId=$accessControlConfigurationId,")
        append("accessControlList=$accessControlList,")
        append("attributes=$attributes,")
        append("blob=$blob,")
        append("contentType=$contentType,")
        append("hierarchicalAccessControlList=$hierarchicalAccessControlList,")
        append("id=$id,")
        append("s3Path=$s3Path,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessControlConfigurationId?.hashCode() ?: 0
        result = 31 * result + (accessControlList?.hashCode() ?: 0)
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (blob?.contentHashCode() ?: 0)
        result = 31 * result + (contentType?.hashCode() ?: 0)
        result = 31 * result + (hierarchicalAccessControlList?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (s3Path?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Document

        if (accessControlConfigurationId != other.accessControlConfigurationId) return false
        if (accessControlList != other.accessControlList) return false
        if (attributes != other.attributes) return false
        if (blob != null) {
            if (other.blob == null) return false
            if (!blob.contentEquals(other.blob)) return false
        } else if (other.blob != null) return false
        if (contentType != other.contentType) return false
        if (hierarchicalAccessControlList != other.hierarchicalAccessControlList) return false
        if (id != other.id) return false
        if (s3Path != other.s3Path) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.Document = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the access control configuration that you want to apply to the document.
         */
        public var accessControlConfigurationId: kotlin.String? = null
        /**
         * Information on principals (users and/or groups) and which documents they should have access to. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
         */
        public var accessControlList: List<Principal>? = null
        /**
         * Custom attributes to apply to the document. Use the custom attributes to provide additional information for searching, to provide facets for refining searches, and to provide additional information in the query response.
         *
         * For example, 'DataSourceId' and 'DataSourceSyncJobId' are custom attributes that provide information on the synchronization of documents running on a data source. Note, 'DataSourceSyncJobId' could be an optional custom attribute as Amazon Kendra will use the ID of a running sync job.
         */
        public var attributes: List<DocumentAttribute>? = null
        /**
         * The contents of the document.
         *
         * Documents passed to the `Blob` parameter must be base64 encoded. Your code might not need to encode the document file bytes if you're using an Amazon Web Services SDK to call Amazon Kendra APIs. If you are calling the Amazon Kendra endpoint directly using REST, you must base64 encode the contents before sending.
         */
        public var blob: kotlin.ByteArray? = null
        /**
         * The file type of the document in the `Blob` field.
         */
        public var contentType: aws.sdk.kotlin.services.kendra.model.ContentType? = null
        /**
         * The list of [principal](https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html) lists that define the hierarchy for which documents users should have access to.
         */
        public var hierarchicalAccessControlList: List<HierarchicalPrincipal>? = null
        /**
         * A identifier of the document in the index.
         *
         * Note, each document ID must be unique per index. You cannot create a data source to index your documents with their unique IDs and then use the `BatchPutDocument` API to index the same documents, or vice versa. You can delete a data source and then use the `BatchPutDocument` API to index the same documents, or vice versa.
         */
        public var id: kotlin.String? = null
        /**
         * Information required to find a specific file in an Amazon S3 bucket.
         */
        public var s3Path: aws.sdk.kotlin.services.kendra.model.S3Path? = null
        /**
         * The title of the document.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.Document) : this() {
            this.accessControlConfigurationId = x.accessControlConfigurationId
            this.accessControlList = x.accessControlList
            this.attributes = x.attributes
            this.blob = x.blob
            this.contentType = x.contentType
            this.hierarchicalAccessControlList = x.hierarchicalAccessControlList
            this.id = x.id
            this.s3Path = x.s3Path
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.Document = Document(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.S3Path] inside the given [block]
         */
        public fun s3Path(block: aws.sdk.kotlin.services.kendra.model.S3Path.Builder.() -> kotlin.Unit) {
            this.s3Path = aws.sdk.kotlin.services.kendra.model.S3Path.invoke(block)
        }
    }
}
