// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeIndexResponse private constructor(builder: Builder) {
    /**
     * For Enterprise Edition indexes, you can choose to use additional capacity to meet the needs of your application. This contains the capacity units used for the index. A query or document storage capacity of zero indicates that the index is using the default capacity. For more information on the default capacity for an index and adjusting this, see [Adjusting capacity](https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html).
     */
    public val capacityUnits: aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration? = builder.capacityUnits
    /**
     * The Unix timestamp when the index was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The description for the index.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Configuration information for document metadata or fields. Document metadata are fields or attributes associated with your documents. For example, the company department name associated with each document.
     */
    public val documentMetadataConfigurations: List<DocumentMetadataConfiguration>? = builder.documentMetadataConfigurations
    /**
     * The Amazon Kendra edition used for the index. You decide the edition when you create the index.
     */
    public val edition: aws.sdk.kotlin.services.kendra.model.IndexEdition? = builder.edition
    /**
     * When the `Status` field value is `FAILED`, the `ErrorMessage` field contains a message that explains why.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * The identifier of the index.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Provides information about the number of FAQ questions and answers and the number of text documents indexed.
     */
    public val indexStatistics: aws.sdk.kotlin.services.kendra.model.IndexStatistics? = builder.indexStatistics
    /**
     * The name of the index.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission to write to your Amazon Cloudwatch logs.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The identifier of the KMScustomer master key (CMK) that is used to encrypt your data. Amazon Kendra doesn't support asymmetric CMKs.
     */
    public val serverSideEncryptionConfiguration: aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration? = builder.serverSideEncryptionConfiguration
    /**
     * The current status of the index. When the value is `ACTIVE`, the index is ready for use. If the `Status` field value is `FAILED`, the `ErrorMessage` field contains a message that explains why.
     */
    public val status: aws.sdk.kotlin.services.kendra.model.IndexStatus? = builder.status
    /**
     * The Unix when the index was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt
    /**
     * The user context policy for the Amazon Kendra index.
     */
    public val userContextPolicy: aws.sdk.kotlin.services.kendra.model.UserContextPolicy? = builder.userContextPolicy
    /**
     * Whether you have enabled the configuration for fetching access levels of groups and users from an IAM Identity Center (successor to Single Sign-On) identity source.
     */
    public val userGroupResolutionConfiguration: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration? = builder.userGroupResolutionConfiguration
    /**
     * The user token configuration for the Amazon Kendra index.
     */
    public val userTokenConfigurations: List<UserTokenConfiguration>? = builder.userTokenConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DescribeIndexResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeIndexResponse(")
        append("capacityUnits=$capacityUnits,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("documentMetadataConfigurations=$documentMetadataConfigurations,")
        append("edition=$edition,")
        append("errorMessage=$errorMessage,")
        append("id=$id,")
        append("indexStatistics=$indexStatistics,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("serverSideEncryptionConfiguration=$serverSideEncryptionConfiguration,")
        append("status=$status,")
        append("updatedAt=$updatedAt,")
        append("userContextPolicy=$userContextPolicy,")
        append("userGroupResolutionConfiguration=$userGroupResolutionConfiguration,")
        append("userTokenConfigurations=$userTokenConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityUnits?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (documentMetadataConfigurations?.hashCode() ?: 0)
        result = 31 * result + (edition?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (indexStatistics?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        result = 31 * result + (userContextPolicy?.hashCode() ?: 0)
        result = 31 * result + (userGroupResolutionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (userTokenConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeIndexResponse

        if (capacityUnits != other.capacityUnits) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (documentMetadataConfigurations != other.documentMetadataConfigurations) return false
        if (edition != other.edition) return false
        if (errorMessage != other.errorMessage) return false
        if (id != other.id) return false
        if (indexStatistics != other.indexStatistics) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (serverSideEncryptionConfiguration != other.serverSideEncryptionConfiguration) return false
        if (status != other.status) return false
        if (updatedAt != other.updatedAt) return false
        if (userContextPolicy != other.userContextPolicy) return false
        if (userGroupResolutionConfiguration != other.userGroupResolutionConfiguration) return false
        if (userTokenConfigurations != other.userTokenConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DescribeIndexResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * For Enterprise Edition indexes, you can choose to use additional capacity to meet the needs of your application. This contains the capacity units used for the index. A query or document storage capacity of zero indicates that the index is using the default capacity. For more information on the default capacity for an index and adjusting this, see [Adjusting capacity](https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html).
         */
        public var capacityUnits: aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration? = null
        /**
         * The Unix timestamp when the index was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description for the index.
         */
        public var description: kotlin.String? = null
        /**
         * Configuration information for document metadata or fields. Document metadata are fields or attributes associated with your documents. For example, the company department name associated with each document.
         */
        public var documentMetadataConfigurations: List<DocumentMetadataConfiguration>? = null
        /**
         * The Amazon Kendra edition used for the index. You decide the edition when you create the index.
         */
        public var edition: aws.sdk.kotlin.services.kendra.model.IndexEdition? = null
        /**
         * When the `Status` field value is `FAILED`, the `ErrorMessage` field contains a message that explains why.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * The identifier of the index.
         */
        public var id: kotlin.String? = null
        /**
         * Provides information about the number of FAQ questions and answers and the number of text documents indexed.
         */
        public var indexStatistics: aws.sdk.kotlin.services.kendra.model.IndexStatistics? = null
        /**
         * The name of the index.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that gives Amazon Kendra permission to write to your Amazon Cloudwatch logs.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The identifier of the KMScustomer master key (CMK) that is used to encrypt your data. Amazon Kendra doesn't support asymmetric CMKs.
         */
        public var serverSideEncryptionConfiguration: aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration? = null
        /**
         * The current status of the index. When the value is `ACTIVE`, the index is ready for use. If the `Status` field value is `FAILED`, the `ErrorMessage` field contains a message that explains why.
         */
        public var status: aws.sdk.kotlin.services.kendra.model.IndexStatus? = null
        /**
         * The Unix when the index was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user context policy for the Amazon Kendra index.
         */
        public var userContextPolicy: aws.sdk.kotlin.services.kendra.model.UserContextPolicy? = null
        /**
         * Whether you have enabled the configuration for fetching access levels of groups and users from an IAM Identity Center (successor to Single Sign-On) identity source.
         */
        public var userGroupResolutionConfiguration: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration? = null
        /**
         * The user token configuration for the Amazon Kendra index.
         */
        public var userTokenConfigurations: List<UserTokenConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DescribeIndexResponse) : this() {
            this.capacityUnits = x.capacityUnits
            this.createdAt = x.createdAt
            this.description = x.description
            this.documentMetadataConfigurations = x.documentMetadataConfigurations
            this.edition = x.edition
            this.errorMessage = x.errorMessage
            this.id = x.id
            this.indexStatistics = x.indexStatistics
            this.name = x.name
            this.roleArn = x.roleArn
            this.serverSideEncryptionConfiguration = x.serverSideEncryptionConfiguration
            this.status = x.status
            this.updatedAt = x.updatedAt
            this.userContextPolicy = x.userContextPolicy
            this.userGroupResolutionConfiguration = x.userGroupResolutionConfiguration
            this.userTokenConfigurations = x.userTokenConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DescribeIndexResponse = DescribeIndexResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration] inside the given [block]
         */
        public fun capacityUnits(block: aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration.Builder.() -> kotlin.Unit) {
            this.capacityUnits = aws.sdk.kotlin.services.kendra.model.CapacityUnitsConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.IndexStatistics] inside the given [block]
         */
        public fun indexStatistics(block: aws.sdk.kotlin.services.kendra.model.IndexStatistics.Builder.() -> kotlin.Unit) {
            this.indexStatistics = aws.sdk.kotlin.services.kendra.model.IndexStatistics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration] inside the given [block]
         */
        public fun serverSideEncryptionConfiguration(block: aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.serverSideEncryptionConfiguration = aws.sdk.kotlin.services.kendra.model.ServerSideEncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration] inside the given [block]
         */
        public fun userGroupResolutionConfiguration(block: aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration.Builder.() -> kotlin.Unit) {
            this.userGroupResolutionConfiguration = aws.sdk.kotlin.services.kendra.model.UserGroupResolutionConfiguration.invoke(block)
        }
    }
}
