// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



public class DeletePrincipalMappingRequest private constructor(builder: Builder) {
    /**
     * The identifier of the data source you want to delete a group from.
     *
     * A group can be tied to multiple data sources. You can delete a group from accessing documents in a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. You want to delete "Research" and "Engineering" groups from Salesforce, so that these groups cannot access customer-related documents stored in Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data source.
     */
    public val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * The identifier of the group you want to delete.
     */
    public val groupId: kotlin.String? = builder.groupId
    /**
     * The identifier of the index you want to delete a group from.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * The timestamp identifier you specify to ensure Amazon Kendra does not override the latest `DELETE` action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.
     *
     * The ordering ID can be the Unix time of the last update you made to a group members list. You would then provide this list when calling `PutPrincipalMapping`. This ensures your `DELETE` action for that updated group with the latest members list doesn't get overwritten by earlier `DELETE` actions for the same group which are yet to be processed.
     *
     * The default ordering ID is the current Unix time in milliseconds that the action was received by Amazon Kendra.
     */
    public val orderingId: kotlin.Long? = builder.orderingId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.DeletePrincipalMappingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeletePrincipalMappingRequest(")
        append("dataSourceId=$dataSourceId,")
        append("groupId=$groupId,")
        append("indexId=$indexId,")
        append("orderingId=$orderingId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceId?.hashCode() ?: 0
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (orderingId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeletePrincipalMappingRequest

        if (dataSourceId != other.dataSourceId) return false
        if (groupId != other.groupId) return false
        if (indexId != other.indexId) return false
        if (orderingId != other.orderingId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.DeletePrincipalMappingRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the data source you want to delete a group from.
         *
         * A group can be tied to multiple data sources. You can delete a group from accessing documents in a certain data source. For example, the groups "Research", "Engineering", and "Sales and Marketing" are all tied to the company's documents stored in the data sources Confluence and Salesforce. You want to delete "Research" and "Engineering" groups from Salesforce, so that these groups cannot access customer-related documents stored in Salesforce. Only "Sales and Marketing" should access documents in the Salesforce data source.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * The identifier of the group you want to delete.
         */
        public var groupId: kotlin.String? = null
        /**
         * The identifier of the index you want to delete a group from.
         */
        public var indexId: kotlin.String? = null
        /**
         * The timestamp identifier you specify to ensure Amazon Kendra does not override the latest `DELETE` action with previous actions. The highest number ID, which is the ordering ID, is the latest action you want to process and apply on top of other actions with lower number IDs. This prevents previous actions with lower number IDs from possibly overriding the latest action.
         *
         * The ordering ID can be the Unix time of the last update you made to a group members list. You would then provide this list when calling `PutPrincipalMapping`. This ensures your `DELETE` action for that updated group with the latest members list doesn't get overwritten by earlier `DELETE` actions for the same group which are yet to be processed.
         *
         * The default ordering ID is the current Unix time in milliseconds that the action was received by Amazon Kendra.
         */
        public var orderingId: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.DeletePrincipalMappingRequest) : this() {
            this.dataSourceId = x.dataSourceId
            this.groupId = x.groupId
            this.indexId = x.indexId
            this.orderingId = x.orderingId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.DeletePrincipalMappingRequest = DeletePrincipalMappingRequest(this)
    }
}
