// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information for altering document metadata and content during the document ingestion process.
 *
 * For more information, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
 */
public class CustomDocumentEnrichmentConfiguration private constructor(builder: Builder) {
    /**
     * Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra.
     */
    public val inlineConfigurations: List<InlineCustomDocumentEnrichmentConfiguration>? = builder.inlineConfigurations
    /**
     * Configuration information for invoking a Lambda function in Lambda on the structured documents with their metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation).
     */
    public val postExtractionHookConfiguration: aws.sdk.kotlin.services.kendra.model.HookConfiguration? = builder.postExtractionHookConfiguration
    /**
     * Configuration information for invoking a Lambda function in Lambda on the original or raw documents before extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation).
     */
    public val preExtractionHookConfiguration: aws.sdk.kotlin.services.kendra.model.HookConfiguration? = builder.preExtractionHookConfiguration
    /**
     * The Amazon Resource Name (ARN) of a role with permission to run `PreExtractionHookConfiguration` and `PostExtractionHookConfiguration` for altering document metadata and content during the document ingestion process. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomDocumentEnrichmentConfiguration(")
        append("inlineConfigurations=$inlineConfigurations,")
        append("postExtractionHookConfiguration=$postExtractionHookConfiguration,")
        append("preExtractionHookConfiguration=$preExtractionHookConfiguration,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inlineConfigurations?.hashCode() ?: 0
        result = 31 * result + (postExtractionHookConfiguration?.hashCode() ?: 0)
        result = 31 * result + (preExtractionHookConfiguration?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomDocumentEnrichmentConfiguration

        if (inlineConfigurations != other.inlineConfigurations) return false
        if (postExtractionHookConfiguration != other.postExtractionHookConfiguration) return false
        if (preExtractionHookConfiguration != other.preExtractionHookConfiguration) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configuration information to alter document attributes or metadata fields and content when ingesting documents into Amazon Kendra.
         */
        public var inlineConfigurations: List<InlineCustomDocumentEnrichmentConfiguration>? = null
        /**
         * Configuration information for invoking a Lambda function in Lambda on the structured documents with their metadata and text extracted. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation).
         */
        public var postExtractionHookConfiguration: aws.sdk.kotlin.services.kendra.model.HookConfiguration? = null
        /**
         * Configuration information for invoking a Lambda function in Lambda on the original or raw documents before extracting their metadata and text. You can use a Lambda function to apply advanced logic for creating, modifying, or deleting document metadata and content. For more information, see [Advanced data manipulation](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation).
         */
        public var preExtractionHookConfiguration: aws.sdk.kotlin.services.kendra.model.HookConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of a role with permission to run `PreExtractionHookConfiguration` and `PostExtractionHookConfiguration` for altering document metadata and content during the document ingestion process. For more information, see [IAM roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration) : this() {
            this.inlineConfigurations = x.inlineConfigurations
            this.postExtractionHookConfiguration = x.postExtractionHookConfiguration
            this.preExtractionHookConfiguration = x.preExtractionHookConfiguration
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration = CustomDocumentEnrichmentConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.HookConfiguration] inside the given [block]
         */
        public fun postExtractionHookConfiguration(block: aws.sdk.kotlin.services.kendra.model.HookConfiguration.Builder.() -> kotlin.Unit) {
            this.postExtractionHookConfiguration = aws.sdk.kotlin.services.kendra.model.HookConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.HookConfiguration] inside the given [block]
         */
        public fun preExtractionHookConfiguration(block: aws.sdk.kotlin.services.kendra.model.HookConfiguration.Builder.() -> kotlin.Unit) {
            this.preExtractionHookConfiguration = aws.sdk.kotlin.services.kendra.model.HookConfiguration.invoke(block)
        }
    }
}
