// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



public class CreateExperienceRequest private constructor(builder: Builder) {
    /**
     * A token that you provide to identify the request to create your Amazon Kendra experience. Multiple calls to the `CreateExperience` API with the same client token creates only one Amazon Kendra experience.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Configuration information for your Amazon Kendra experience. This includes `ContentSourceConfiguration`, which specifies the data source IDs and/or FAQ IDs, and `UserIdentityConfiguration`, which specifies the user or group information to grant access to your Amazon Kendra experience.
     */
    public val configuration: aws.sdk.kotlin.services.kendra.model.ExperienceConfiguration? = builder.configuration
    /**
     * A description for your Amazon Kendra experience.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the index for your Amazon Kendra experience.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * A name for your Amazon Kendra experience.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of an IAM role with permission to access `Query` API, `GetQuerySuggestions` API, and other required APIs. The role also must include permission to access IAM Identity Center (successor to Single Sign-On) that stores your user and group information. For more information, see [IAM access roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CreateExperienceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateExperienceRequest(")
        append("clientToken=$clientToken,")
        append("configuration=$configuration,")
        append("description=$description,")
        append("indexId=$indexId,")
        append("name=$name,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateExperienceRequest

        if (clientToken != other.clientToken) return false
        if (configuration != other.configuration) return false
        if (description != other.description) return false
        if (indexId != other.indexId) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CreateExperienceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A token that you provide to identify the request to create your Amazon Kendra experience. Multiple calls to the `CreateExperience` API with the same client token creates only one Amazon Kendra experience.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Configuration information for your Amazon Kendra experience. This includes `ContentSourceConfiguration`, which specifies the data source IDs and/or FAQ IDs, and `UserIdentityConfiguration`, which specifies the user or group information to grant access to your Amazon Kendra experience.
         */
        public var configuration: aws.sdk.kotlin.services.kendra.model.ExperienceConfiguration? = null
        /**
         * A description for your Amazon Kendra experience.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the index for your Amazon Kendra experience.
         */
        public var indexId: kotlin.String? = null
        /**
         * A name for your Amazon Kendra experience.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role with permission to access `Query` API, `GetQuerySuggestions` API, and other required APIs. The role also must include permission to access IAM Identity Center (successor to Single Sign-On) that stores your user and group information. For more information, see [IAM access roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CreateExperienceRequest) : this() {
            this.clientToken = x.clientToken
            this.configuration = x.configuration
            this.description = x.description
            this.indexId = x.indexId
            this.name = x.name
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CreateExperienceRequest = CreateExperienceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.ExperienceConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.kendra.model.ExperienceConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.kendra.model.ExperienceConfiguration.invoke(block)
        }
    }
}
