// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



public class CreateDataSourceRequest private constructor(builder: Builder) {
    /**
     * A token that you provide to identify the request to create a data source connector. Multiple calls to the `CreateDataSource` API with the same client token will create only one data source connector.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Configuration information to connect to your data source repository.
     *
     * You can't specify the `Configuration` parameter when the `Type` parameter is set to `CUSTOM`. If you do, you receive a `ValidationException` exception.
     *
     * The `Configuration` parameter is required for all other data sources.
     */
    public val configuration: aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration? = builder.configuration
    /**
     * Configuration information for altering document metadata and content during the document ingestion process.
     *
     * For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
     */
    public val customDocumentEnrichmentConfiguration: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration? = builder.customDocumentEnrichmentConfiguration
    /**
     * A description for the data source connector.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the index you want to use with the data source connector.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * The code for a language. This allows you to support a language for all documents when creating the data source connector. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
     */
    public val languageCode: kotlin.String? = builder.languageCode
    /**
     * A name for the data source connector.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources. For more information, see [IAM access roles for Amazon Kendra.](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     *
     * You can't specify the `RoleArn` parameter when the `Type` parameter is set to `CUSTOM`. If you do, you receive a `ValidationException` exception.
     *
     * The `RoleArn` parameter is required for all other data sources.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Sets the frequency for Amazon Kendra to check the documents in your data source repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the `StartDataSourceSyncJob` API to update the index.
     *
     * Specify a `cron-` format schedule string or an empty string to indicate that the index is updated on demand.
     *
     * You can't specify the `Schedule` parameter when the `Type` parameter is set to `CUSTOM`. If you do, you receive a `ValidationException` exception.
     */
    public val schedule: kotlin.String? = builder.schedule
    /**
     * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The type of data source repository. For example, `SHAREPOINT`.
     */
    public val type: aws.sdk.kotlin.services.kendra.model.DataSourceType? = builder.type
    /**
     * Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CreateDataSourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataSourceRequest(")
        append("clientToken=$clientToken,")
        append("configuration=$configuration,")
        append("customDocumentEnrichmentConfiguration=$customDocumentEnrichmentConfiguration,")
        append("description=$description,")
        append("indexId=$indexId,")
        append("languageCode=$languageCode,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("schedule=$schedule,")
        append("tags=$tags,")
        append("type=$type,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (customDocumentEnrichmentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (schedule?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataSourceRequest

        if (clientToken != other.clientToken) return false
        if (configuration != other.configuration) return false
        if (customDocumentEnrichmentConfiguration != other.customDocumentEnrichmentConfiguration) return false
        if (description != other.description) return false
        if (indexId != other.indexId) return false
        if (languageCode != other.languageCode) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (schedule != other.schedule) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CreateDataSourceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A token that you provide to identify the request to create a data source connector. Multiple calls to the `CreateDataSource` API with the same client token will create only one data source connector.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Configuration information to connect to your data source repository.
         *
         * You can't specify the `Configuration` parameter when the `Type` parameter is set to `CUSTOM`. If you do, you receive a `ValidationException` exception.
         *
         * The `Configuration` parameter is required for all other data sources.
         */
        public var configuration: aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration? = null
        /**
         * Configuration information for altering document metadata and content during the document ingestion process.
         *
         * For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
         */
        public var customDocumentEnrichmentConfiguration: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration? = null
        /**
         * A description for the data source connector.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the index you want to use with the data source connector.
         */
        public var indexId: kotlin.String? = null
        /**
         * The code for a language. This allows you to support a language for all documents when creating the data source connector. English is supported by default. For more information on supported languages, including their codes, see [Adding documents in languages other than English](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
         */
        public var languageCode: kotlin.String? = null
        /**
         * A name for the data source connector.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role with permission to access the data source and required resources. For more information, see [IAM access roles for Amazon Kendra.](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
         *
         * You can't specify the `RoleArn` parameter when the `Type` parameter is set to `CUSTOM`. If you do, you receive a `ValidationException` exception.
         *
         * The `RoleArn` parameter is required for all other data sources.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Sets the frequency for Amazon Kendra to check the documents in your data source repository and update the index. If you don't set a schedule Amazon Kendra will not periodically update the index. You can call the `StartDataSourceSyncJob` API to update the index.
         *
         * Specify a `cron-` format schedule string or an empty string to indicate that the index is updated on demand.
         *
         * You can't specify the `Schedule` parameter when the `Type` parameter is set to `CUSTOM`. If you do, you receive a `ValidationException` exception.
         */
        public var schedule: kotlin.String? = null
        /**
         * A list of key-value pairs that identify or categorize the data source connector. You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + - @.
         */
        public var tags: List<Tag>? = null
        /**
         * The type of data source repository. For example, `SHAREPOINT`.
         */
        public var type: aws.sdk.kotlin.services.kendra.model.DataSourceType? = null
        /**
         * Configuration information for an Amazon Virtual Private Cloud to connect to your data source. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CreateDataSourceRequest) : this() {
            this.clientToken = x.clientToken
            this.configuration = x.configuration
            this.customDocumentEnrichmentConfiguration = x.customDocumentEnrichmentConfiguration
            this.description = x.description
            this.indexId = x.indexId
            this.languageCode = x.languageCode
            this.name = x.name
            this.roleArn = x.roleArn
            this.schedule = x.schedule
            this.tags = x.tags
            this.type = x.type
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CreateDataSourceRequest = CreateDataSourceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.kendra.model.DataSourceConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration] inside the given [block]
         */
        public fun customDocumentEnrichmentConfiguration(block: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration.Builder.() -> kotlin.Unit) {
            this.customDocumentEnrichmentConfiguration = aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.invoke(block)
        }
    }
}
