// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



public class CreateAccessControlConfigurationRequest private constructor(builder: Builder) {
    /**
     * Information on principals (users and/or groups) and which documents they should have access to. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
     */
    public val accessControlList: List<Principal>? = builder.accessControlList
    /**
     * A token that you provide to identify the request to create an access control configuration. Multiple calls to the `CreateAccessControlConfiguration` API with the same client token will create only one access control configuration.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description for the access control configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The list of [principal](https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html) lists that define the hierarchy for which documents users should have access to.
     */
    public val hierarchicalAccessControlList: List<HierarchicalPrincipal>? = builder.hierarchicalAccessControlList
    /**
     * The identifier of the index to create an access control configuration for your documents.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * A name for the access control configuration.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.CreateAccessControlConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccessControlConfigurationRequest(")
        append("accessControlList=$accessControlList,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("hierarchicalAccessControlList=$hierarchicalAccessControlList,")
        append("indexId=$indexId,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessControlList?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (hierarchicalAccessControlList?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccessControlConfigurationRequest

        if (accessControlList != other.accessControlList) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (hierarchicalAccessControlList != other.hierarchicalAccessControlList) return false
        if (indexId != other.indexId) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.CreateAccessControlConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information on principals (users and/or groups) and which documents they should have access to. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
         */
        public var accessControlList: List<Principal>? = null
        /**
         * A token that you provide to identify the request to create an access control configuration. Multiple calls to the `CreateAccessControlConfiguration` API with the same client token will create only one access control configuration.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A description for the access control configuration.
         */
        public var description: kotlin.String? = null
        /**
         * The list of [principal](https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html) lists that define the hierarchy for which documents users should have access to.
         */
        public var hierarchicalAccessControlList: List<HierarchicalPrincipal>? = null
        /**
         * The identifier of the index to create an access control configuration for your documents.
         */
        public var indexId: kotlin.String? = null
        /**
         * A name for the access control configuration.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.CreateAccessControlConfigurationRequest) : this() {
            this.accessControlList = x.accessControlList
            this.clientToken = x.clientToken
            this.description = x.description
            this.hierarchicalAccessControlList = x.hierarchicalAccessControlList
            this.indexId = x.indexId
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.CreateAccessControlConfigurationRequest = CreateAccessControlConfigurationRequest(this)
    }
}
