// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information that's required to connect to a database.
 */
public class ConnectionConfiguration private constructor(builder: Builder) {
    /**
     * The name of the host for the database. Can be either a string (host.subdomain.domain.tld) or an IPv4 or IPv6 address.
     */
    public val databaseHost: kotlin.String? = builder.databaseHost
    /**
     * The name of the database containing the document data.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The port that the database uses for connections.
     */
    public val databasePort: kotlin.Int? = builder.databasePort
    /**
     * The Amazon Resource Name (ARN) of credentials stored in Secrets Manager. The credentials should be a user/password pair. For more information, see [Using a Database Data Source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html). For more information about Secrets Manager, see [ What Is Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) in the * Secrets Manager * user guide.
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * The name of the table that contains the document data.
     */
    public val tableName: kotlin.String? = builder.tableName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.ConnectionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectionConfiguration(")
        append("databaseHost=$databaseHost,")
        append("databaseName=$databaseName,")
        append("databasePort=$databasePort,")
        append("secretArn=$secretArn,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseHost?.hashCode() ?: 0
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (databasePort ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectionConfiguration

        if (databaseHost != other.databaseHost) return false
        if (databaseName != other.databaseName) return false
        if (databasePort != other.databasePort) return false
        if (secretArn != other.secretArn) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.ConnectionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the host for the database. Can be either a string (host.subdomain.domain.tld) or an IPv4 or IPv6 address.
         */
        public var databaseHost: kotlin.String? = null
        /**
         * The name of the database containing the document data.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The port that the database uses for connections.
         */
        public var databasePort: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of credentials stored in Secrets Manager. The credentials should be a user/password pair. For more information, see [Using a Database Data Source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html). For more information about Secrets Manager, see [ What Is Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) in the * Secrets Manager * user guide.
         */
        public var secretArn: kotlin.String? = null
        /**
         * The name of the table that contains the document data.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.ConnectionConfiguration) : this() {
            this.databaseHost = x.databaseHost
            this.databaseName = x.databaseName
            this.databasePort = x.databasePort
            this.secretArn = x.secretArn
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.ConnectionConfiguration = ConnectionConfiguration(this)
    }
}
