// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to connect to Box as your data source.
 */
public class BoxConfiguration private constructor(builder: Builder) {
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Box comments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Box fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Box field names must exist in your Box custom metadata.
     */
    public val commentFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.commentFieldMappings
    /**
     * `TRUE` to index comments.
     */
    public val crawlComments: kotlin.Boolean = builder.crawlComments
    /**
     * `TRUE` to index the contents of tasks.
     */
    public val crawlTasks: kotlin.Boolean = builder.crawlTasks
    /**
     * `TRUE` to index web links.
     */
    public val crawlWebLinks: kotlin.Boolean = builder.crawlWebLinks
    /**
     * The identifier of the Box Enterprise platform. You can find the enterprise ID in the Box Developer Console settings or when you create an app in Box and download your authentication credentials. For example, *801234567*.
     */
    public val enterpriseId: kotlin.String? = builder.enterpriseId
    /**
     * A list of regular expression patterns to exclude certain files and folders from your Box platform. Files and folders that match the patterns are excluded from the index.Files and folders that don't match the patterns are included in the index. If a file or folder matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file or folder isn't included in the index.
     */
    public val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Box files to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Box fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Box field names must exist in your Box custom metadata.
     */
    public val fileFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fileFieldMappings
    /**
     * A list of regular expression patterns to include certain files and folders in your Box platform. Files and folders that match the patterns are included in the index. Files and folders that don't match the patterns are excluded from the index. If a file or folder matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file or folder isn't included in the index.
     */
    public val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your Box platform. The secret must contain a JSON structure with the following keys:
     * + clientID—The identifier of the client OAuth 2.0 authentication application created in Box.
     * + clientSecret—A set of characters known only to the OAuth 2.0 authentication application created in Box.
     * + publicKeyId—The identifier of the public key contained within an identity certificate.
     * + privateKey—A set of characters that make up an encryption key.
     * + passphrase—A set of characters that act like a password.
     *
     * You create an application in Box to generate the keys or credentials required for the secret. For more information, see [Using a Box data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-box.html).
     */
    public val secretArn: kotlin.String? = builder.secretArn
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Box tasks to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Box fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Box field names must exist in your Box custom metadata.
     */
    public val taskFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.taskFieldMappings
    /**
     * `TRUE` to use the Slack change log to determine which documents require updating in the index. Depending on the data source change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents.
     */
    public val useChangeLog: kotlin.Boolean = builder.useChangeLog
    /**
     * Configuration information for an Amazon VPC to connect to your Box. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = builder.vpcConfiguration
    /**
     * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Box web links to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Box fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Box field names must exist in your Box custom metadata.
     */
    public val webLinkFieldMappings: List<DataSourceToIndexFieldMapping>? = builder.webLinkFieldMappings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.BoxConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BoxConfiguration(")
        append("commentFieldMappings=$commentFieldMappings,")
        append("crawlComments=$crawlComments,")
        append("crawlTasks=$crawlTasks,")
        append("crawlWebLinks=$crawlWebLinks,")
        append("enterpriseId=$enterpriseId,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("fileFieldMappings=$fileFieldMappings,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("secretArn=$secretArn,")
        append("taskFieldMappings=$taskFieldMappings,")
        append("useChangeLog=$useChangeLog,")
        append("vpcConfiguration=$vpcConfiguration,")
        append("webLinkFieldMappings=$webLinkFieldMappings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = commentFieldMappings?.hashCode() ?: 0
        result = 31 * result + (crawlComments.hashCode())
        result = 31 * result + (crawlTasks.hashCode())
        result = 31 * result + (crawlWebLinks.hashCode())
        result = 31 * result + (enterpriseId?.hashCode() ?: 0)
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (fileFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (secretArn?.hashCode() ?: 0)
        result = 31 * result + (taskFieldMappings?.hashCode() ?: 0)
        result = 31 * result + (useChangeLog.hashCode())
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        result = 31 * result + (webLinkFieldMappings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BoxConfiguration

        if (commentFieldMappings != other.commentFieldMappings) return false
        if (crawlComments != other.crawlComments) return false
        if (crawlTasks != other.crawlTasks) return false
        if (crawlWebLinks != other.crawlWebLinks) return false
        if (enterpriseId != other.enterpriseId) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (fileFieldMappings != other.fileFieldMappings) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (secretArn != other.secretArn) return false
        if (taskFieldMappings != other.taskFieldMappings) return false
        if (useChangeLog != other.useChangeLog) return false
        if (vpcConfiguration != other.vpcConfiguration) return false
        if (webLinkFieldMappings != other.webLinkFieldMappings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.BoxConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Box comments to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Box fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Box field names must exist in your Box custom metadata.
         */
        public var commentFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * `TRUE` to index comments.
         */
        public var crawlComments: kotlin.Boolean = false
        /**
         * `TRUE` to index the contents of tasks.
         */
        public var crawlTasks: kotlin.Boolean = false
        /**
         * `TRUE` to index web links.
         */
        public var crawlWebLinks: kotlin.Boolean = false
        /**
         * The identifier of the Box Enterprise platform. You can find the enterprise ID in the Box Developer Console settings or when you create an app in Box and download your authentication credentials. For example, *801234567*.
         */
        public var enterpriseId: kotlin.String? = null
        /**
         * A list of regular expression patterns to exclude certain files and folders from your Box platform. Files and folders that match the patterns are excluded from the index.Files and folders that don't match the patterns are included in the index. If a file or folder matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file or folder isn't included in the index.
         */
        public var exclusionPatterns: List<String>? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Box files to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Box fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Box field names must exist in your Box custom metadata.
         */
        public var fileFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of regular expression patterns to include certain files and folders in your Box platform. Files and folders that match the patterns are included in the index. Files and folders that don't match the patterns are excluded from the index. If a file or folder matches both an inclusion and exclusion pattern, the exclusion pattern takes precedence and the file or folder isn't included in the index.
         */
        public var inclusionPatterns: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the key-value pairs required to connect to your Box platform. The secret must contain a JSON structure with the following keys:
         * + clientID—The identifier of the client OAuth 2.0 authentication application created in Box.
         * + clientSecret—A set of characters known only to the OAuth 2.0 authentication application created in Box.
         * + publicKeyId—The identifier of the public key contained within an identity certificate.
         * + privateKey—A set of characters that make up an encryption key.
         * + passphrase—A set of characters that act like a password.
         *
         * You create an application in Box to generate the keys or credentials required for the secret. For more information, see [Using a Box data source](https://docs.aws.amazon.com/kendra/latest/dg/data-source-box.html).
         */
        public var secretArn: kotlin.String? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Box tasks to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Box fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Box field names must exist in your Box custom metadata.
         */
        public var taskFieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * `TRUE` to use the Slack change log to determine which documents require updating in the index. Depending on the data source change log's size, it may take longer for Amazon Kendra to use the change log than to scan all of your documents.
         */
        public var useChangeLog: kotlin.Boolean = false
        /**
         * Configuration information for an Amazon VPC to connect to your Box. For more information, see [Configuring a VPC](https://docs.aws.amazon.com/kendra/latest/dg/vpc-configuration.html).
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration? = null
        /**
         * A list of `DataSourceToIndexFieldMapping` objects that map attributes or field names of Box web links to Amazon Kendra index field names. To create custom fields, use the `UpdateIndex` API before you map to Box fields. For more information, see [Mapping data source fields](https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Box field names must exist in your Box custom metadata.
         */
        public var webLinkFieldMappings: List<DataSourceToIndexFieldMapping>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.BoxConfiguration) : this() {
            this.commentFieldMappings = x.commentFieldMappings
            this.crawlComments = x.crawlComments
            this.crawlTasks = x.crawlTasks
            this.crawlWebLinks = x.crawlWebLinks
            this.enterpriseId = x.enterpriseId
            this.exclusionPatterns = x.exclusionPatterns
            this.fileFieldMappings = x.fileFieldMappings
            this.inclusionPatterns = x.inclusionPatterns
            this.secretArn = x.secretArn
            this.taskFieldMappings = x.taskFieldMappings
            this.useChangeLog = x.useChangeLog
            this.vpcConfiguration = x.vpcConfiguration
            this.webLinkFieldMappings = x.webLinkFieldMappings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.BoxConfiguration = BoxConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.kendra.model.DataSourceVpcConfiguration.invoke(block)
        }
    }
}
