// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



public class BatchPutDocumentRequest private constructor(builder: Builder) {
    /**
     * Configuration information for altering your document metadata and content during the document ingestion process when you use the `BatchPutDocument` API.
     *
     * For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
     */
    public val customDocumentEnrichmentConfiguration: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration? = builder.customDocumentEnrichmentConfiguration
    /**
     * One or more documents to add to the index.
     *
     * Documents have the following file size limits.
     * + 50 MB total size for any file
     * + 5 MB extracted text for any file
     *
     * For more information, see [Quotas](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
     */
    public val documents: List<Document>? = builder.documents
    /**
     * The identifier of the index to add the documents to. You need to create the index first using the `CreateIndex` API.
     */
    public val indexId: kotlin.String? = builder.indexId
    /**
     * The Amazon Resource Name (ARN) of an IAM role with permission to access your S3 bucket. For more information, see [IAM access roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.BatchPutDocumentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchPutDocumentRequest(")
        append("customDocumentEnrichmentConfiguration=$customDocumentEnrichmentConfiguration,")
        append("documents=$documents,")
        append("indexId=$indexId,")
        append("roleArn=$roleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customDocumentEnrichmentConfiguration?.hashCode() ?: 0
        result = 31 * result + (documents?.hashCode() ?: 0)
        result = 31 * result + (indexId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchPutDocumentRequest

        if (customDocumentEnrichmentConfiguration != other.customDocumentEnrichmentConfiguration) return false
        if (documents != other.documents) return false
        if (indexId != other.indexId) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.BatchPutDocumentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configuration information for altering your document metadata and content during the document ingestion process when you use the `BatchPutDocument` API.
         *
         * For more information on how to create, modify and delete document metadata, or make other content alterations when you ingest documents into Amazon Kendra, see [Customizing document metadata during the ingestion process](https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
         */
        public var customDocumentEnrichmentConfiguration: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration? = null
        /**
         * One or more documents to add to the index.
         *
         * Documents have the following file size limits.
         * + 50 MB total size for any file
         * + 5 MB extracted text for any file
         *
         * For more information, see [Quotas](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
         */
        public var documents: List<Document>? = null
        /**
         * The identifier of the index to add the documents to. You need to create the index first using the `CreateIndex` API.
         */
        public var indexId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role with permission to access your S3 bucket. For more information, see [IAM access roles for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.BatchPutDocumentRequest) : this() {
            this.customDocumentEnrichmentConfiguration = x.customDocumentEnrichmentConfiguration
            this.documents = x.documents
            this.indexId = x.indexId
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.BatchPutDocumentRequest = BatchPutDocumentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration] inside the given [block]
         */
        public fun customDocumentEnrichmentConfiguration(block: aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration.Builder.() -> kotlin.Unit) {
            this.customDocumentEnrichmentConfiguration = aws.sdk.kotlin.services.kendra.model.CustomDocumentEnrichmentConfiguration.invoke(block)
        }
    }
}
