// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information for the document fields/attributes that you want to base query suggestions on.
 */
public class AttributeSuggestionsGetConfig private constructor(builder: Builder) {
    /**
     * The list of additional document field/attribute keys or field names to include in the response. You can use additional fields to provide extra information in the response. Additional fields are not used to based suggestions on.
     */
    public val additionalResponseAttributes: List<String>? = builder.additionalResponseAttributes
    /**
     * Filters the search results based on document fields/attributes.
     */
    public val attributeFilter: aws.sdk.kotlin.services.kendra.model.AttributeFilter? = builder.attributeFilter
    /**
     * The list of document field/attribute keys or field names to use for query suggestions. If the content within any of the fields match what your user starts typing as their query, then the field content is returned as a query suggestion.
     */
    public val suggestionAttributes: List<String>? = builder.suggestionAttributes
    /**
     * Applies user context filtering so that only users who are given access to certain documents see these document in their search results.
     */
    public val userContext: aws.sdk.kotlin.services.kendra.model.UserContext? = builder.userContext

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsGetConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AttributeSuggestionsGetConfig(")
        append("additionalResponseAttributes=$additionalResponseAttributes,")
        append("attributeFilter=$attributeFilter,")
        append("suggestionAttributes=$suggestionAttributes,")
        append("userContext=$userContext")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalResponseAttributes?.hashCode() ?: 0
        result = 31 * result + (attributeFilter?.hashCode() ?: 0)
        result = 31 * result + (suggestionAttributes?.hashCode() ?: 0)
        result = 31 * result + (userContext?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AttributeSuggestionsGetConfig

        if (additionalResponseAttributes != other.additionalResponseAttributes) return false
        if (attributeFilter != other.attributeFilter) return false
        if (suggestionAttributes != other.suggestionAttributes) return false
        if (userContext != other.userContext) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsGetConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of additional document field/attribute keys or field names to include in the response. You can use additional fields to provide extra information in the response. Additional fields are not used to based suggestions on.
         */
        public var additionalResponseAttributes: List<String>? = null
        /**
         * Filters the search results based on document fields/attributes.
         */
        public var attributeFilter: aws.sdk.kotlin.services.kendra.model.AttributeFilter? = null
        /**
         * The list of document field/attribute keys or field names to use for query suggestions. If the content within any of the fields match what your user starts typing as their query, then the field content is returned as a query suggestion.
         */
        public var suggestionAttributes: List<String>? = null
        /**
         * Applies user context filtering so that only users who are given access to certain documents see these document in their search results.
         */
        public var userContext: aws.sdk.kotlin.services.kendra.model.UserContext? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsGetConfig) : this() {
            this.additionalResponseAttributes = x.additionalResponseAttributes
            this.attributeFilter = x.attributeFilter
            this.suggestionAttributes = x.suggestionAttributes
            this.userContext = x.userContext
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.AttributeSuggestionsGetConfig = AttributeSuggestionsGetConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.AttributeFilter] inside the given [block]
         */
        public fun attributeFilter(block: aws.sdk.kotlin.services.kendra.model.AttributeFilter.Builder.() -> kotlin.Unit) {
            this.attributeFilter = aws.sdk.kotlin.services.kendra.model.AttributeFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kendra.model.UserContext] inside the given [block]
         */
        public fun userContext(block: aws.sdk.kotlin.services.kendra.model.UserContext.Builder.() -> kotlin.Unit) {
            this.userContext = aws.sdk.kotlin.services.kendra.model.UserContext.invoke(block)
        }
    }
}
