// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.kendra.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.kendra.endpoints.EndpointParameters
import aws.sdk.kotlin.services.kendra.endpoints.EndpointProvider
import aws.sdk.kotlin.services.kendra.model.AssociateEntitiesToExperienceRequest
import aws.sdk.kotlin.services.kendra.model.AssociateEntitiesToExperienceResponse
import aws.sdk.kotlin.services.kendra.model.AssociatePersonasToEntitiesRequest
import aws.sdk.kotlin.services.kendra.model.AssociatePersonasToEntitiesResponse
import aws.sdk.kotlin.services.kendra.model.BatchDeleteDocumentRequest
import aws.sdk.kotlin.services.kendra.model.BatchDeleteDocumentResponse
import aws.sdk.kotlin.services.kendra.model.BatchDeleteFeaturedResultsSetRequest
import aws.sdk.kotlin.services.kendra.model.BatchDeleteFeaturedResultsSetResponse
import aws.sdk.kotlin.services.kendra.model.BatchGetDocumentStatusRequest
import aws.sdk.kotlin.services.kendra.model.BatchGetDocumentStatusResponse
import aws.sdk.kotlin.services.kendra.model.BatchPutDocumentRequest
import aws.sdk.kotlin.services.kendra.model.BatchPutDocumentResponse
import aws.sdk.kotlin.services.kendra.model.ClearQuerySuggestionsRequest
import aws.sdk.kotlin.services.kendra.model.ClearQuerySuggestionsResponse
import aws.sdk.kotlin.services.kendra.model.CreateAccessControlConfigurationRequest
import aws.sdk.kotlin.services.kendra.model.CreateAccessControlConfigurationResponse
import aws.sdk.kotlin.services.kendra.model.CreateDataSourceRequest
import aws.sdk.kotlin.services.kendra.model.CreateDataSourceResponse
import aws.sdk.kotlin.services.kendra.model.CreateExperienceRequest
import aws.sdk.kotlin.services.kendra.model.CreateExperienceResponse
import aws.sdk.kotlin.services.kendra.model.CreateFaqRequest
import aws.sdk.kotlin.services.kendra.model.CreateFaqResponse
import aws.sdk.kotlin.services.kendra.model.CreateFeaturedResultsSetRequest
import aws.sdk.kotlin.services.kendra.model.CreateFeaturedResultsSetResponse
import aws.sdk.kotlin.services.kendra.model.CreateIndexRequest
import aws.sdk.kotlin.services.kendra.model.CreateIndexResponse
import aws.sdk.kotlin.services.kendra.model.CreateQuerySuggestionsBlockListRequest
import aws.sdk.kotlin.services.kendra.model.CreateQuerySuggestionsBlockListResponse
import aws.sdk.kotlin.services.kendra.model.CreateThesaurusRequest
import aws.sdk.kotlin.services.kendra.model.CreateThesaurusResponse
import aws.sdk.kotlin.services.kendra.model.DeleteAccessControlConfigurationRequest
import aws.sdk.kotlin.services.kendra.model.DeleteAccessControlConfigurationResponse
import aws.sdk.kotlin.services.kendra.model.DeleteDataSourceRequest
import aws.sdk.kotlin.services.kendra.model.DeleteDataSourceResponse
import aws.sdk.kotlin.services.kendra.model.DeleteExperienceRequest
import aws.sdk.kotlin.services.kendra.model.DeleteExperienceResponse
import aws.sdk.kotlin.services.kendra.model.DeleteFaqRequest
import aws.sdk.kotlin.services.kendra.model.DeleteFaqResponse
import aws.sdk.kotlin.services.kendra.model.DeleteIndexRequest
import aws.sdk.kotlin.services.kendra.model.DeleteIndexResponse
import aws.sdk.kotlin.services.kendra.model.DeletePrincipalMappingRequest
import aws.sdk.kotlin.services.kendra.model.DeletePrincipalMappingResponse
import aws.sdk.kotlin.services.kendra.model.DeleteQuerySuggestionsBlockListRequest
import aws.sdk.kotlin.services.kendra.model.DeleteQuerySuggestionsBlockListResponse
import aws.sdk.kotlin.services.kendra.model.DeleteThesaurusRequest
import aws.sdk.kotlin.services.kendra.model.DeleteThesaurusResponse
import aws.sdk.kotlin.services.kendra.model.DescribeAccessControlConfigurationRequest
import aws.sdk.kotlin.services.kendra.model.DescribeAccessControlConfigurationResponse
import aws.sdk.kotlin.services.kendra.model.DescribeDataSourceRequest
import aws.sdk.kotlin.services.kendra.model.DescribeDataSourceResponse
import aws.sdk.kotlin.services.kendra.model.DescribeExperienceRequest
import aws.sdk.kotlin.services.kendra.model.DescribeExperienceResponse
import aws.sdk.kotlin.services.kendra.model.DescribeFaqRequest
import aws.sdk.kotlin.services.kendra.model.DescribeFaqResponse
import aws.sdk.kotlin.services.kendra.model.DescribeFeaturedResultsSetRequest
import aws.sdk.kotlin.services.kendra.model.DescribeFeaturedResultsSetResponse
import aws.sdk.kotlin.services.kendra.model.DescribeIndexRequest
import aws.sdk.kotlin.services.kendra.model.DescribeIndexResponse
import aws.sdk.kotlin.services.kendra.model.DescribePrincipalMappingRequest
import aws.sdk.kotlin.services.kendra.model.DescribePrincipalMappingResponse
import aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsBlockListRequest
import aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsBlockListResponse
import aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsConfigRequest
import aws.sdk.kotlin.services.kendra.model.DescribeQuerySuggestionsConfigResponse
import aws.sdk.kotlin.services.kendra.model.DescribeThesaurusRequest
import aws.sdk.kotlin.services.kendra.model.DescribeThesaurusResponse
import aws.sdk.kotlin.services.kendra.model.DisassociateEntitiesFromExperienceRequest
import aws.sdk.kotlin.services.kendra.model.DisassociateEntitiesFromExperienceResponse
import aws.sdk.kotlin.services.kendra.model.DisassociatePersonasFromEntitiesRequest
import aws.sdk.kotlin.services.kendra.model.DisassociatePersonasFromEntitiesResponse
import aws.sdk.kotlin.services.kendra.model.GetQuerySuggestionsRequest
import aws.sdk.kotlin.services.kendra.model.GetQuerySuggestionsResponse
import aws.sdk.kotlin.services.kendra.model.GetSnapshotsRequest
import aws.sdk.kotlin.services.kendra.model.GetSnapshotsResponse
import aws.sdk.kotlin.services.kendra.model.ListAccessControlConfigurationsRequest
import aws.sdk.kotlin.services.kendra.model.ListAccessControlConfigurationsResponse
import aws.sdk.kotlin.services.kendra.model.ListDataSourceSyncJobsRequest
import aws.sdk.kotlin.services.kendra.model.ListDataSourceSyncJobsResponse
import aws.sdk.kotlin.services.kendra.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.kendra.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.kendra.model.ListEntityPersonasRequest
import aws.sdk.kotlin.services.kendra.model.ListEntityPersonasResponse
import aws.sdk.kotlin.services.kendra.model.ListExperienceEntitiesRequest
import aws.sdk.kotlin.services.kendra.model.ListExperienceEntitiesResponse
import aws.sdk.kotlin.services.kendra.model.ListExperiencesRequest
import aws.sdk.kotlin.services.kendra.model.ListExperiencesResponse
import aws.sdk.kotlin.services.kendra.model.ListFaqsRequest
import aws.sdk.kotlin.services.kendra.model.ListFaqsResponse
import aws.sdk.kotlin.services.kendra.model.ListFeaturedResultsSetsRequest
import aws.sdk.kotlin.services.kendra.model.ListFeaturedResultsSetsResponse
import aws.sdk.kotlin.services.kendra.model.ListGroupsOlderThanOrderingIdRequest
import aws.sdk.kotlin.services.kendra.model.ListGroupsOlderThanOrderingIdResponse
import aws.sdk.kotlin.services.kendra.model.ListIndicesRequest
import aws.sdk.kotlin.services.kendra.model.ListIndicesResponse
import aws.sdk.kotlin.services.kendra.model.ListQuerySuggestionsBlockListsRequest
import aws.sdk.kotlin.services.kendra.model.ListQuerySuggestionsBlockListsResponse
import aws.sdk.kotlin.services.kendra.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.kendra.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.kendra.model.ListThesauriRequest
import aws.sdk.kotlin.services.kendra.model.ListThesauriResponse
import aws.sdk.kotlin.services.kendra.model.PutPrincipalMappingRequest
import aws.sdk.kotlin.services.kendra.model.PutPrincipalMappingResponse
import aws.sdk.kotlin.services.kendra.model.QueryRequest
import aws.sdk.kotlin.services.kendra.model.QueryResponse
import aws.sdk.kotlin.services.kendra.model.StartDataSourceSyncJobRequest
import aws.sdk.kotlin.services.kendra.model.StartDataSourceSyncJobResponse
import aws.sdk.kotlin.services.kendra.model.StopDataSourceSyncJobRequest
import aws.sdk.kotlin.services.kendra.model.StopDataSourceSyncJobResponse
import aws.sdk.kotlin.services.kendra.model.SubmitFeedbackRequest
import aws.sdk.kotlin.services.kendra.model.SubmitFeedbackResponse
import aws.sdk.kotlin.services.kendra.model.TagResourceRequest
import aws.sdk.kotlin.services.kendra.model.TagResourceResponse
import aws.sdk.kotlin.services.kendra.model.UntagResourceRequest
import aws.sdk.kotlin.services.kendra.model.UntagResourceResponse
import aws.sdk.kotlin.services.kendra.model.UpdateAccessControlConfigurationRequest
import aws.sdk.kotlin.services.kendra.model.UpdateAccessControlConfigurationResponse
import aws.sdk.kotlin.services.kendra.model.UpdateDataSourceRequest
import aws.sdk.kotlin.services.kendra.model.UpdateDataSourceResponse
import aws.sdk.kotlin.services.kendra.model.UpdateExperienceRequest
import aws.sdk.kotlin.services.kendra.model.UpdateExperienceResponse
import aws.sdk.kotlin.services.kendra.model.UpdateFeaturedResultsSetRequest
import aws.sdk.kotlin.services.kendra.model.UpdateFeaturedResultsSetResponse
import aws.sdk.kotlin.services.kendra.model.UpdateIndexRequest
import aws.sdk.kotlin.services.kendra.model.UpdateIndexResponse
import aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsBlockListRequest
import aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsBlockListResponse
import aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsConfigRequest
import aws.sdk.kotlin.services.kendra.model.UpdateQuerySuggestionsConfigResponse
import aws.sdk.kotlin.services.kendra.model.UpdateThesaurusRequest
import aws.sdk.kotlin.services.kendra.model.UpdateThesaurusResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * Amazon Kendra is a service for indexing large document sets.
 */
public interface KendraClient : SdkClient {
    /**
     * KendraClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, KendraClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, KendraClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): KendraClient = DefaultKendraClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val clientName: String = builder.clientName
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, clientName)
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, IdempotencyTokenConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "kendra"

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Grants users or groups in your IAM Identity Center identity source access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    public suspend fun associateEntitiesToExperience(input: AssociateEntitiesToExperienceRequest): AssociateEntitiesToExperienceResponse

    /**
     * Defines the specific permissions of users or groups in your IAM Identity Center identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    public suspend fun associatePersonasToEntities(input: AssociatePersonasToEntitiesRequest): AssociatePersonasToEntitiesResponse

    /**
     * Removes one or more documents from an index. The documents must have been added with the `BatchPutDocument` API.
     *
     * The documents are deleted asynchronously. You can see the progress of the deletion by using Amazon Web Services CloudWatch. Any error messages related to the processing of the batch are sent to you CloudWatch log.
     */
    public suspend fun batchDeleteDocument(input: BatchDeleteDocumentRequest): BatchDeleteDocumentResponse

    /**
     * Removes one or more sets of featured results. Features results are placed above all other results for certain queries. If there's an exact match of a query, then one or more specific documents are featured in the search results.
     */
    public suspend fun batchDeleteFeaturedResultsSet(input: BatchDeleteFeaturedResultsSetRequest): BatchDeleteFeaturedResultsSetResponse

    /**
     * Returns the indexing status for one or more documents submitted with the [ BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html) API.
     *
     * When you use the `BatchPutDocument` API, documents are indexed asynchronously. You can use the `BatchGetDocumentStatus` API to get the current status of a list of documents so that you can determine if they have been successfully indexed.
     *
     * You can also use the `BatchGetDocumentStatus` API to check the status of the [ BatchDeleteDocument](https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html) API. When a document is deleted from the index, Amazon Kendra returns `NOT_FOUND` as the status.
     */
    public suspend fun batchGetDocumentStatus(input: BatchGetDocumentStatusRequest): BatchGetDocumentStatusResponse

    /**
     * Adds one or more documents to an index.
     *
     * The `BatchPutDocument` API enables you to ingest inline documents or a set of documents stored in an Amazon S3 bucket. Use this API to ingest your text and unstructured text into an index, add custom attributes to the documents, and to attach an access control list to the documents added to the index.
     *
     * The documents are indexed asynchronously. You can see the progress of the batch using Amazon Web Services CloudWatch. Any error messages related to processing the batch are sent to your Amazon Web Services CloudWatch log.
     *
     * For an example of ingesting inline documents using Python and Java SDKs, see [Adding files directly to an index](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-binary-doc.html).
     */
    public suspend fun batchPutDocument(input: BatchPutDocumentRequest): BatchPutDocumentResponse

    /**
     * Clears existing query suggestions from an index.
     *
     * This deletes existing suggestions only, not the queries in the query log. After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions. If you do not see any new suggestions, then please allow Amazon Kendra to collect enough queries to learn new suggestions.
     *
     * `ClearQuerySuggestions` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    public suspend fun clearQuerySuggestions(input: ClearQuerySuggestionsRequest): ClearQuerySuggestionsResponse

    /**
     * Creates an access configuration for your documents. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
     *
     * You can use this to re-configure your existing document level access control without indexing all of your documents again. For example, your index contains top-secret company documents that only certain employees or users should access. One of these users leaves the company or switches to a team that should be blocked from accessing top-secret documents. The user still has access to top-secret documents because the user had access when your documents were previously indexed. You can create a specific access control configuration for the user with deny access. You can later update the access control configuration to allow access if the user returns to the company and re-joins the 'top-secret' team. You can re-configure access control for your documents as circumstances change.
     *
     * To apply your access control configuration to certain documents, you call the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html) API with the `AccessControlConfigurationId` included in the [Document](https://docs.aws.amazon.com/kendra/latest/dg/API_Document.html) object. If you use an S3 bucket as a data source, you update the `.metadata.json` with the `AccessControlConfigurationId` and synchronize your data source. Amazon Kendra currently only supports access control configuration for S3 data sources and documents indexed using the `BatchPutDocument` API.
     */
    public suspend fun createAccessControlConfiguration(input: CreateAccessControlConfigurationRequest): CreateAccessControlConfigurationResponse

    /**
     * Creates a data source connector that you want to use with an Amazon Kendra index.
     *
     * You specify a name, data source connector type and description for your data source. You also specify configuration information for the data source connector.
     *
     * `CreateDataSource` is a synchronous operation. The operation returns 200 if the data source was successfully created. Otherwise, an exception is raised.
     *
     * For an example of creating an index and data source using the Python SDK, see [Getting started with Python SDK](https://docs.aws.amazon.com/kendra/latest/dg/gs-python.html). For an example of creating an index and data source using the Java SDK, see [Getting started with Java SDK](https://docs.aws.amazon.com/kendra/latest/dg/gs-java.html).
     */
    public suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse

    /**
     * Creates an Amazon Kendra experience such as a search application. For more information on creating a search application experience, including using the Python and Java SDKs, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    public suspend fun createExperience(input: CreateExperienceRequest): CreateExperienceResponse

    /**
     * Creates a set of frequently ask questions (FAQs) using a specified FAQ file stored in an Amazon S3 bucket.
     *
     * Adding FAQs to an index is an asynchronous operation.
     *
     * For an example of adding an FAQ to an index using Python and Java SDKs, see [Using your FAQ file](https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html#using-faq-file).
     */
    public suspend fun createFaq(input: CreateFaqRequest): CreateFaqResponse

    /**
     * Creates a set of featured results to display at the top of the search results page. Featured results are placed above all other results for certain queries. You map specific queries to specific documents for featuring in the results. If a query contains an exact match, then one or more specific documents are featured in the search results.
     *
     * You can create up to 50 sets of featured results per index. You can request to increase this limit by contacting [Support](http://aws.amazon.com/contact-us/).
     */
    public suspend fun createFeaturedResultsSet(input: CreateFeaturedResultsSetRequest): CreateFeaturedResultsSetResponse

    /**
     * Creates an Amazon Kendra index. Index creation is an asynchronous API. To determine if index creation has completed, check the `Status` field returned from a call to `DescribeIndex`. The `Status` field is set to `ACTIVE` when the index is ready to use.
     *
     * Once the index is active you can index your documents using the `BatchPutDocument` API or using one of the supported data sources.
     *
     * For an example of creating an index and data source using the Python SDK, see [Getting started with Python SDK](https://docs.aws.amazon.com/kendra/latest/dg/gs-python.html). For an example of creating an index and data source using the Java SDK, see [Getting started with Java SDK](https://docs.aws.amazon.com/kendra/latest/dg/gs-java.html).
     */
    public suspend fun createIndex(input: CreateIndexRequest): CreateIndexResponse

    /**
     * Creates a block list to exlcude certain queries from suggestions.
     *
     * Any query that contains words or phrases specified in the block list is blocked or filtered out from being shown as a suggestion.
     *
     * You need to provide the file location of your block list text file in your S3 bucket. In your text file, enter each block word or phrase on a separate line.
     *
     * For information on the current quota limits for block lists, see [Quotas for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
     *
     * `CreateQuerySuggestionsBlockList` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     *
     * For an example of creating a block list for query suggestions using the Python SDK, see [Query suggestions block list](https://docs.aws.amazon.com/kendra/latest/dg/query-suggestions.html#query-suggestions-blocklist).
     */
    public suspend fun createQuerySuggestionsBlockList(input: CreateQuerySuggestionsBlockListRequest): CreateQuerySuggestionsBlockListResponse

    /**
     * Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.
     *
     * For an example of adding a thesaurus file to an index, see [Adding custom synonyms to an index](https://docs.aws.amazon.com/kendra/latest/dg/index-synonyms-adding-thesaurus-file.html).
     */
    public suspend fun createThesaurus(input: CreateThesaurusRequest): CreateThesaurusResponse

    /**
     * Deletes an access control configuration that you created for your documents in an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
     */
    public suspend fun deleteAccessControlConfiguration(input: DeleteAccessControlConfigurationRequest): DeleteAccessControlConfigurationResponse

    /**
     * Deletes an Amazon Kendra data source connector. An exception is not thrown if the data source is already being deleted. While the data source is being deleted, the `Status` field returned by a call to the `DescribeDataSource` API is set to `DELETING`. For more information, see [Deleting Data Sources](https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html).
     */
    public suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Deletes your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    public suspend fun deleteExperience(input: DeleteExperienceRequest): DeleteExperienceResponse

    /**
     * Removes an FAQ from an index.
     */
    public suspend fun deleteFaq(input: DeleteFaqRequest): DeleteFaqResponse

    /**
     * Deletes an existing Amazon Kendra index. An exception is not thrown if the index is already being deleted. While the index is being deleted, the `Status` field returned by a call to the `DescribeIndex` API is set to `DELETING`.
     */
    public suspend fun deleteIndex(input: DeleteIndexRequest): DeleteIndexResponse

    /**
     * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only available to that group.
     *
     * For example, after deleting the group "Summer Interns", all interns who belonged to that group no longer see intern-only documents in their search results.
     *
     * If you want to delete or replace users or sub groups of a group, you need to use the `PutPrincipalMapping` operation. For example, if a user in the group "Engineering" leaves the engineering team and another user takes their place, you provide an updated list of users or sub groups that belong to the "Engineering" group when calling `PutPrincipalMapping`. You can update your internal list of users or sub groups and input this list when calling `PutPrincipalMapping`.
     *
     * `DeletePrincipalMapping` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    public suspend fun deletePrincipalMapping(input: DeletePrincipalMappingRequest): DeletePrincipalMappingResponse

    /**
     * Deletes a block list used for query suggestions for an index.
     *
     * A deleted block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to add back the queries that were previously blocked.
     *
     * `DeleteQuerySuggestionsBlockList` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    public suspend fun deleteQuerySuggestionsBlockList(input: DeleteQuerySuggestionsBlockListRequest): DeleteQuerySuggestionsBlockListResponse

    /**
     * Deletes an existing Amazon Kendra thesaurus.
     */
    public suspend fun deleteThesaurus(input: DeleteThesaurusRequest): DeleteThesaurusResponse

    /**
     * Gets information about an access control configuration that you created for your documents in an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
     */
    public suspend fun describeAccessControlConfiguration(input: DescribeAccessControlConfigurationRequest): DescribeAccessControlConfigurationResponse

    /**
     * Gets information about an Amazon Kendra data source connector.
     */
    public suspend fun describeDataSource(input: DescribeDataSourceRequest): DescribeDataSourceResponse

    /**
     * Gets information about your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    public suspend fun describeExperience(input: DescribeExperienceRequest): DescribeExperienceResponse

    /**
     * Gets information about an FAQ list.
     */
    public suspend fun describeFaq(input: DescribeFaqRequest): DescribeFaqResponse

    /**
     * Gets information about a set of featured results. Features results are placed above all other results for certain queries. If there's an exact match of a query, then one or more specific documents are featured in the search results.
     */
    public suspend fun describeFeaturedResultsSet(input: DescribeFeaturedResultsSetRequest): DescribeFeaturedResultsSetResponse

    /**
     * Gets information about an existing Amazon Kendra index.
     */
    public suspend fun describeIndex(input: DescribeIndexRequest): DescribeIndexResponse

    /**
     * Describes the processing of `PUT` and `DELETE` actions for mapping users to their groups. This includes information on the status of actions currently processing or yet to be processed, when actions were last updated, when actions were received by Amazon Kendra, the latest action that should process and apply after other actions, and useful error messages if an action could not be processed.
     *
     * `DescribePrincipalMapping` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    public suspend fun describePrincipalMapping(input: DescribePrincipalMappingRequest): DescribePrincipalMappingResponse

    /**
     * Gets information about a block list used for query suggestions for an index.
     *
     * This is used to check the current settings that are applied to a block list.
     *
     * `DescribeQuerySuggestionsBlockList` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    public suspend fun describeQuerySuggestionsBlockList(input: DescribeQuerySuggestionsBlockListRequest): DescribeQuerySuggestionsBlockListResponse

    /**
     * Gets information on the settings of query suggestions for an index.
     *
     * This is used to check the current settings applied to query suggestions.
     *
     * `DescribeQuerySuggestionsConfig` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    public suspend fun describeQuerySuggestionsConfig(input: DescribeQuerySuggestionsConfigRequest): DescribeQuerySuggestionsConfigResponse

    /**
     * Gets information about an existing Amazon Kendra thesaurus.
     */
    public suspend fun describeThesaurus(input: DescribeThesaurusRequest): DescribeThesaurusResponse

    /**
     * Prevents users or groups in your IAM Identity Center identity source from accessing your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    public suspend fun disassociateEntitiesFromExperience(input: DisassociateEntitiesFromExperienceRequest): DisassociateEntitiesFromExperienceResponse

    /**
     * Removes the specific permissions of users or groups in your IAM Identity Center identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    public suspend fun disassociatePersonasFromEntities(input: DisassociatePersonasFromEntitiesRequest): DisassociatePersonasFromEntitiesResponse

    /**
     * Fetches the queries that are suggested to your users.
     *
     * `GetQuerySuggestions` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    public suspend fun getQuerySuggestions(input: GetQuerySuggestionsRequest): GetQuerySuggestionsResponse

    /**
     * Retrieves search metrics data. The data provides a snapshot of how your users interact with your search application and how effective the application is.
     */
    public suspend fun getSnapshots(input: GetSnapshotsRequest): GetSnapshotsResponse

    /**
     * Lists one or more access control configurations for an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
     */
    public suspend fun listAccessControlConfigurations(input: ListAccessControlConfigurationsRequest): ListAccessControlConfigurationsResponse

    /**
     * Gets statistics about synchronizing a data source connector.
     */
    public suspend fun listDataSourceSyncJobs(input: ListDataSourceSyncJobsRequest): ListDataSourceSyncJobsResponse

    /**
     * Lists the data source connectors that you have created.
     */
    public suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse

    /**
     * Lists specific permissions of users and groups with access to your Amazon Kendra experience.
     */
    public suspend fun listEntityPersonas(input: ListEntityPersonasRequest): ListEntityPersonasResponse

    /**
     * Lists users or groups in your IAM Identity Center identity source that are granted access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    public suspend fun listExperienceEntities(input: ListExperienceEntitiesRequest): ListExperienceEntitiesResponse

    /**
     * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    public suspend fun listExperiences(input: ListExperiencesRequest): ListExperiencesResponse

    /**
     * Gets a list of FAQ lists associated with an index.
     */
    public suspend fun listFaqs(input: ListFaqsRequest): ListFaqsResponse

    /**
     * Lists all your sets of featured results for a given index. Features results are placed above all other results for certain queries. If there's an exact match of a query, then one or more specific documents are featured in the search results.
     */
    public suspend fun listFeaturedResultsSets(input: ListFeaturedResultsSetsRequest): ListFeaturedResultsSetsResponse

    /**
     * Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.
     *
     * `ListGroupsOlderThanOrderingId` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    public suspend fun listGroupsOlderThanOrderingId(input: ListGroupsOlderThanOrderingIdRequest): ListGroupsOlderThanOrderingIdResponse

    /**
     * Lists the Amazon Kendra indexes that you created.
     */
    public suspend fun listIndices(input: ListIndicesRequest = ListIndicesRequest {}): ListIndicesResponse

    /**
     * Lists the block lists used for query suggestions for an index.
     *
     * For information on the current quota limits for block lists, see [Quotas for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
     *
     * `ListQuerySuggestionsBlockLists` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    public suspend fun listQuerySuggestionsBlockLists(input: ListQuerySuggestionsBlockListsRequest): ListQuerySuggestionsBlockListsResponse

    /**
     * Gets a list of tags associated with a specified resource. Indexes, FAQs, and data sources can have tags associated with them.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the thesauri for an index.
     */
    public suspend fun listThesauri(input: ListThesauriRequest): ListThesauriResponse

    /**
     * Maps users to their groups so that you only need to provide the user ID when you issue the query.
     *
     * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these teams. Only users who work in research and engineering, and therefore belong in the intellectual property group, can see top-secret company documents in their search results.
     *
     * This is useful for user context filtering, where search results are filtered based on the user or their group access to documents. For more information, see [Filtering on user context](https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html).
     *
     * If more than five `PUT` actions for a group are currently processing, a validation exception is thrown.
     */
    public suspend fun putPrincipalMapping(input: PutPrincipalMappingRequest): PutPrincipalMappingResponse

    /**
     * Searches an active index. Use this API to search your documents using query. The `Query` API enables to do faceted search and to filter results based on document attributes.
     *
     * It also enables you to provide user context that Amazon Kendra uses to enforce document access control in the search results.
     *
     * Amazon Kendra searches your index for text content and question and answer (FAQ) content. By default the response contains three types of results.
     * + Relevant passages
     * + Matching FAQs
     * + Relevant documents
     *
     * You can specify that the query return only one type of result using the `QueryResultTypeFilter` parameter.
     *
     * Each query returns the 100 most relevant results.
     */
    public suspend fun query(input: QueryRequest): QueryResponse

    /**
     * Starts a synchronization job for a data source connector. If a synchronization job is already in progress, Amazon Kendra returns a `ResourceInUseException` exception.
     */
    public suspend fun startDataSourceSyncJob(input: StartDataSourceSyncJobRequest): StartDataSourceSyncJobResponse

    /**
     * Stops a synchronization job that is currently running. You can't stop a scheduled synchronization job.
     */
    public suspend fun stopDataSourceSyncJob(input: StopDataSourceSyncJobRequest): StopDataSourceSyncJobResponse

    /**
     * Enables you to provide feedback to Amazon Kendra to improve the performance of your index.
     *
     * `SubmitFeedback` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    public suspend fun submitFeedback(input: SubmitFeedbackRequest): SubmitFeedbackResponse

    /**
     * Adds the specified tag to the specified index, FAQ, or data source resource. If the tag already exists, the existing value is replaced with the new value.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag from an index, FAQ, or a data source.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an access control configuration for your documents in an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
     *
     * You can update an access control configuration you created without indexing all of your documents again. For example, your index contains top-secret company documents that only certain employees or users should access. You created an 'allow' access control configuration for one user who recently joined the 'top-secret' team, switching from a team with 'deny' access to top-secret documents. However, the user suddenly returns to their previous team and should no longer have access to top secret documents. You can update the access control configuration to re-configure access control for your documents as circumstances change.
     *
     * You call the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html) API to apply the updated access control configuration, with the `AccessControlConfigurationId` included in the [Document](https://docs.aws.amazon.com/kendra/latest/dg/API_Document.html) object. If you use an S3 bucket as a data source, you synchronize your data source to apply the `AccessControlConfigurationId` in the `.metadata.json` file. Amazon Kendra currently only supports access control configuration for S3 data sources and documents indexed using the `BatchPutDocument` API.
     */
    public suspend fun updateAccessControlConfiguration(input: UpdateAccessControlConfigurationRequest): UpdateAccessControlConfigurationResponse

    /**
     * Updates an existing Amazon Kendra data source connector.
     */
    public suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Updates your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
     */
    public suspend fun updateExperience(input: UpdateExperienceRequest): UpdateExperienceResponse

    /**
     * Updates a set of featured results. Features results are placed above all other results for certain queries. You map specific queries to specific documents for featuring in the results. If a query contains an exact match of a query, then one or more specific documents are featured in the search results.
     */
    public suspend fun updateFeaturedResultsSet(input: UpdateFeaturedResultsSetRequest): UpdateFeaturedResultsSetResponse

    /**
     * Updates an existing Amazon Kendra index.
     */
    public suspend fun updateIndex(input: UpdateIndexRequest): UpdateIndexResponse

    /**
     * Updates a block list used for query suggestions for an index.
     *
     * Updates to a block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to apply any updates to the block list. Other changes not related to the block list apply immediately.
     *
     * If a block list is updating, then you need to wait for the first update to finish before submitting another update.
     *
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     *
     * `UpdateQuerySuggestionsBlockList` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    public suspend fun updateQuerySuggestionsBlockList(input: UpdateQuerySuggestionsBlockListRequest): UpdateQuerySuggestionsBlockListResponse

    /**
     * Updates the settings of query suggestions for an index.
     *
     * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
     *
     * If an update is currently processing, you need to wait for the update to finish before making another update.
     *
     * Updates to query suggestions settings might not take effect right away. The time for your updated settings to take effect depends on the updates made and the number of search queries in your index.
     *
     * You can still enable/disable query suggestions at any time.
     *
     * `UpdateQuerySuggestionsConfig` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
     */
    public suspend fun updateQuerySuggestionsConfig(input: UpdateQuerySuggestionsConfigRequest): UpdateQuerySuggestionsConfigResponse

    /**
     * Updates a thesaurus for an index.
     */
    public suspend fun updateThesaurus(input: UpdateThesaurusRequest): UpdateThesaurusResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun KendraClient.withConfig(block: KendraClient.Config.Builder.() -> Unit): KendraClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultKendraClient(newConfig)
}

/**
 * Grants users or groups in your IAM Identity Center identity source access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
 */
public suspend inline fun KendraClient.associateEntitiesToExperience(crossinline block: AssociateEntitiesToExperienceRequest.Builder.() -> Unit): AssociateEntitiesToExperienceResponse = associateEntitiesToExperience(AssociateEntitiesToExperienceRequest.Builder().apply(block).build())

/**
 * Defines the specific permissions of users or groups in your IAM Identity Center identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
 */
public suspend inline fun KendraClient.associatePersonasToEntities(crossinline block: AssociatePersonasToEntitiesRequest.Builder.() -> Unit): AssociatePersonasToEntitiesResponse = associatePersonasToEntities(AssociatePersonasToEntitiesRequest.Builder().apply(block).build())

/**
 * Removes one or more documents from an index. The documents must have been added with the `BatchPutDocument` API.
 *
 * The documents are deleted asynchronously. You can see the progress of the deletion by using Amazon Web Services CloudWatch. Any error messages related to the processing of the batch are sent to you CloudWatch log.
 */
public suspend inline fun KendraClient.batchDeleteDocument(crossinline block: BatchDeleteDocumentRequest.Builder.() -> Unit): BatchDeleteDocumentResponse = batchDeleteDocument(BatchDeleteDocumentRequest.Builder().apply(block).build())

/**
 * Removes one or more sets of featured results. Features results are placed above all other results for certain queries. If there's an exact match of a query, then one or more specific documents are featured in the search results.
 */
public suspend inline fun KendraClient.batchDeleteFeaturedResultsSet(crossinline block: BatchDeleteFeaturedResultsSetRequest.Builder.() -> Unit): BatchDeleteFeaturedResultsSetResponse = batchDeleteFeaturedResultsSet(BatchDeleteFeaturedResultsSetRequest.Builder().apply(block).build())

/**
 * Returns the indexing status for one or more documents submitted with the [ BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html) API.
 *
 * When you use the `BatchPutDocument` API, documents are indexed asynchronously. You can use the `BatchGetDocumentStatus` API to get the current status of a list of documents so that you can determine if they have been successfully indexed.
 *
 * You can also use the `BatchGetDocumentStatus` API to check the status of the [ BatchDeleteDocument](https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html) API. When a document is deleted from the index, Amazon Kendra returns `NOT_FOUND` as the status.
 */
public suspend inline fun KendraClient.batchGetDocumentStatus(crossinline block: BatchGetDocumentStatusRequest.Builder.() -> Unit): BatchGetDocumentStatusResponse = batchGetDocumentStatus(BatchGetDocumentStatusRequest.Builder().apply(block).build())

/**
 * Adds one or more documents to an index.
 *
 * The `BatchPutDocument` API enables you to ingest inline documents or a set of documents stored in an Amazon S3 bucket. Use this API to ingest your text and unstructured text into an index, add custom attributes to the documents, and to attach an access control list to the documents added to the index.
 *
 * The documents are indexed asynchronously. You can see the progress of the batch using Amazon Web Services CloudWatch. Any error messages related to processing the batch are sent to your Amazon Web Services CloudWatch log.
 *
 * For an example of ingesting inline documents using Python and Java SDKs, see [Adding files directly to an index](https://docs.aws.amazon.com/kendra/latest/dg/in-adding-binary-doc.html).
 */
public suspend inline fun KendraClient.batchPutDocument(crossinline block: BatchPutDocumentRequest.Builder.() -> Unit): BatchPutDocumentResponse = batchPutDocument(BatchPutDocumentRequest.Builder().apply(block).build())

/**
 * Clears existing query suggestions from an index.
 *
 * This deletes existing suggestions only, not the queries in the query log. After you clear suggestions, Amazon Kendra learns new suggestions based on new queries added to the query log from the time you cleared suggestions. If you do not see any new suggestions, then please allow Amazon Kendra to collect enough queries to learn new suggestions.
 *
 * `ClearQuerySuggestions` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
 */
public suspend inline fun KendraClient.clearQuerySuggestions(crossinline block: ClearQuerySuggestionsRequest.Builder.() -> Unit): ClearQuerySuggestionsResponse = clearQuerySuggestions(ClearQuerySuggestionsRequest.Builder().apply(block).build())

/**
 * Creates an access configuration for your documents. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
 *
 * You can use this to re-configure your existing document level access control without indexing all of your documents again. For example, your index contains top-secret company documents that only certain employees or users should access. One of these users leaves the company or switches to a team that should be blocked from accessing top-secret documents. The user still has access to top-secret documents because the user had access when your documents were previously indexed. You can create a specific access control configuration for the user with deny access. You can later update the access control configuration to allow access if the user returns to the company and re-joins the 'top-secret' team. You can re-configure access control for your documents as circumstances change.
 *
 * To apply your access control configuration to certain documents, you call the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html) API with the `AccessControlConfigurationId` included in the [Document](https://docs.aws.amazon.com/kendra/latest/dg/API_Document.html) object. If you use an S3 bucket as a data source, you update the `.metadata.json` with the `AccessControlConfigurationId` and synchronize your data source. Amazon Kendra currently only supports access control configuration for S3 data sources and documents indexed using the `BatchPutDocument` API.
 */
public suspend inline fun KendraClient.createAccessControlConfiguration(crossinline block: CreateAccessControlConfigurationRequest.Builder.() -> Unit): CreateAccessControlConfigurationResponse = createAccessControlConfiguration(CreateAccessControlConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a data source connector that you want to use with an Amazon Kendra index.
 *
 * You specify a name, data source connector type and description for your data source. You also specify configuration information for the data source connector.
 *
 * `CreateDataSource` is a synchronous operation. The operation returns 200 if the data source was successfully created. Otherwise, an exception is raised.
 *
 * For an example of creating an index and data source using the Python SDK, see [Getting started with Python SDK](https://docs.aws.amazon.com/kendra/latest/dg/gs-python.html). For an example of creating an index and data source using the Java SDK, see [Getting started with Java SDK](https://docs.aws.amazon.com/kendra/latest/dg/gs-java.html).
 */
public suspend inline fun KendraClient.createDataSource(crossinline block: CreateDataSourceRequest.Builder.() -> Unit): CreateDataSourceResponse = createDataSource(CreateDataSourceRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Kendra experience such as a search application. For more information on creating a search application experience, including using the Python and Java SDKs, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
 */
public suspend inline fun KendraClient.createExperience(crossinline block: CreateExperienceRequest.Builder.() -> Unit): CreateExperienceResponse = createExperience(CreateExperienceRequest.Builder().apply(block).build())

/**
 * Creates a set of frequently ask questions (FAQs) using a specified FAQ file stored in an Amazon S3 bucket.
 *
 * Adding FAQs to an index is an asynchronous operation.
 *
 * For an example of adding an FAQ to an index using Python and Java SDKs, see [Using your FAQ file](https://docs.aws.amazon.com/kendra/latest/dg/in-creating-faq.html#using-faq-file).
 */
public suspend inline fun KendraClient.createFaq(crossinline block: CreateFaqRequest.Builder.() -> Unit): CreateFaqResponse = createFaq(CreateFaqRequest.Builder().apply(block).build())

/**
 * Creates a set of featured results to display at the top of the search results page. Featured results are placed above all other results for certain queries. You map specific queries to specific documents for featuring in the results. If a query contains an exact match, then one or more specific documents are featured in the search results.
 *
 * You can create up to 50 sets of featured results per index. You can request to increase this limit by contacting [Support](http://aws.amazon.com/contact-us/).
 */
public suspend inline fun KendraClient.createFeaturedResultsSet(crossinline block: CreateFeaturedResultsSetRequest.Builder.() -> Unit): CreateFeaturedResultsSetResponse = createFeaturedResultsSet(CreateFeaturedResultsSetRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Kendra index. Index creation is an asynchronous API. To determine if index creation has completed, check the `Status` field returned from a call to `DescribeIndex`. The `Status` field is set to `ACTIVE` when the index is ready to use.
 *
 * Once the index is active you can index your documents using the `BatchPutDocument` API or using one of the supported data sources.
 *
 * For an example of creating an index and data source using the Python SDK, see [Getting started with Python SDK](https://docs.aws.amazon.com/kendra/latest/dg/gs-python.html). For an example of creating an index and data source using the Java SDK, see [Getting started with Java SDK](https://docs.aws.amazon.com/kendra/latest/dg/gs-java.html).
 */
public suspend inline fun KendraClient.createIndex(crossinline block: CreateIndexRequest.Builder.() -> Unit): CreateIndexResponse = createIndex(CreateIndexRequest.Builder().apply(block).build())

/**
 * Creates a block list to exlcude certain queries from suggestions.
 *
 * Any query that contains words or phrases specified in the block list is blocked or filtered out from being shown as a suggestion.
 *
 * You need to provide the file location of your block list text file in your S3 bucket. In your text file, enter each block word or phrase on a separate line.
 *
 * For information on the current quota limits for block lists, see [Quotas for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
 *
 * `CreateQuerySuggestionsBlockList` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
 *
 * For an example of creating a block list for query suggestions using the Python SDK, see [Query suggestions block list](https://docs.aws.amazon.com/kendra/latest/dg/query-suggestions.html#query-suggestions-blocklist).
 */
public suspend inline fun KendraClient.createQuerySuggestionsBlockList(crossinline block: CreateQuerySuggestionsBlockListRequest.Builder.() -> Unit): CreateQuerySuggestionsBlockListResponse = createQuerySuggestionsBlockList(CreateQuerySuggestionsBlockListRequest.Builder().apply(block).build())

/**
 * Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.
 *
 * For an example of adding a thesaurus file to an index, see [Adding custom synonyms to an index](https://docs.aws.amazon.com/kendra/latest/dg/index-synonyms-adding-thesaurus-file.html).
 */
public suspend inline fun KendraClient.createThesaurus(crossinline block: CreateThesaurusRequest.Builder.() -> Unit): CreateThesaurusResponse = createThesaurus(CreateThesaurusRequest.Builder().apply(block).build())

/**
 * Deletes an access control configuration that you created for your documents in an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
 */
public suspend inline fun KendraClient.deleteAccessControlConfiguration(crossinline block: DeleteAccessControlConfigurationRequest.Builder.() -> Unit): DeleteAccessControlConfigurationResponse = deleteAccessControlConfiguration(DeleteAccessControlConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Kendra data source connector. An exception is not thrown if the data source is already being deleted. While the data source is being deleted, the `Status` field returned by a call to the `DescribeDataSource` API is set to `DELETING`. For more information, see [Deleting Data Sources](https://docs.aws.amazon.com/kendra/latest/dg/delete-data-source.html).
 */
public suspend inline fun KendraClient.deleteDataSource(crossinline block: DeleteDataSourceRequest.Builder.() -> Unit): DeleteDataSourceResponse = deleteDataSource(DeleteDataSourceRequest.Builder().apply(block).build())

/**
 * Deletes your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
 */
public suspend inline fun KendraClient.deleteExperience(crossinline block: DeleteExperienceRequest.Builder.() -> Unit): DeleteExperienceResponse = deleteExperience(DeleteExperienceRequest.Builder().apply(block).build())

/**
 * Removes an FAQ from an index.
 */
public suspend inline fun KendraClient.deleteFaq(crossinline block: DeleteFaqRequest.Builder.() -> Unit): DeleteFaqResponse = deleteFaq(DeleteFaqRequest.Builder().apply(block).build())

/**
 * Deletes an existing Amazon Kendra index. An exception is not thrown if the index is already being deleted. While the index is being deleted, the `Status` field returned by a call to the `DescribeIndex` API is set to `DELETING`.
 */
public suspend inline fun KendraClient.deleteIndex(crossinline block: DeleteIndexRequest.Builder.() -> Unit): DeleteIndexResponse = deleteIndex(DeleteIndexRequest.Builder().apply(block).build())

/**
 * Deletes a group so that all users and sub groups that belong to the group can no longer access documents only available to that group.
 *
 * For example, after deleting the group "Summer Interns", all interns who belonged to that group no longer see intern-only documents in their search results.
 *
 * If you want to delete or replace users or sub groups of a group, you need to use the `PutPrincipalMapping` operation. For example, if a user in the group "Engineering" leaves the engineering team and another user takes their place, you provide an updated list of users or sub groups that belong to the "Engineering" group when calling `PutPrincipalMapping`. You can update your internal list of users or sub groups and input this list when calling `PutPrincipalMapping`.
 *
 * `DeletePrincipalMapping` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
 */
public suspend inline fun KendraClient.deletePrincipalMapping(crossinline block: DeletePrincipalMappingRequest.Builder.() -> Unit): DeletePrincipalMappingResponse = deletePrincipalMapping(DeletePrincipalMappingRequest.Builder().apply(block).build())

/**
 * Deletes a block list used for query suggestions for an index.
 *
 * A deleted block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to add back the queries that were previously blocked.
 *
 * `DeleteQuerySuggestionsBlockList` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
 */
public suspend inline fun KendraClient.deleteQuerySuggestionsBlockList(crossinline block: DeleteQuerySuggestionsBlockListRequest.Builder.() -> Unit): DeleteQuerySuggestionsBlockListResponse = deleteQuerySuggestionsBlockList(DeleteQuerySuggestionsBlockListRequest.Builder().apply(block).build())

/**
 * Deletes an existing Amazon Kendra thesaurus.
 */
public suspend inline fun KendraClient.deleteThesaurus(crossinline block: DeleteThesaurusRequest.Builder.() -> Unit): DeleteThesaurusResponse = deleteThesaurus(DeleteThesaurusRequest.Builder().apply(block).build())

/**
 * Gets information about an access control configuration that you created for your documents in an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
 */
public suspend inline fun KendraClient.describeAccessControlConfiguration(crossinline block: DescribeAccessControlConfigurationRequest.Builder.() -> Unit): DescribeAccessControlConfigurationResponse = describeAccessControlConfiguration(DescribeAccessControlConfigurationRequest.Builder().apply(block).build())

/**
 * Gets information about an Amazon Kendra data source connector.
 */
public suspend inline fun KendraClient.describeDataSource(crossinline block: DescribeDataSourceRequest.Builder.() -> Unit): DescribeDataSourceResponse = describeDataSource(DescribeDataSourceRequest.Builder().apply(block).build())

/**
 * Gets information about your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
 */
public suspend inline fun KendraClient.describeExperience(crossinline block: DescribeExperienceRequest.Builder.() -> Unit): DescribeExperienceResponse = describeExperience(DescribeExperienceRequest.Builder().apply(block).build())

/**
 * Gets information about an FAQ list.
 */
public suspend inline fun KendraClient.describeFaq(crossinline block: DescribeFaqRequest.Builder.() -> Unit): DescribeFaqResponse = describeFaq(DescribeFaqRequest.Builder().apply(block).build())

/**
 * Gets information about a set of featured results. Features results are placed above all other results for certain queries. If there's an exact match of a query, then one or more specific documents are featured in the search results.
 */
public suspend inline fun KendraClient.describeFeaturedResultsSet(crossinline block: DescribeFeaturedResultsSetRequest.Builder.() -> Unit): DescribeFeaturedResultsSetResponse = describeFeaturedResultsSet(DescribeFeaturedResultsSetRequest.Builder().apply(block).build())

/**
 * Gets information about an existing Amazon Kendra index.
 */
public suspend inline fun KendraClient.describeIndex(crossinline block: DescribeIndexRequest.Builder.() -> Unit): DescribeIndexResponse = describeIndex(DescribeIndexRequest.Builder().apply(block).build())

/**
 * Describes the processing of `PUT` and `DELETE` actions for mapping users to their groups. This includes information on the status of actions currently processing or yet to be processed, when actions were last updated, when actions were received by Amazon Kendra, the latest action that should process and apply after other actions, and useful error messages if an action could not be processed.
 *
 * `DescribePrincipalMapping` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
 */
public suspend inline fun KendraClient.describePrincipalMapping(crossinline block: DescribePrincipalMappingRequest.Builder.() -> Unit): DescribePrincipalMappingResponse = describePrincipalMapping(DescribePrincipalMappingRequest.Builder().apply(block).build())

/**
 * Gets information about a block list used for query suggestions for an index.
 *
 * This is used to check the current settings that are applied to a block list.
 *
 * `DescribeQuerySuggestionsBlockList` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
 */
public suspend inline fun KendraClient.describeQuerySuggestionsBlockList(crossinline block: DescribeQuerySuggestionsBlockListRequest.Builder.() -> Unit): DescribeQuerySuggestionsBlockListResponse = describeQuerySuggestionsBlockList(DescribeQuerySuggestionsBlockListRequest.Builder().apply(block).build())

/**
 * Gets information on the settings of query suggestions for an index.
 *
 * This is used to check the current settings applied to query suggestions.
 *
 * `DescribeQuerySuggestionsConfig` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
 */
public suspend inline fun KendraClient.describeQuerySuggestionsConfig(crossinline block: DescribeQuerySuggestionsConfigRequest.Builder.() -> Unit): DescribeQuerySuggestionsConfigResponse = describeQuerySuggestionsConfig(DescribeQuerySuggestionsConfigRequest.Builder().apply(block).build())

/**
 * Gets information about an existing Amazon Kendra thesaurus.
 */
public suspend inline fun KendraClient.describeThesaurus(crossinline block: DescribeThesaurusRequest.Builder.() -> Unit): DescribeThesaurusResponse = describeThesaurus(DescribeThesaurusRequest.Builder().apply(block).build())

/**
 * Prevents users or groups in your IAM Identity Center identity source from accessing your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
 */
public suspend inline fun KendraClient.disassociateEntitiesFromExperience(crossinline block: DisassociateEntitiesFromExperienceRequest.Builder.() -> Unit): DisassociateEntitiesFromExperienceResponse = disassociateEntitiesFromExperience(DisassociateEntitiesFromExperienceRequest.Builder().apply(block).build())

/**
 * Removes the specific permissions of users or groups in your IAM Identity Center identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
 */
public suspend inline fun KendraClient.disassociatePersonasFromEntities(crossinline block: DisassociatePersonasFromEntitiesRequest.Builder.() -> Unit): DisassociatePersonasFromEntitiesResponse = disassociatePersonasFromEntities(DisassociatePersonasFromEntitiesRequest.Builder().apply(block).build())

/**
 * Fetches the queries that are suggested to your users.
 *
 * `GetQuerySuggestions` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
 */
public suspend inline fun KendraClient.getQuerySuggestions(crossinline block: GetQuerySuggestionsRequest.Builder.() -> Unit): GetQuerySuggestionsResponse = getQuerySuggestions(GetQuerySuggestionsRequest.Builder().apply(block).build())

/**
 * Retrieves search metrics data. The data provides a snapshot of how your users interact with your search application and how effective the application is.
 */
public suspend inline fun KendraClient.getSnapshots(crossinline block: GetSnapshotsRequest.Builder.() -> Unit): GetSnapshotsResponse = getSnapshots(GetSnapshotsRequest.Builder().apply(block).build())

/**
 * Lists one or more access control configurations for an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
 */
public suspend inline fun KendraClient.listAccessControlConfigurations(crossinline block: ListAccessControlConfigurationsRequest.Builder.() -> Unit): ListAccessControlConfigurationsResponse = listAccessControlConfigurations(ListAccessControlConfigurationsRequest.Builder().apply(block).build())

/**
 * Gets statistics about synchronizing a data source connector.
 */
public suspend inline fun KendraClient.listDataSourceSyncJobs(crossinline block: ListDataSourceSyncJobsRequest.Builder.() -> Unit): ListDataSourceSyncJobsResponse = listDataSourceSyncJobs(ListDataSourceSyncJobsRequest.Builder().apply(block).build())

/**
 * Lists the data source connectors that you have created.
 */
public suspend inline fun KendraClient.listDataSources(crossinline block: ListDataSourcesRequest.Builder.() -> Unit): ListDataSourcesResponse = listDataSources(ListDataSourcesRequest.Builder().apply(block).build())

/**
 * Lists specific permissions of users and groups with access to your Amazon Kendra experience.
 */
public suspend inline fun KendraClient.listEntityPersonas(crossinline block: ListEntityPersonasRequest.Builder.() -> Unit): ListEntityPersonasResponse = listEntityPersonas(ListEntityPersonasRequest.Builder().apply(block).build())

/**
 * Lists users or groups in your IAM Identity Center identity source that are granted access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
 */
public suspend inline fun KendraClient.listExperienceEntities(crossinline block: ListExperienceEntitiesRequest.Builder.() -> Unit): ListExperienceEntitiesResponse = listExperienceEntities(ListExperienceEntitiesRequest.Builder().apply(block).build())

/**
 * Lists one or more Amazon Kendra experiences. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
 */
public suspend inline fun KendraClient.listExperiences(crossinline block: ListExperiencesRequest.Builder.() -> Unit): ListExperiencesResponse = listExperiences(ListExperiencesRequest.Builder().apply(block).build())

/**
 * Gets a list of FAQ lists associated with an index.
 */
public suspend inline fun KendraClient.listFaqs(crossinline block: ListFaqsRequest.Builder.() -> Unit): ListFaqsResponse = listFaqs(ListFaqsRequest.Builder().apply(block).build())

/**
 * Lists all your sets of featured results for a given index. Features results are placed above all other results for certain queries. If there's an exact match of a query, then one or more specific documents are featured in the search results.
 */
public suspend inline fun KendraClient.listFeaturedResultsSets(crossinline block: ListFeaturedResultsSetsRequest.Builder.() -> Unit): ListFeaturedResultsSetsResponse = listFeaturedResultsSets(ListFeaturedResultsSetsRequest.Builder().apply(block).build())

/**
 * Provides a list of groups that are mapped to users before a given ordering or timestamp identifier.
 *
 * `ListGroupsOlderThanOrderingId` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
 */
public suspend inline fun KendraClient.listGroupsOlderThanOrderingId(crossinline block: ListGroupsOlderThanOrderingIdRequest.Builder.() -> Unit): ListGroupsOlderThanOrderingIdResponse = listGroupsOlderThanOrderingId(ListGroupsOlderThanOrderingIdRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Kendra indexes that you created.
 */
public suspend inline fun KendraClient.listIndices(crossinline block: ListIndicesRequest.Builder.() -> Unit): ListIndicesResponse = listIndices(ListIndicesRequest.Builder().apply(block).build())

/**
 * Lists the block lists used for query suggestions for an index.
 *
 * For information on the current quota limits for block lists, see [Quotas for Amazon Kendra](https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
 *
 * `ListQuerySuggestionsBlockLists` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
 */
public suspend inline fun KendraClient.listQuerySuggestionsBlockLists(crossinline block: ListQuerySuggestionsBlockListsRequest.Builder.() -> Unit): ListQuerySuggestionsBlockListsResponse = listQuerySuggestionsBlockLists(ListQuerySuggestionsBlockListsRequest.Builder().apply(block).build())

/**
 * Gets a list of tags associated with a specified resource. Indexes, FAQs, and data sources can have tags associated with them.
 */
public suspend inline fun KendraClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the thesauri for an index.
 */
public suspend inline fun KendraClient.listThesauri(crossinline block: ListThesauriRequest.Builder.() -> Unit): ListThesauriResponse = listThesauri(ListThesauriRequest.Builder().apply(block).build())

/**
 * Maps users to their groups so that you only need to provide the user ID when you issue the query.
 *
 * You can also map sub groups to groups. For example, the group "Company Intellectual Property Teams" includes sub groups "Research" and "Engineering". These sub groups include their own list of users or people who work in these teams. Only users who work in research and engineering, and therefore belong in the intellectual property group, can see top-secret company documents in their search results.
 *
 * This is useful for user context filtering, where search results are filtered based on the user or their group access to documents. For more information, see [Filtering on user context](https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html).
 *
 * If more than five `PUT` actions for a group are currently processing, a validation exception is thrown.
 */
public suspend inline fun KendraClient.putPrincipalMapping(crossinline block: PutPrincipalMappingRequest.Builder.() -> Unit): PutPrincipalMappingResponse = putPrincipalMapping(PutPrincipalMappingRequest.Builder().apply(block).build())

/**
 * Searches an active index. Use this API to search your documents using query. The `Query` API enables to do faceted search and to filter results based on document attributes.
 *
 * It also enables you to provide user context that Amazon Kendra uses to enforce document access control in the search results.
 *
 * Amazon Kendra searches your index for text content and question and answer (FAQ) content. By default the response contains three types of results.
 * + Relevant passages
 * + Matching FAQs
 * + Relevant documents
 *
 * You can specify that the query return only one type of result using the `QueryResultTypeFilter` parameter.
 *
 * Each query returns the 100 most relevant results.
 */
public suspend inline fun KendraClient.query(crossinline block: QueryRequest.Builder.() -> Unit): QueryResponse = query(QueryRequest.Builder().apply(block).build())

/**
 * Starts a synchronization job for a data source connector. If a synchronization job is already in progress, Amazon Kendra returns a `ResourceInUseException` exception.
 */
public suspend inline fun KendraClient.startDataSourceSyncJob(crossinline block: StartDataSourceSyncJobRequest.Builder.() -> Unit): StartDataSourceSyncJobResponse = startDataSourceSyncJob(StartDataSourceSyncJobRequest.Builder().apply(block).build())

/**
 * Stops a synchronization job that is currently running. You can't stop a scheduled synchronization job.
 */
public suspend inline fun KendraClient.stopDataSourceSyncJob(crossinline block: StopDataSourceSyncJobRequest.Builder.() -> Unit): StopDataSourceSyncJobResponse = stopDataSourceSyncJob(StopDataSourceSyncJobRequest.Builder().apply(block).build())

/**
 * Enables you to provide feedback to Amazon Kendra to improve the performance of your index.
 *
 * `SubmitFeedback` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
 */
public suspend inline fun KendraClient.submitFeedback(crossinline block: SubmitFeedbackRequest.Builder.() -> Unit): SubmitFeedbackResponse = submitFeedback(SubmitFeedbackRequest.Builder().apply(block).build())

/**
 * Adds the specified tag to the specified index, FAQ, or data source resource. If the tag already exists, the existing value is replaced with the new value.
 */
public suspend inline fun KendraClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag from an index, FAQ, or a data source.
 */
public suspend inline fun KendraClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an access control configuration for your documents in an index. This includes user and group access information for your documents. This is useful for user context filtering, where search results are filtered based on the user or their group access to documents.
 *
 * You can update an access control configuration you created without indexing all of your documents again. For example, your index contains top-secret company documents that only certain employees or users should access. You created an 'allow' access control configuration for one user who recently joined the 'top-secret' team, switching from a team with 'deny' access to top-secret documents. However, the user suddenly returns to their previous team and should no longer have access to top secret documents. You can update the access control configuration to re-configure access control for your documents as circumstances change.
 *
 * You call the [BatchPutDocument](https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html) API to apply the updated access control configuration, with the `AccessControlConfigurationId` included in the [Document](https://docs.aws.amazon.com/kendra/latest/dg/API_Document.html) object. If you use an S3 bucket as a data source, you synchronize your data source to apply the `AccessControlConfigurationId` in the `.metadata.json` file. Amazon Kendra currently only supports access control configuration for S3 data sources and documents indexed using the `BatchPutDocument` API.
 */
public suspend inline fun KendraClient.updateAccessControlConfiguration(crossinline block: UpdateAccessControlConfigurationRequest.Builder.() -> Unit): UpdateAccessControlConfigurationResponse = updateAccessControlConfiguration(UpdateAccessControlConfigurationRequest.Builder().apply(block).build())

/**
 * Updates an existing Amazon Kendra data source connector.
 */
public suspend inline fun KendraClient.updateDataSource(crossinline block: UpdateDataSourceRequest.Builder.() -> Unit): UpdateDataSourceResponse = updateDataSource(UpdateDataSourceRequest.Builder().apply(block).build())

/**
 * Updates your Amazon Kendra experience such as a search application. For more information on creating a search application experience, see [Building a search experience with no code](https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
 */
public suspend inline fun KendraClient.updateExperience(crossinline block: UpdateExperienceRequest.Builder.() -> Unit): UpdateExperienceResponse = updateExperience(UpdateExperienceRequest.Builder().apply(block).build())

/**
 * Updates a set of featured results. Features results are placed above all other results for certain queries. You map specific queries to specific documents for featuring in the results. If a query contains an exact match of a query, then one or more specific documents are featured in the search results.
 */
public suspend inline fun KendraClient.updateFeaturedResultsSet(crossinline block: UpdateFeaturedResultsSetRequest.Builder.() -> Unit): UpdateFeaturedResultsSetResponse = updateFeaturedResultsSet(UpdateFeaturedResultsSetRequest.Builder().apply(block).build())

/**
 * Updates an existing Amazon Kendra index.
 */
public suspend inline fun KendraClient.updateIndex(crossinline block: UpdateIndexRequest.Builder.() -> Unit): UpdateIndexResponse = updateIndex(UpdateIndexRequest.Builder().apply(block).build())

/**
 * Updates a block list used for query suggestions for an index.
 *
 * Updates to a block list might not take effect right away. Amazon Kendra needs to refresh the entire suggestions list to apply any updates to the block list. Other changes not related to the block list apply immediately.
 *
 * If a block list is updating, then you need to wait for the first update to finish before submitting another update.
 *
 * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
 *
 * `UpdateQuerySuggestionsBlockList` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
 */
public suspend inline fun KendraClient.updateQuerySuggestionsBlockList(crossinline block: UpdateQuerySuggestionsBlockListRequest.Builder.() -> Unit): UpdateQuerySuggestionsBlockListResponse = updateQuerySuggestionsBlockList(UpdateQuerySuggestionsBlockListRequest.Builder().apply(block).build())

/**
 * Updates the settings of query suggestions for an index.
 *
 * Amazon Kendra supports partial updates, so you only need to provide the fields you want to update.
 *
 * If an update is currently processing, you need to wait for the update to finish before making another update.
 *
 * Updates to query suggestions settings might not take effect right away. The time for your updated settings to take effect depends on the updates made and the number of search queries in your index.
 *
 * You can still enable/disable query suggestions at any time.
 *
 * `UpdateQuerySuggestionsConfig` is currently not supported in the Amazon Web Services GovCloud (US-West) region.
 */
public suspend inline fun KendraClient.updateQuerySuggestionsConfig(crossinline block: UpdateQuerySuggestionsConfigRequest.Builder.() -> Unit): UpdateQuerySuggestionsConfigResponse = updateQuerySuggestionsConfig(UpdateQuerySuggestionsConfigRequest.Builder().apply(block).build())

/**
 * Updates a thesaurus for an index.
 */
public suspend inline fun KendraClient.updateThesaurus(crossinline block: UpdateThesaurusRequest.Builder.() -> Unit): UpdateThesaurusResponse = updateThesaurus(UpdateThesaurusRequest.Builder().apply(block).build())
