// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kafkaconnect.model.CapacityDescription
import aws.sdk.kotlin.services.kafkaconnect.model.ConnectorState
import aws.sdk.kotlin.services.kafkaconnect.model.DescribeConnectorResponse
import aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthenticationDescription
import aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterDescription
import aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription
import aws.sdk.kotlin.services.kafkaconnect.model.KafkaConnectException
import aws.sdk.kotlin.services.kafkaconnect.model.LogDeliveryDescription
import aws.sdk.kotlin.services.kafkaconnect.model.PluginDescription
import aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfigurationDescription
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeConnectorOperationDeserializer: HttpDeserialize<DescribeConnectorResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeConnectorResponse {
        if (!response.status.isSuccess()) {
            throwDescribeConnectorError(context, response)
        }
        val builder = DescribeConnectorResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeConnectorOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeConnectorError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KafkaConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KafkaConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeConnectorOperationBody(builder: DescribeConnectorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("capacity"))
    val CONNECTORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectorArn"))
    val CONNECTORCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("connectorConfiguration"))
    val CONNECTORDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectorDescription"))
    val CONNECTORNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectorName"))
    val CONNECTORSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectorState"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val CURRENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("currentVersion"))
    val KAFKACLUSTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("kafkaCluster"))
    val KAFKACLUSTERCLIENTAUTHENTICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("kafkaClusterClientAuthentication"))
    val KAFKACLUSTERENCRYPTIONINTRANSIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("kafkaClusterEncryptionInTransit"))
    val KAFKACONNECTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("kafkaConnectVersion"))
    val LOGDELIVERY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logDelivery"))
    val PLUGINS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("plugins"))
    val SERVICEEXECUTIONROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceExecutionRoleArn"))
    val WORKERCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("workerConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPACITY_DESCRIPTOR)
        field(CONNECTORARN_DESCRIPTOR)
        field(CONNECTORCONFIGURATION_DESCRIPTOR)
        field(CONNECTORDESCRIPTION_DESCRIPTOR)
        field(CONNECTORNAME_DESCRIPTOR)
        field(CONNECTORSTATE_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(CURRENTVERSION_DESCRIPTOR)
        field(KAFKACLUSTER_DESCRIPTOR)
        field(KAFKACLUSTERCLIENTAUTHENTICATION_DESCRIPTOR)
        field(KAFKACLUSTERENCRYPTIONINTRANSIT_DESCRIPTOR)
        field(KAFKACONNECTVERSION_DESCRIPTOR)
        field(LOGDELIVERY_DESCRIPTOR)
        field(PLUGINS_DESCRIPTOR)
        field(SERVICEEXECUTIONROLEARN_DESCRIPTOR)
        field(WORKERCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPACITY_DESCRIPTOR.index -> builder.capacity = deserializeCapacityDescriptionDocument(deserializer)
                CONNECTORARN_DESCRIPTOR.index -> builder.connectorArn = deserializeString()
                CONNECTORCONFIGURATION_DESCRIPTOR.index -> builder.connectorConfiguration =
                    deserializer.deserializeMap(CONNECTORCONFIGURATION_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                CONNECTORDESCRIPTION_DESCRIPTOR.index -> builder.connectorDescription = deserializeString()
                CONNECTORNAME_DESCRIPTOR.index -> builder.connectorName = deserializeString()
                CONNECTORSTATE_DESCRIPTOR.index -> builder.connectorState = deserializeString().let { ConnectorState.fromValue(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                CURRENTVERSION_DESCRIPTOR.index -> builder.currentVersion = deserializeString()
                KAFKACLUSTER_DESCRIPTOR.index -> builder.kafkaCluster = deserializeKafkaClusterDescriptionDocument(deserializer)
                KAFKACLUSTERCLIENTAUTHENTICATION_DESCRIPTOR.index -> builder.kafkaClusterClientAuthentication = deserializeKafkaClusterClientAuthenticationDescriptionDocument(deserializer)
                KAFKACLUSTERENCRYPTIONINTRANSIT_DESCRIPTOR.index -> builder.kafkaClusterEncryptionInTransit = deserializeKafkaClusterEncryptionInTransitDescriptionDocument(deserializer)
                KAFKACONNECTVERSION_DESCRIPTOR.index -> builder.kafkaConnectVersion = deserializeString()
                LOGDELIVERY_DESCRIPTOR.index -> builder.logDelivery = deserializeLogDeliveryDescriptionDocument(deserializer)
                PLUGINS_DESCRIPTOR.index -> builder.plugins =
                    deserializer.deserializeList(PLUGINS_DESCRIPTOR) {
                        val col0 = mutableListOf<PluginDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePluginDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SERVICEEXECUTIONROLEARN_DESCRIPTOR.index -> builder.serviceExecutionRoleArn = deserializeString()
                WORKERCONFIGURATION_DESCRIPTOR.index -> builder.workerConfiguration = deserializeWorkerConfigurationDescriptionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
