// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kafkaconnect.model.CreateCustomPluginResponse
import aws.sdk.kotlin.services.kafkaconnect.model.CustomPluginState
import aws.sdk.kotlin.services.kafkaconnect.model.KafkaConnectException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCustomPluginOperationDeserializer: HttpDeserialize<CreateCustomPluginResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateCustomPluginResponse {
        if (!response.status.isSuccess()) {
            throwCreateCustomPluginError(context, response)
        }
        val builder = CreateCustomPluginResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateCustomPluginOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateCustomPluginError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KafkaConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KafkaConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCustomPluginOperationBody(builder: CreateCustomPluginResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMPLUGINARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customPluginArn"))
    val CUSTOMPLUGINSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customPluginState"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val REVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("revision"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMPLUGINARN_DESCRIPTOR)
        field(CUSTOMPLUGINSTATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REVISION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMPLUGINARN_DESCRIPTOR.index -> builder.customPluginArn = deserializeString()
                CUSTOMPLUGINSTATE_DESCRIPTOR.index -> builder.customPluginState = deserializeString().let { CustomPluginState.fromValue(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                REVISION_DESCRIPTOR.index -> builder.revision = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
