// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect.model



/**
 * Information about the auto scaling parameters for the connector.
 */
class AutoScalingDescription private constructor(builder: Builder) {
    /**
     * The maximum number of workers allocated to the connector.
     */
    val maxWorkerCount: kotlin.Int = builder.maxWorkerCount
    /**
     * The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.
     */
    val mcuCount: kotlin.Int = builder.mcuCount
    /**
     * The minimum number of workers allocated to the connector.
     */
    val minWorkerCount: kotlin.Int = builder.minWorkerCount
    /**
     * The sacle-in policy for the connector.
     */
    val scaleInPolicy: aws.sdk.kotlin.services.kafkaconnect.model.ScaleInPolicyDescription? = builder.scaleInPolicy
    /**
     * The sacle-out policy for the connector.&gt;
     */
    val scaleOutPolicy: aws.sdk.kotlin.services.kafkaconnect.model.ScaleOutPolicyDescription? = builder.scaleOutPolicy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafkaconnect.model.AutoScalingDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingDescription(")
        append("maxWorkerCount=$maxWorkerCount,")
        append("mcuCount=$mcuCount,")
        append("minWorkerCount=$minWorkerCount,")
        append("scaleInPolicy=$scaleInPolicy,")
        append("scaleOutPolicy=$scaleOutPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxWorkerCount
        result = 31 * result + (mcuCount)
        result = 31 * result + (minWorkerCount)
        result = 31 * result + (scaleInPolicy?.hashCode() ?: 0)
        result = 31 * result + (scaleOutPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingDescription

        if (maxWorkerCount != other.maxWorkerCount) return false
        if (mcuCount != other.mcuCount) return false
        if (minWorkerCount != other.minWorkerCount) return false
        if (scaleInPolicy != other.scaleInPolicy) return false
        if (scaleOutPolicy != other.scaleOutPolicy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafkaconnect.model.AutoScalingDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The maximum number of workers allocated to the connector.
         */
        var maxWorkerCount: kotlin.Int = 0
        /**
         * The number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.
         */
        var mcuCount: kotlin.Int = 0
        /**
         * The minimum number of workers allocated to the connector.
         */
        var minWorkerCount: kotlin.Int = 0
        /**
         * The sacle-in policy for the connector.
         */
        var scaleInPolicy: aws.sdk.kotlin.services.kafkaconnect.model.ScaleInPolicyDescription? = null
        /**
         * The sacle-out policy for the connector.&gt;
         */
        var scaleOutPolicy: aws.sdk.kotlin.services.kafkaconnect.model.ScaleOutPolicyDescription? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafkaconnect.model.AutoScalingDescription) : this() {
            this.maxWorkerCount = x.maxWorkerCount
            this.mcuCount = x.mcuCount
            this.minWorkerCount = x.minWorkerCount
            this.scaleInPolicy = x.scaleInPolicy
            this.scaleOutPolicy = x.scaleOutPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafkaconnect.model.AutoScalingDescription = AutoScalingDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.ScaleInPolicyDescription] inside the given [block]
         */
        fun scaleInPolicy(block: aws.sdk.kotlin.services.kafkaconnect.model.ScaleInPolicyDescription.Builder.() -> kotlin.Unit) {
            this.scaleInPolicy = aws.sdk.kotlin.services.kafkaconnect.model.ScaleInPolicyDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.ScaleOutPolicyDescription] inside the given [block]
         */
        fun scaleOutPolicy(block: aws.sdk.kotlin.services.kafkaconnect.model.ScaleOutPolicyDescription.Builder.() -> kotlin.Unit) {
            this.scaleOutPolicy = aws.sdk.kotlin.services.kafkaconnect.model.ScaleOutPolicyDescription.invoke(block)
        }
    }
}
