// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.kafkaconnect.model.*
import aws.sdk.kotlin.services.kafkaconnect.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "KafkaConnect"
const val ServiceApiVersion: String = "2021-09-14"
const val SdkVersion: String = "0.13.0-beta"

internal class DefaultKafkaConnectClient(override val config: KafkaConnectClient.Config) : KafkaConnectClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a connector using the specified properties.
     */
    override suspend fun createConnector(input: CreateConnectorRequest): CreateConnectorResponse {
        val op = SdkHttpOperation.build<CreateConnectorRequest, CreateConnectorResponse> {
            serializer = CreateConnectorOperationSerializer()
            deserializer = CreateConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "kafkaconnect"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a custom plugin using the specified properties.
     */
    override suspend fun createCustomPlugin(input: CreateCustomPluginRequest): CreateCustomPluginResponse {
        val op = SdkHttpOperation.build<CreateCustomPluginRequest, CreateCustomPluginResponse> {
            serializer = CreateCustomPluginOperationSerializer()
            deserializer = CreateCustomPluginOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomPlugin"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "kafkaconnect"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a worker configuration using the specified properties.
     */
    override suspend fun createWorkerConfiguration(input: CreateWorkerConfigurationRequest): CreateWorkerConfigurationResponse {
        val op = SdkHttpOperation.build<CreateWorkerConfigurationRequest, CreateWorkerConfigurationResponse> {
            serializer = CreateWorkerConfigurationOperationSerializer()
            deserializer = CreateWorkerConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorkerConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "kafkaconnect"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified connector.
     */
    override suspend fun deleteConnector(input: DeleteConnectorRequest): DeleteConnectorResponse {
        val op = SdkHttpOperation.build<DeleteConnectorRequest, DeleteConnectorResponse> {
            serializer = DeleteConnectorOperationSerializer()
            deserializer = DeleteConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "kafkaconnect"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns summary information about the connector.
     */
    override suspend fun describeConnector(input: DescribeConnectorRequest): DescribeConnectorResponse {
        val op = SdkHttpOperation.build<DescribeConnectorRequest, DescribeConnectorResponse> {
            serializer = DescribeConnectorOperationSerializer()
            deserializer = DescribeConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "kafkaconnect"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A summary description of the custom plugin.
     */
    override suspend fun describeCustomPlugin(input: DescribeCustomPluginRequest): DescribeCustomPluginResponse {
        val op = SdkHttpOperation.build<DescribeCustomPluginRequest, DescribeCustomPluginResponse> {
            serializer = DescribeCustomPluginOperationSerializer()
            deserializer = DescribeCustomPluginOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCustomPlugin"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "kafkaconnect"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a worker configuration.
     */
    override suspend fun describeWorkerConfiguration(input: DescribeWorkerConfigurationRequest): DescribeWorkerConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeWorkerConfigurationRequest, DescribeWorkerConfigurationResponse> {
            serializer = DescribeWorkerConfigurationOperationSerializer()
            deserializer = DescribeWorkerConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorkerConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "kafkaconnect"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name starts with the specified prefix. The response also includes a description of each of the listed connectors.
     */
    override suspend fun listConnectors(input: ListConnectorsRequest): ListConnectorsResponse {
        val op = SdkHttpOperation.build<ListConnectorsRequest, ListConnectorsResponse> {
            serializer = ListConnectorsOperationSerializer()
            deserializer = ListConnectorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListConnectors"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "kafkaconnect"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all of the custom plugins in this account and Region.
     */
    override suspend fun listCustomPlugins(input: ListCustomPluginsRequest): ListCustomPluginsResponse {
        val op = SdkHttpOperation.build<ListCustomPluginsRequest, ListCustomPluginsResponse> {
            serializer = ListCustomPluginsOperationSerializer()
            deserializer = ListCustomPluginsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomPlugins"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "kafkaconnect"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all of the worker configurations in this account and Region.
     */
    override suspend fun listWorkerConfigurations(input: ListWorkerConfigurationsRequest): ListWorkerConfigurationsResponse {
        val op = SdkHttpOperation.build<ListWorkerConfigurationsRequest, ListWorkerConfigurationsResponse> {
            serializer = ListWorkerConfigurationsOperationSerializer()
            deserializer = ListWorkerConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorkerConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "kafkaconnect"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified connector.
     */
    override suspend fun updateConnector(input: UpdateConnectorRequest): UpdateConnectorResponse {
        val op = SdkHttpOperation.build<UpdateConnectorRequest, UpdateConnectorResponse> {
            serializer = UpdateConnectorOperationSerializer()
            deserializer = UpdateConnectorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateConnector"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "kafkaconnect"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
