// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kafkaconnect.model.CreateCustomPluginResponse
import aws.sdk.kotlin.services.kafkaconnect.model.CustomPluginState
import aws.sdk.kotlin.services.kafkaconnect.model.KafkaConnectException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCustomPluginOperationDeserializer: HttpDeserialize<CreateCustomPluginResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateCustomPluginResponse {
        if (!response.status.isSuccess()) {
            throwCreateCustomPluginError(context, response)
        }
        val builder = CreateCustomPluginResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateCustomPluginOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeCreateCustomPluginOperationBody(builder: CreateCustomPluginResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CUSTOMPLUGINARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customPluginArn"))
    val CUSTOMPLUGINSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customPluginState"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val REVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("revision"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMPLUGINARN_DESCRIPTOR)
        field(CUSTOMPLUGINSTATE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REVISION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMPLUGINARN_DESCRIPTOR.index -> builder.customPluginArn = deserializeString()
                CUSTOMPLUGINSTATE_DESCRIPTOR.index -> builder.customPluginState = deserializeString().let { CustomPluginState.fromValue(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                REVISION_DESCRIPTOR.index -> builder.revision = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateCustomPluginError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KafkaConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "ForbiddenException" -> ForbiddenExceptionDeserializer()
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw KafkaConnectException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
