// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kafkaconnect.model.ConnectorState
import aws.sdk.kotlin.services.kafkaconnect.model.CreateConnectorResponse
import aws.sdk.kotlin.services.kafkaconnect.model.KafkaConnectException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateConnectorOperationDeserializer: HttpDeserialize<CreateConnectorResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateConnectorResponse {
        if (!response.status.isSuccess()) {
            throwCreateConnectorError(context, response)
        }
        val builder = CreateConnectorResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateConnectorOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeCreateConnectorOperationBody(builder: CreateConnectorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectorArn"))
    val CONNECTORNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectorName"))
    val CONNECTORSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectorState"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTORARN_DESCRIPTOR)
        field(CONNECTORNAME_DESCRIPTOR)
        field(CONNECTORSTATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTORARN_DESCRIPTOR.index -> builder.connectorArn = deserializeString()
                CONNECTORNAME_DESCRIPTOR.index -> builder.connectorName = deserializeString()
                CONNECTORSTATE_DESCRIPTOR.index -> builder.connectorState = deserializeString().let { ConnectorState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateConnectorError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KafkaConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "ForbiddenException" -> ForbiddenExceptionDeserializer()
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer()
        "NotFoundException" -> NotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw KafkaConnectException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
