// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect.paginators

import aws.sdk.kotlin.services.kafkaconnect.KafkaConnectClient
import aws.sdk.kotlin.services.kafkaconnect.model.ConnectorSummary
import aws.sdk.kotlin.services.kafkaconnect.model.CustomPluginSummary
import aws.sdk.kotlin.services.kafkaconnect.model.ListConnectorsRequest
import aws.sdk.kotlin.services.kafkaconnect.model.ListConnectorsResponse
import aws.sdk.kotlin.services.kafkaconnect.model.ListCustomPluginsRequest
import aws.sdk.kotlin.services.kafkaconnect.model.ListCustomPluginsResponse
import aws.sdk.kotlin.services.kafkaconnect.model.ListWorkerConfigurationsRequest
import aws.sdk.kotlin.services.kafkaconnect.model.ListWorkerConfigurationsResponse
import aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfigurationSummary
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListConnectorsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListConnectorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectorsResponse]
 */
fun KafkaConnectClient.listConnectorsPaginated(initialRequest: ListConnectorsRequest): Flow<ListConnectorsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConnectorsPaginated.listConnectors(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listConnectorsPaginated]
 * to access the nested member [ConnectorSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ConnectorSummary]
 */
@JvmName("listConnectorsResponseConnectorSummary")
fun Flow<ListConnectorsResponse>.connectors(): Flow<ConnectorSummary> =
    transform() { response ->
        response.connectors?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCustomPluginsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListCustomPluginsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomPluginsResponse]
 */
fun KafkaConnectClient.listCustomPluginsPaginated(initialRequest: ListCustomPluginsRequest): Flow<ListCustomPluginsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomPluginsPaginated.listCustomPlugins(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listCustomPluginsPaginated]
 * to access the nested member [CustomPluginSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CustomPluginSummary]
 */
@JvmName("listCustomPluginsResponseCustomPluginSummary")
fun Flow<ListCustomPluginsResponse>.customPlugins(): Flow<CustomPluginSummary> =
    transform() { response ->
        response.customPlugins?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkerConfigurationsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListWorkerConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkerConfigurationsResponse]
 */
fun KafkaConnectClient.listWorkerConfigurationsPaginated(initialRequest: ListWorkerConfigurationsRequest): Flow<ListWorkerConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkerConfigurationsPaginated.listWorkerConfigurations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listWorkerConfigurationsPaginated]
 * to access the nested member [WorkerConfigurationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkerConfigurationSummary]
 */
@JvmName("listWorkerConfigurationsResponseWorkerConfigurationSummary")
fun Flow<ListWorkerConfigurationsResponse>.workerConfigurations(): Flow<WorkerConfigurationSummary> =
    transform() { response ->
        response.workerConfigurations?.forEach {
            emit(it)
        }
    }
