// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect.model



class CreateConnectorRequest private constructor(builder: Builder) {
    /**
     * Information about the capacity allocated to the connector. Exactly one of the two properties must be specified.
     */
    val capacity: aws.sdk.kotlin.services.kafkaconnect.model.Capacity? = builder.capacity
    /**
     * A map of keys to values that represent the configuration for the connector.
     */
    val connectorConfiguration: Map<String, String>? = builder.connectorConfiguration
    /**
     * A summary description of the connector.
     */
    val connectorDescription: kotlin.String? = builder.connectorDescription
    /**
     * The name of the connector.
     */
    val connectorName: kotlin.String? = builder.connectorName
    /**
     * Specifies which Apache Kafka cluster to connect to.
     */
    val kafkaCluster: aws.sdk.kotlin.services.kafkaconnect.model.KafkaCluster? = builder.kafkaCluster
    /**
     * Details of the client authentication used by the Apache Kafka cluster.
     */
    val kafkaClusterClientAuthentication: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthentication? = builder.kafkaClusterClientAuthentication
    /**
     * Details of encryption in transit to the Apache Kafka cluster.
     */
    val kafkaClusterEncryptionInTransit: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransit? = builder.kafkaClusterEncryptionInTransit
    /**
     * The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
     */
    val kafkaConnectVersion: kotlin.String? = builder.kafkaConnectVersion
    /**
     * Details about log delivery.
     */
    val logDelivery: aws.sdk.kotlin.services.kafkaconnect.model.LogDelivery? = builder.logDelivery
    /**
     * Specifies which plugins to use for the connector.
     */
    val plugins: List<Plugin>? = builder.plugins
    /**
     * The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
     */
    val serviceExecutionRoleArn: kotlin.String? = builder.serviceExecutionRoleArn
    /**
     * Specifies which worker configuration to use with the connector.
     */
    val workerConfiguration: aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfiguration? = builder.workerConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafkaconnect.model.CreateConnectorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConnectorRequest(")
        append("capacity=$capacity,")
        append("connectorConfiguration=$connectorConfiguration,")
        append("connectorDescription=$connectorDescription,")
        append("connectorName=$connectorName,")
        append("kafkaCluster=$kafkaCluster,")
        append("kafkaClusterClientAuthentication=$kafkaClusterClientAuthentication,")
        append("kafkaClusterEncryptionInTransit=$kafkaClusterEncryptionInTransit,")
        append("kafkaConnectVersion=$kafkaConnectVersion,")
        append("logDelivery=$logDelivery,")
        append("plugins=$plugins,")
        append("serviceExecutionRoleArn=$serviceExecutionRoleArn,")
        append("workerConfiguration=$workerConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacity?.hashCode() ?: 0
        result = 31 * result + (connectorConfiguration?.hashCode() ?: 0)
        result = 31 * result + (connectorDescription?.hashCode() ?: 0)
        result = 31 * result + (connectorName?.hashCode() ?: 0)
        result = 31 * result + (kafkaCluster?.hashCode() ?: 0)
        result = 31 * result + (kafkaClusterClientAuthentication?.hashCode() ?: 0)
        result = 31 * result + (kafkaClusterEncryptionInTransit?.hashCode() ?: 0)
        result = 31 * result + (kafkaConnectVersion?.hashCode() ?: 0)
        result = 31 * result + (logDelivery?.hashCode() ?: 0)
        result = 31 * result + (plugins?.hashCode() ?: 0)
        result = 31 * result + (serviceExecutionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (workerConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConnectorRequest

        if (capacity != other.capacity) return false
        if (connectorConfiguration != other.connectorConfiguration) return false
        if (connectorDescription != other.connectorDescription) return false
        if (connectorName != other.connectorName) return false
        if (kafkaCluster != other.kafkaCluster) return false
        if (kafkaClusterClientAuthentication != other.kafkaClusterClientAuthentication) return false
        if (kafkaClusterEncryptionInTransit != other.kafkaClusterEncryptionInTransit) return false
        if (kafkaConnectVersion != other.kafkaConnectVersion) return false
        if (logDelivery != other.logDelivery) return false
        if (plugins != other.plugins) return false
        if (serviceExecutionRoleArn != other.serviceExecutionRoleArn) return false
        if (workerConfiguration != other.workerConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafkaconnect.model.CreateConnectorRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about the capacity allocated to the connector. Exactly one of the two properties must be specified.
         */
        var capacity: aws.sdk.kotlin.services.kafkaconnect.model.Capacity? = null
        /**
         * A map of keys to values that represent the configuration for the connector.
         */
        var connectorConfiguration: Map<String, String>? = null
        /**
         * A summary description of the connector.
         */
        var connectorDescription: kotlin.String? = null
        /**
         * The name of the connector.
         */
        var connectorName: kotlin.String? = null
        /**
         * Specifies which Apache Kafka cluster to connect to.
         */
        var kafkaCluster: aws.sdk.kotlin.services.kafkaconnect.model.KafkaCluster? = null
        /**
         * Details of the client authentication used by the Apache Kafka cluster.
         */
        var kafkaClusterClientAuthentication: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthentication? = null
        /**
         * Details of encryption in transit to the Apache Kafka cluster.
         */
        var kafkaClusterEncryptionInTransit: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransit? = null
        /**
         * The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
         */
        var kafkaConnectVersion: kotlin.String? = null
        /**
         * Details about log delivery.
         */
        var logDelivery: aws.sdk.kotlin.services.kafkaconnect.model.LogDelivery? = null
        /**
         * Specifies which plugins to use for the connector.
         */
        var plugins: List<Plugin>? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
         */
        var serviceExecutionRoleArn: kotlin.String? = null
        /**
         * Specifies which worker configuration to use with the connector.
         */
        var workerConfiguration: aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafkaconnect.model.CreateConnectorRequest) : this() {
            this.capacity = x.capacity
            this.connectorConfiguration = x.connectorConfiguration
            this.connectorDescription = x.connectorDescription
            this.connectorName = x.connectorName
            this.kafkaCluster = x.kafkaCluster
            this.kafkaClusterClientAuthentication = x.kafkaClusterClientAuthentication
            this.kafkaClusterEncryptionInTransit = x.kafkaClusterEncryptionInTransit
            this.kafkaConnectVersion = x.kafkaConnectVersion
            this.logDelivery = x.logDelivery
            this.plugins = x.plugins
            this.serviceExecutionRoleArn = x.serviceExecutionRoleArn
            this.workerConfiguration = x.workerConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafkaconnect.model.CreateConnectorRequest = CreateConnectorRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.Capacity] inside the given [block]
         */
        fun capacity(block: aws.sdk.kotlin.services.kafkaconnect.model.Capacity.Builder.() -> kotlin.Unit) {
            this.capacity = aws.sdk.kotlin.services.kafkaconnect.model.Capacity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.KafkaCluster] inside the given [block]
         */
        fun kafkaCluster(block: aws.sdk.kotlin.services.kafkaconnect.model.KafkaCluster.Builder.() -> kotlin.Unit) {
            this.kafkaCluster = aws.sdk.kotlin.services.kafkaconnect.model.KafkaCluster.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthentication] inside the given [block]
         */
        fun kafkaClusterClientAuthentication(block: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthentication.Builder.() -> kotlin.Unit) {
            this.kafkaClusterClientAuthentication = aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthentication.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransit] inside the given [block]
         */
        fun kafkaClusterEncryptionInTransit(block: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransit.Builder.() -> kotlin.Unit) {
            this.kafkaClusterEncryptionInTransit = aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransit.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.LogDelivery] inside the given [block]
         */
        fun logDelivery(block: aws.sdk.kotlin.services.kafkaconnect.model.LogDelivery.Builder.() -> kotlin.Unit) {
            this.logDelivery = aws.sdk.kotlin.services.kafkaconnect.model.LogDelivery.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfiguration] inside the given [block]
         */
        fun workerConfiguration(block: aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfiguration.Builder.() -> kotlin.Unit) {
            this.workerConfiguration = aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfiguration.invoke(block)
        }
    }
}
