// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary of a connector.
 */
class ConnectorSummary private constructor(builder: Builder) {
    /**
     * The connector's compute capacity settings.
     */
    val capacity: aws.sdk.kotlin.services.kafkaconnect.model.CapacityDescription? = builder.capacity
    /**
     * The Amazon Resource Name (ARN) of the connector.
     */
    val connectorArn: kotlin.String? = builder.connectorArn
    /**
     * The description of the connector.
     */
    val connectorDescription: kotlin.String? = builder.connectorDescription
    /**
     * The name of the connector.
     */
    val connectorName: kotlin.String? = builder.connectorName
    /**
     * The state of the connector.
     */
    val connectorState: aws.sdk.kotlin.services.kafkaconnect.model.ConnectorState? = builder.connectorState
    /**
     * The time that the connector was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The current version of the connector.
     */
    val currentVersion: kotlin.String? = builder.currentVersion
    /**
     * The details of the Apache Kafka cluster to which the connector is connected.
     */
    val kafkaCluster: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterDescription? = builder.kafkaCluster
    /**
     * The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no client authentication is used.
     */
    val kafkaClusterClientAuthentication: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthenticationDescription? = builder.kafkaClusterClientAuthentication
    /**
     * Details of encryption in transit to the Apache Kafka cluster.
     */
    val kafkaClusterEncryptionInTransit: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription? = builder.kafkaClusterEncryptionInTransit
    /**
     * The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
     */
    val kafkaConnectVersion: kotlin.String? = builder.kafkaConnectVersion
    /**
     * The settings for delivering connector logs to Amazon CloudWatch Logs.
     */
    val logDelivery: aws.sdk.kotlin.services.kafkaconnect.model.LogDeliveryDescription? = builder.logDelivery
    /**
     * Specifies which plugins were used for this connector.
     */
    val plugins: List<PluginDescription>? = builder.plugins
    /**
     * The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.
     */
    val serviceExecutionRoleArn: kotlin.String? = builder.serviceExecutionRoleArn
    /**
     * The worker configurations that are in use with the connector.
     */
    val workerConfiguration: aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfigurationDescription? = builder.workerConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafkaconnect.model.ConnectorSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectorSummary(")
        append("capacity=$capacity,")
        append("connectorArn=$connectorArn,")
        append("connectorDescription=$connectorDescription,")
        append("connectorName=$connectorName,")
        append("connectorState=$connectorState,")
        append("creationTime=$creationTime,")
        append("currentVersion=$currentVersion,")
        append("kafkaCluster=$kafkaCluster,")
        append("kafkaClusterClientAuthentication=$kafkaClusterClientAuthentication,")
        append("kafkaClusterEncryptionInTransit=$kafkaClusterEncryptionInTransit,")
        append("kafkaConnectVersion=$kafkaConnectVersion,")
        append("logDelivery=$logDelivery,")
        append("plugins=$plugins,")
        append("serviceExecutionRoleArn=$serviceExecutionRoleArn,")
        append("workerConfiguration=$workerConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacity?.hashCode() ?: 0
        result = 31 * result + (connectorArn?.hashCode() ?: 0)
        result = 31 * result + (connectorDescription?.hashCode() ?: 0)
        result = 31 * result + (connectorName?.hashCode() ?: 0)
        result = 31 * result + (connectorState?.hashCode() ?: 0)
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (currentVersion?.hashCode() ?: 0)
        result = 31 * result + (kafkaCluster?.hashCode() ?: 0)
        result = 31 * result + (kafkaClusterClientAuthentication?.hashCode() ?: 0)
        result = 31 * result + (kafkaClusterEncryptionInTransit?.hashCode() ?: 0)
        result = 31 * result + (kafkaConnectVersion?.hashCode() ?: 0)
        result = 31 * result + (logDelivery?.hashCode() ?: 0)
        result = 31 * result + (plugins?.hashCode() ?: 0)
        result = 31 * result + (serviceExecutionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (workerConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectorSummary

        if (capacity != other.capacity) return false
        if (connectorArn != other.connectorArn) return false
        if (connectorDescription != other.connectorDescription) return false
        if (connectorName != other.connectorName) return false
        if (connectorState != other.connectorState) return false
        if (creationTime != other.creationTime) return false
        if (currentVersion != other.currentVersion) return false
        if (kafkaCluster != other.kafkaCluster) return false
        if (kafkaClusterClientAuthentication != other.kafkaClusterClientAuthentication) return false
        if (kafkaClusterEncryptionInTransit != other.kafkaClusterEncryptionInTransit) return false
        if (kafkaConnectVersion != other.kafkaConnectVersion) return false
        if (logDelivery != other.logDelivery) return false
        if (plugins != other.plugins) return false
        if (serviceExecutionRoleArn != other.serviceExecutionRoleArn) return false
        if (workerConfiguration != other.workerConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafkaconnect.model.ConnectorSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The connector's compute capacity settings.
         */
        var capacity: aws.sdk.kotlin.services.kafkaconnect.model.CapacityDescription? = null
        /**
         * The Amazon Resource Name (ARN) of the connector.
         */
        var connectorArn: kotlin.String? = null
        /**
         * The description of the connector.
         */
        var connectorDescription: kotlin.String? = null
        /**
         * The name of the connector.
         */
        var connectorName: kotlin.String? = null
        /**
         * The state of the connector.
         */
        var connectorState: aws.sdk.kotlin.services.kafkaconnect.model.ConnectorState? = null
        /**
         * The time that the connector was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current version of the connector.
         */
        var currentVersion: kotlin.String? = null
        /**
         * The details of the Apache Kafka cluster to which the connector is connected.
         */
        var kafkaCluster: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterDescription? = null
        /**
         * The type of client authentication used to connect to the Apache Kafka cluster. The value is NONE when no client authentication is used.
         */
        var kafkaClusterClientAuthentication: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthenticationDescription? = null
        /**
         * Details of encryption in transit to the Apache Kafka cluster.
         */
        var kafkaClusterEncryptionInTransit: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription? = null
        /**
         * The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
         */
        var kafkaConnectVersion: kotlin.String? = null
        /**
         * The settings for delivering connector logs to Amazon CloudWatch Logs.
         */
        var logDelivery: aws.sdk.kotlin.services.kafkaconnect.model.LogDeliveryDescription? = null
        /**
         * Specifies which plugins were used for this connector.
         */
        var plugins: List<PluginDescription>? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.
         */
        var serviceExecutionRoleArn: kotlin.String? = null
        /**
         * The worker configurations that are in use with the connector.
         */
        var workerConfiguration: aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfigurationDescription? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafkaconnect.model.ConnectorSummary) : this() {
            this.capacity = x.capacity
            this.connectorArn = x.connectorArn
            this.connectorDescription = x.connectorDescription
            this.connectorName = x.connectorName
            this.connectorState = x.connectorState
            this.creationTime = x.creationTime
            this.currentVersion = x.currentVersion
            this.kafkaCluster = x.kafkaCluster
            this.kafkaClusterClientAuthentication = x.kafkaClusterClientAuthentication
            this.kafkaClusterEncryptionInTransit = x.kafkaClusterEncryptionInTransit
            this.kafkaConnectVersion = x.kafkaConnectVersion
            this.logDelivery = x.logDelivery
            this.plugins = x.plugins
            this.serviceExecutionRoleArn = x.serviceExecutionRoleArn
            this.workerConfiguration = x.workerConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafkaconnect.model.ConnectorSummary = ConnectorSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.CapacityDescription] inside the given [block]
         */
        fun capacity(block: aws.sdk.kotlin.services.kafkaconnect.model.CapacityDescription.Builder.() -> kotlin.Unit) {
            this.capacity = aws.sdk.kotlin.services.kafkaconnect.model.CapacityDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterDescription] inside the given [block]
         */
        fun kafkaCluster(block: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterDescription.Builder.() -> kotlin.Unit) {
            this.kafkaCluster = aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthenticationDescription] inside the given [block]
         */
        fun kafkaClusterClientAuthentication(block: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthenticationDescription.Builder.() -> kotlin.Unit) {
            this.kafkaClusterClientAuthentication = aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthenticationDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription] inside the given [block]
         */
        fun kafkaClusterEncryptionInTransit(block: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription.Builder.() -> kotlin.Unit) {
            this.kafkaClusterEncryptionInTransit = aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.LogDeliveryDescription] inside the given [block]
         */
        fun logDelivery(block: aws.sdk.kotlin.services.kafkaconnect.model.LogDeliveryDescription.Builder.() -> kotlin.Unit) {
            this.logDelivery = aws.sdk.kotlin.services.kafkaconnect.model.LogDeliveryDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfigurationDescription] inside the given [block]
         */
        fun workerConfiguration(block: aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfigurationDescription.Builder.() -> kotlin.Unit) {
            this.workerConfiguration = aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfigurationDescription.invoke(block)
        }
    }
}
