// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.kafkaconnect.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.kafkaconnect.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <p/>
 */
interface KafkaConnectClient : SdkClient {

    override val serviceName: String
        get() = "KafkaConnect"
    /**
     * KafkaConnectClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): KafkaConnectClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
                sdkLogMode = sharedConfig?.sdkLogMode ?: SdkLogMode.Default
            }.apply(block).build()
            return DefaultKafkaConnectClient(config)
        }

        operator fun invoke(config: Config): KafkaConnectClient = DefaultKafkaConnectClient(config)

        /**
         * Construct a [KafkaConnectClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): KafkaConnectClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return KafkaConnectClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a connector using the specified properties.
     */
    suspend fun createConnector(input: CreateConnectorRequest): CreateConnectorResponse

    /**
     * Creates a connector using the specified properties.
     */
    suspend fun createConnector(block: CreateConnectorRequest.Builder.() -> Unit) = createConnector(CreateConnectorRequest.Builder().apply(block).build())

    /**
     * Creates a custom plugin using the specified properties.
     */
    suspend fun createCustomPlugin(input: CreateCustomPluginRequest): CreateCustomPluginResponse

    /**
     * Creates a custom plugin using the specified properties.
     */
    suspend fun createCustomPlugin(block: CreateCustomPluginRequest.Builder.() -> Unit) = createCustomPlugin(CreateCustomPluginRequest.Builder().apply(block).build())

    /**
     * Creates a worker configuration using the specified properties.
     */
    suspend fun createWorkerConfiguration(input: CreateWorkerConfigurationRequest): CreateWorkerConfigurationResponse

    /**
     * Creates a worker configuration using the specified properties.
     */
    suspend fun createWorkerConfiguration(block: CreateWorkerConfigurationRequest.Builder.() -> Unit) = createWorkerConfiguration(CreateWorkerConfigurationRequest.Builder().apply(block).build())

    /**
     * Deletes the specified connector.
     */
    suspend fun deleteConnector(input: DeleteConnectorRequest): DeleteConnectorResponse

    /**
     * Deletes the specified connector.
     */
    suspend fun deleteConnector(block: DeleteConnectorRequest.Builder.() -> Unit) = deleteConnector(DeleteConnectorRequest.Builder().apply(block).build())

    /**
     * Returns summary information about the connector.
     */
    suspend fun describeConnector(input: DescribeConnectorRequest): DescribeConnectorResponse

    /**
     * Returns summary information about the connector.
     */
    suspend fun describeConnector(block: DescribeConnectorRequest.Builder.() -> Unit) = describeConnector(DescribeConnectorRequest.Builder().apply(block).build())

    /**
     * A summary description of the custom plugin.
     */
    suspend fun describeCustomPlugin(input: DescribeCustomPluginRequest): DescribeCustomPluginResponse

    /**
     * A summary description of the custom plugin.
     */
    suspend fun describeCustomPlugin(block: DescribeCustomPluginRequest.Builder.() -> Unit) = describeCustomPlugin(DescribeCustomPluginRequest.Builder().apply(block).build())

    /**
     * Returns information about a worker configuration.
     */
    suspend fun describeWorkerConfiguration(input: DescribeWorkerConfigurationRequest): DescribeWorkerConfigurationResponse

    /**
     * Returns information about a worker configuration.
     */
    suspend fun describeWorkerConfiguration(block: DescribeWorkerConfigurationRequest.Builder.() -> Unit) = describeWorkerConfiguration(DescribeWorkerConfigurationRequest.Builder().apply(block).build())

    /**
     * Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name starts with the specified prefix. The response also includes a description of each of the listed connectors.
     */
    suspend fun listConnectors(input: ListConnectorsRequest): ListConnectorsResponse

    /**
     * Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name starts with the specified prefix. The response also includes a description of each of the listed connectors.
     */
    suspend fun listConnectors(block: ListConnectorsRequest.Builder.() -> Unit) = listConnectors(ListConnectorsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all of the custom plugins in this account and Region.
     */
    suspend fun listCustomPlugins(input: ListCustomPluginsRequest): ListCustomPluginsResponse

    /**
     * Returns a list of all of the custom plugins in this account and Region.
     */
    suspend fun listCustomPlugins(block: ListCustomPluginsRequest.Builder.() -> Unit) = listCustomPlugins(ListCustomPluginsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all of the worker configurations in this account and Region.
     */
    suspend fun listWorkerConfigurations(input: ListWorkerConfigurationsRequest): ListWorkerConfigurationsResponse

    /**
     * Returns a list of all of the worker configurations in this account and Region.
     */
    suspend fun listWorkerConfigurations(block: ListWorkerConfigurationsRequest.Builder.() -> Unit) = listWorkerConfigurations(ListWorkerConfigurationsRequest.Builder().apply(block).build())

    /**
     * Updates the specified connector.
     */
    suspend fun updateConnector(input: UpdateConnectorRequest): UpdateConnectorResponse

    /**
     * Updates the specified connector.
     */
    suspend fun updateConnector(block: UpdateConnectorRequest.Builder.() -> Unit) = updateConnector(UpdateConnectorRequest.Builder().apply(block).build())
}
