// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect.serde

import aws.sdk.kotlin.services.kafkaconnect.model.CustomPluginRevisionSummary
import aws.sdk.kotlin.services.kafkaconnect.model.CustomPluginState
import aws.sdk.kotlin.services.kafkaconnect.model.DescribeCustomPluginResponse
import aws.sdk.kotlin.services.kafkaconnect.model.KafkaConnectException
import aws.sdk.kotlin.services.kafkaconnect.model.StateDescription
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeCustomPluginOperationDeserializer: HttpDeserializer.NonStreaming<DescribeCustomPluginResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeCustomPluginResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeCustomPluginError(context, call, payload)
        }
        val builder = DescribeCustomPluginResponse.Builder()

        if (payload != null) {
            deserializeDescribeCustomPluginOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeCustomPluginError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw KafkaConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> KafkaConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeCustomPluginOperationBody(builder: DescribeCustomPluginResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val CUSTOMPLUGINARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customPluginArn"))
    val CUSTOMPLUGINSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customPluginState"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val LATESTREVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("latestRevision"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val STATEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("stateDescription"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(CUSTOMPLUGINARN_DESCRIPTOR)
        field(CUSTOMPLUGINSTATE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LATESTREVISION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATEDESCRIPTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.ISO_8601)
                CUSTOMPLUGINARN_DESCRIPTOR.index -> builder.customPluginArn = deserializeString()
                CUSTOMPLUGINSTATE_DESCRIPTOR.index -> builder.customPluginState = deserializeString().let { CustomPluginState.fromValue(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                LATESTREVISION_DESCRIPTOR.index -> builder.latestRevision = deserializeCustomPluginRevisionSummaryDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATEDESCRIPTION_DESCRIPTOR.index -> builder.stateDescription = deserializeStateDescriptionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
