// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect.serde

import aws.sdk.kotlin.services.kafkaconnect.model.CreateCustomPluginRequest
import aws.sdk.kotlin.services.kafkaconnect.model.CustomPluginContentType
import aws.sdk.kotlin.services.kafkaconnect.model.CustomPluginLocation
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCustomPluginOperationSerializer: HttpSerializer.NonStreaming<CreateCustomPluginRequest> {
    override fun serialize(context: ExecutionContext, input: CreateCustomPluginRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/v1/custom-plugins"
        }

        val payload = serializeCreateCustomPluginOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateCustomPluginOperationBody(context: ExecutionContext, input: CreateCustomPluginRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONTENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("contentType"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("location"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENTTYPE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LOCATION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        field(CONTENTTYPE_DESCRIPTOR, input.contentType.value)
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.location?.let { field(LOCATION_DESCRIPTOR, it, ::serializeCustomPluginLocationDocument) }
        field(NAME_DESCRIPTOR, input.name)
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
