// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateConnectorRequest private constructor(builder: Builder) {
    /**
     * Information about the capacity allocated to the connector. Exactly one of the two properties must be specified.
     */
    public val capacity: aws.sdk.kotlin.services.kafkaconnect.model.Capacity? = builder.capacity
    /**
     * A map of keys to values that represent the configuration for the connector.
     */
    public val connectorConfiguration: Map<String, String> = requireNotNull(builder.connectorConfiguration) { "A non-null value must be provided for connectorConfiguration" }
    /**
     * A summary description of the connector.
     */
    public val connectorDescription: kotlin.String? = builder.connectorDescription
    /**
     * The name of the connector.
     */
    public val connectorName: kotlin.String = requireNotNull(builder.connectorName) { "A non-null value must be provided for connectorName" }
    /**
     * Specifies which Apache Kafka cluster to connect to.
     */
    public val kafkaCluster: aws.sdk.kotlin.services.kafkaconnect.model.KafkaCluster? = builder.kafkaCluster
    /**
     * Details of the client authentication used by the Apache Kafka cluster.
     */
    public val kafkaClusterClientAuthentication: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthentication? = builder.kafkaClusterClientAuthentication
    /**
     * Details of encryption in transit to the Apache Kafka cluster.
     */
    public val kafkaClusterEncryptionInTransit: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransit? = builder.kafkaClusterEncryptionInTransit
    /**
     * The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
     */
    public val kafkaConnectVersion: kotlin.String = requireNotNull(builder.kafkaConnectVersion) { "A non-null value must be provided for kafkaConnectVersion" }
    /**
     * Details about log delivery.
     */
    public val logDelivery: aws.sdk.kotlin.services.kafkaconnect.model.LogDelivery? = builder.logDelivery
    /**
     * Amazon MSK Connect does not currently support specifying multiple plugins as a list. To use more than one plugin for your connector, you can create a single custom plugin using a ZIP file that bundles multiple plugins together.
     *
     * Specifies which plugin to use for the connector. You must specify a single-element list containing one `customPlugin` object.
     */
    public val plugins: List<Plugin> = requireNotNull(builder.plugins) { "A non-null value must be provided for plugins" }
    /**
     * The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
     */
    public val serviceExecutionRoleArn: kotlin.String = requireNotNull(builder.serviceExecutionRoleArn) { "A non-null value must be provided for serviceExecutionRoleArn" }
    /**
     * The tags you want to attach to the connector.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Specifies which worker configuration to use with the connector.
     */
    public val workerConfiguration: aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfiguration? = builder.workerConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafkaconnect.model.CreateConnectorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConnectorRequest(")
        append("capacity=$capacity,")
        append("connectorConfiguration=*** Sensitive Data Redacted ***,")
        append("connectorDescription=$connectorDescription,")
        append("connectorName=$connectorName,")
        append("kafkaCluster=$kafkaCluster,")
        append("kafkaClusterClientAuthentication=$kafkaClusterClientAuthentication,")
        append("kafkaClusterEncryptionInTransit=$kafkaClusterEncryptionInTransit,")
        append("kafkaConnectVersion=$kafkaConnectVersion,")
        append("logDelivery=$logDelivery,")
        append("plugins=$plugins,")
        append("serviceExecutionRoleArn=$serviceExecutionRoleArn,")
        append("tags=$tags,")
        append("workerConfiguration=$workerConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacity?.hashCode() ?: 0
        result = 31 * result + (connectorConfiguration.hashCode())
        result = 31 * result + (connectorDescription?.hashCode() ?: 0)
        result = 31 * result + (connectorName.hashCode())
        result = 31 * result + (kafkaCluster?.hashCode() ?: 0)
        result = 31 * result + (kafkaClusterClientAuthentication?.hashCode() ?: 0)
        result = 31 * result + (kafkaClusterEncryptionInTransit?.hashCode() ?: 0)
        result = 31 * result + (kafkaConnectVersion.hashCode())
        result = 31 * result + (logDelivery?.hashCode() ?: 0)
        result = 31 * result + (plugins.hashCode())
        result = 31 * result + (serviceExecutionRoleArn.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workerConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConnectorRequest

        if (capacity != other.capacity) return false
        if (connectorConfiguration != other.connectorConfiguration) return false
        if (connectorDescription != other.connectorDescription) return false
        if (connectorName != other.connectorName) return false
        if (kafkaCluster != other.kafkaCluster) return false
        if (kafkaClusterClientAuthentication != other.kafkaClusterClientAuthentication) return false
        if (kafkaClusterEncryptionInTransit != other.kafkaClusterEncryptionInTransit) return false
        if (kafkaConnectVersion != other.kafkaConnectVersion) return false
        if (logDelivery != other.logDelivery) return false
        if (plugins != other.plugins) return false
        if (serviceExecutionRoleArn != other.serviceExecutionRoleArn) return false
        if (tags != other.tags) return false
        if (workerConfiguration != other.workerConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafkaconnect.model.CreateConnectorRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about the capacity allocated to the connector. Exactly one of the two properties must be specified.
         */
        public var capacity: aws.sdk.kotlin.services.kafkaconnect.model.Capacity? = null
        /**
         * A map of keys to values that represent the configuration for the connector.
         */
        public var connectorConfiguration: Map<String, String>? = null
        /**
         * A summary description of the connector.
         */
        public var connectorDescription: kotlin.String? = null
        /**
         * The name of the connector.
         */
        public var connectorName: kotlin.String? = null
        /**
         * Specifies which Apache Kafka cluster to connect to.
         */
        public var kafkaCluster: aws.sdk.kotlin.services.kafkaconnect.model.KafkaCluster? = null
        /**
         * Details of the client authentication used by the Apache Kafka cluster.
         */
        public var kafkaClusterClientAuthentication: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthentication? = null
        /**
         * Details of encryption in transit to the Apache Kafka cluster.
         */
        public var kafkaClusterEncryptionInTransit: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransit? = null
        /**
         * The version of Kafka Connect. It has to be compatible with both the Apache Kafka cluster's version and the plugins.
         */
        public var kafkaConnectVersion: kotlin.String? = null
        /**
         * Details about log delivery.
         */
        public var logDelivery: aws.sdk.kotlin.services.kafkaconnect.model.LogDelivery? = null
        /**
         * Amazon MSK Connect does not currently support specifying multiple plugins as a list. To use more than one plugin for your connector, you can create a single custom plugin using a ZIP file that bundles multiple plugins together.
         *
         * Specifies which plugin to use for the connector. You must specify a single-element list containing one `customPlugin` object.
         */
        public var plugins: List<Plugin>? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role used by the connector to access the Amazon Web Services resources that it needs. The types of resources depends on the logic of the connector. For example, a connector that has Amazon S3 as a destination must have permissions that allow it to write to the S3 destination bucket.
         */
        public var serviceExecutionRoleArn: kotlin.String? = null
        /**
         * The tags you want to attach to the connector.
         */
        public var tags: Map<String, String>? = null
        /**
         * Specifies which worker configuration to use with the connector.
         */
        public var workerConfiguration: aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafkaconnect.model.CreateConnectorRequest) : this() {
            this.capacity = x.capacity
            this.connectorConfiguration = x.connectorConfiguration
            this.connectorDescription = x.connectorDescription
            this.connectorName = x.connectorName
            this.kafkaCluster = x.kafkaCluster
            this.kafkaClusterClientAuthentication = x.kafkaClusterClientAuthentication
            this.kafkaClusterEncryptionInTransit = x.kafkaClusterEncryptionInTransit
            this.kafkaConnectVersion = x.kafkaConnectVersion
            this.logDelivery = x.logDelivery
            this.plugins = x.plugins
            this.serviceExecutionRoleArn = x.serviceExecutionRoleArn
            this.tags = x.tags
            this.workerConfiguration = x.workerConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafkaconnect.model.CreateConnectorRequest = CreateConnectorRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.Capacity] inside the given [block]
         */
        public fun capacity(block: aws.sdk.kotlin.services.kafkaconnect.model.Capacity.Builder.() -> kotlin.Unit) {
            this.capacity = aws.sdk.kotlin.services.kafkaconnect.model.Capacity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.KafkaCluster] inside the given [block]
         */
        public fun kafkaCluster(block: aws.sdk.kotlin.services.kafkaconnect.model.KafkaCluster.Builder.() -> kotlin.Unit) {
            this.kafkaCluster = aws.sdk.kotlin.services.kafkaconnect.model.KafkaCluster.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthentication] inside the given [block]
         */
        public fun kafkaClusterClientAuthentication(block: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthentication.Builder.() -> kotlin.Unit) {
            this.kafkaClusterClientAuthentication = aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterClientAuthentication.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransit] inside the given [block]
         */
        public fun kafkaClusterEncryptionInTransit(block: aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransit.Builder.() -> kotlin.Unit) {
            this.kafkaClusterEncryptionInTransit = aws.sdk.kotlin.services.kafkaconnect.model.KafkaClusterEncryptionInTransit.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.LogDelivery] inside the given [block]
         */
        public fun logDelivery(block: aws.sdk.kotlin.services.kafkaconnect.model.LogDelivery.Builder.() -> kotlin.Unit) {
            this.logDelivery = aws.sdk.kotlin.services.kafkaconnect.model.LogDelivery.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfiguration] inside the given [block]
         */
        public fun workerConfiguration(block: aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfiguration.Builder.() -> kotlin.Unit) {
            this.workerConfiguration = aws.sdk.kotlin.services.kafkaconnect.model.WorkerConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (connectorConfiguration == null) connectorConfiguration = emptyMap()
            if (connectorName == null) connectorName = ""
            if (kafkaConnectVersion == null) kafkaConnectVersion = ""
            if (plugins == null) plugins = emptyList()
            if (serviceExecutionRoleArn == null) serviceExecutionRoleArn = ""
            return this
        }
    }
}
