// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The updates to the auto scaling parameters for the connector.
 */
public class AutoScalingUpdate private constructor(builder: Builder) {
    /**
     * The target maximum number of workers allocated to the connector.
     */
    public val maxWorkerCount: kotlin.Int = builder.maxWorkerCount
    /**
     * The target number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.
     */
    public val mcuCount: kotlin.Int = builder.mcuCount
    /**
     * The target minimum number of workers allocated to the connector.
     */
    public val minWorkerCount: kotlin.Int = builder.minWorkerCount
    /**
     * The target sacle-in policy for the connector.
     */
    public val scaleInPolicy: aws.sdk.kotlin.services.kafkaconnect.model.ScaleInPolicyUpdate? = builder.scaleInPolicy
    /**
     * The target sacle-out policy for the connector.
     */
    public val scaleOutPolicy: aws.sdk.kotlin.services.kafkaconnect.model.ScaleOutPolicyUpdate? = builder.scaleOutPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kafkaconnect.model.AutoScalingUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingUpdate(")
        append("maxWorkerCount=$maxWorkerCount,")
        append("mcuCount=$mcuCount,")
        append("minWorkerCount=$minWorkerCount,")
        append("scaleInPolicy=$scaleInPolicy,")
        append("scaleOutPolicy=$scaleOutPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxWorkerCount
        result = 31 * result + (mcuCount)
        result = 31 * result + (minWorkerCount)
        result = 31 * result + (scaleInPolicy?.hashCode() ?: 0)
        result = 31 * result + (scaleOutPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingUpdate

        if (maxWorkerCount != other.maxWorkerCount) return false
        if (mcuCount != other.mcuCount) return false
        if (minWorkerCount != other.minWorkerCount) return false
        if (scaleInPolicy != other.scaleInPolicy) return false
        if (scaleOutPolicy != other.scaleOutPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kafkaconnect.model.AutoScalingUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The target maximum number of workers allocated to the connector.
         */
        public var maxWorkerCount: kotlin.Int = 0
        /**
         * The target number of microcontroller units (MCUs) allocated to each connector worker. The valid values are 1,2,4,8.
         */
        public var mcuCount: kotlin.Int = 0
        /**
         * The target minimum number of workers allocated to the connector.
         */
        public var minWorkerCount: kotlin.Int = 0
        /**
         * The target sacle-in policy for the connector.
         */
        public var scaleInPolicy: aws.sdk.kotlin.services.kafkaconnect.model.ScaleInPolicyUpdate? = null
        /**
         * The target sacle-out policy for the connector.
         */
        public var scaleOutPolicy: aws.sdk.kotlin.services.kafkaconnect.model.ScaleOutPolicyUpdate? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kafkaconnect.model.AutoScalingUpdate) : this() {
            this.maxWorkerCount = x.maxWorkerCount
            this.mcuCount = x.mcuCount
            this.minWorkerCount = x.minWorkerCount
            this.scaleInPolicy = x.scaleInPolicy
            this.scaleOutPolicy = x.scaleOutPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kafkaconnect.model.AutoScalingUpdate = AutoScalingUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.ScaleInPolicyUpdate] inside the given [block]
         */
        public fun scaleInPolicy(block: aws.sdk.kotlin.services.kafkaconnect.model.ScaleInPolicyUpdate.Builder.() -> kotlin.Unit) {
            this.scaleInPolicy = aws.sdk.kotlin.services.kafkaconnect.model.ScaleInPolicyUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kafkaconnect.model.ScaleOutPolicyUpdate] inside the given [block]
         */
        public fun scaleOutPolicy(block: aws.sdk.kotlin.services.kafkaconnect.model.ScaleOutPolicyUpdate.Builder.() -> kotlin.Unit) {
            this.scaleOutPolicy = aws.sdk.kotlin.services.kafkaconnect.model.ScaleOutPolicyUpdate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
