// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafkaconnect

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.kafkaconnect.auth.DefaultKafkaConnectAuthSchemeProvider
import aws.sdk.kotlin.services.kafkaconnect.auth.KafkaConnectAuthSchemeProvider
import aws.sdk.kotlin.services.kafkaconnect.endpoints.DefaultKafkaConnectEndpointProvider
import aws.sdk.kotlin.services.kafkaconnect.endpoints.KafkaConnectEndpointParameters
import aws.sdk.kotlin.services.kafkaconnect.endpoints.KafkaConnectEndpointProvider
import aws.sdk.kotlin.services.kafkaconnect.model.CreateConnectorRequest
import aws.sdk.kotlin.services.kafkaconnect.model.CreateConnectorResponse
import aws.sdk.kotlin.services.kafkaconnect.model.CreateCustomPluginRequest
import aws.sdk.kotlin.services.kafkaconnect.model.CreateCustomPluginResponse
import aws.sdk.kotlin.services.kafkaconnect.model.CreateWorkerConfigurationRequest
import aws.sdk.kotlin.services.kafkaconnect.model.CreateWorkerConfigurationResponse
import aws.sdk.kotlin.services.kafkaconnect.model.DeleteConnectorRequest
import aws.sdk.kotlin.services.kafkaconnect.model.DeleteConnectorResponse
import aws.sdk.kotlin.services.kafkaconnect.model.DeleteCustomPluginRequest
import aws.sdk.kotlin.services.kafkaconnect.model.DeleteCustomPluginResponse
import aws.sdk.kotlin.services.kafkaconnect.model.DeleteWorkerConfigurationRequest
import aws.sdk.kotlin.services.kafkaconnect.model.DeleteWorkerConfigurationResponse
import aws.sdk.kotlin.services.kafkaconnect.model.DescribeConnectorRequest
import aws.sdk.kotlin.services.kafkaconnect.model.DescribeConnectorResponse
import aws.sdk.kotlin.services.kafkaconnect.model.DescribeCustomPluginRequest
import aws.sdk.kotlin.services.kafkaconnect.model.DescribeCustomPluginResponse
import aws.sdk.kotlin.services.kafkaconnect.model.DescribeWorkerConfigurationRequest
import aws.sdk.kotlin.services.kafkaconnect.model.DescribeWorkerConfigurationResponse
import aws.sdk.kotlin.services.kafkaconnect.model.ListConnectorsRequest
import aws.sdk.kotlin.services.kafkaconnect.model.ListConnectorsResponse
import aws.sdk.kotlin.services.kafkaconnect.model.ListCustomPluginsRequest
import aws.sdk.kotlin.services.kafkaconnect.model.ListCustomPluginsResponse
import aws.sdk.kotlin.services.kafkaconnect.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.kafkaconnect.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.kafkaconnect.model.ListWorkerConfigurationsRequest
import aws.sdk.kotlin.services.kafkaconnect.model.ListWorkerConfigurationsResponse
import aws.sdk.kotlin.services.kafkaconnect.model.TagResourceRequest
import aws.sdk.kotlin.services.kafkaconnect.model.TagResourceResponse
import aws.sdk.kotlin.services.kafkaconnect.model.UntagResourceRequest
import aws.sdk.kotlin.services.kafkaconnect.model.UntagResourceResponse
import aws.sdk.kotlin.services.kafkaconnect.model.UpdateConnectorRequest
import aws.sdk.kotlin.services.kafkaconnect.model.UpdateConnectorResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "KafkaConnect"
public const val SdkVersion: String = "1.3.18"
public const val ServiceApiVersion: String = "2021-09-14"

/**
 *
 */
public interface KafkaConnectClient : SdkClient {
    /**
     * KafkaConnectClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, KafkaConnectClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "KafkaConnect",
                "KAFKACONNECT",
                "kafkaconnect",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, KafkaConnectClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): KafkaConnectClient = DefaultKafkaConnectClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: KafkaConnectEndpointProvider = builder.endpointProvider ?: DefaultKafkaConnectEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: KafkaConnectAuthSchemeProvider = builder.authSchemeProvider ?: DefaultKafkaConnectAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "KafkaConnect"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: KafkaConnectEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: KafkaConnectAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a connector using the specified properties.
     */
    public suspend fun createConnector(input: CreateConnectorRequest): CreateConnectorResponse

    /**
     * Creates a custom plugin using the specified properties.
     */
    public suspend fun createCustomPlugin(input: CreateCustomPluginRequest): CreateCustomPluginResponse

    /**
     * Creates a worker configuration using the specified properties.
     */
    public suspend fun createWorkerConfiguration(input: CreateWorkerConfigurationRequest): CreateWorkerConfigurationResponse

    /**
     * Deletes the specified connector.
     */
    public suspend fun deleteConnector(input: DeleteConnectorRequest): DeleteConnectorResponse

    /**
     * Deletes a custom plugin.
     */
    public suspend fun deleteCustomPlugin(input: DeleteCustomPluginRequest): DeleteCustomPluginResponse

    /**
     * Deletes the specified worker configuration.
     */
    public suspend fun deleteWorkerConfiguration(input: DeleteWorkerConfigurationRequest): DeleteWorkerConfigurationResponse

    /**
     * Returns summary information about the connector.
     */
    public suspend fun describeConnector(input: DescribeConnectorRequest): DescribeConnectorResponse

    /**
     * A summary description of the custom plugin.
     */
    public suspend fun describeCustomPlugin(input: DescribeCustomPluginRequest): DescribeCustomPluginResponse

    /**
     * Returns information about a worker configuration.
     */
    public suspend fun describeWorkerConfiguration(input: DescribeWorkerConfigurationRequest): DescribeWorkerConfigurationResponse

    /**
     * Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name starts with the specified prefix. The response also includes a description of each of the listed connectors.
     */
    public suspend fun listConnectors(input: ListConnectorsRequest = ListConnectorsRequest { }): ListConnectorsResponse

    /**
     * Returns a list of all of the custom plugins in this account and Region.
     */
    public suspend fun listCustomPlugins(input: ListCustomPluginsRequest = ListCustomPluginsRequest { }): ListCustomPluginsResponse

    /**
     * Lists all the tags attached to the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of all of the worker configurations in this account and Region.
     */
    public suspend fun listWorkerConfigurations(input: ListWorkerConfigurationsRequest = ListWorkerConfigurationsRequest { }): ListWorkerConfigurationsResponse

    /**
     * Attaches tags to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified connector.
     */
    public suspend fun updateConnector(input: UpdateConnectorRequest): UpdateConnectorResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun KafkaConnectClient.withConfig(block: KafkaConnectClient.Config.Builder.() -> Unit): KafkaConnectClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultKafkaConnectClient(newConfig)
}

/**
 * Creates a connector using the specified properties.
 */
public suspend inline fun KafkaConnectClient.createConnector(crossinline block: CreateConnectorRequest.Builder.() -> Unit): CreateConnectorResponse = createConnector(CreateConnectorRequest.Builder().apply(block).build())

/**
 * Creates a custom plugin using the specified properties.
 */
public suspend inline fun KafkaConnectClient.createCustomPlugin(crossinline block: CreateCustomPluginRequest.Builder.() -> Unit): CreateCustomPluginResponse = createCustomPlugin(CreateCustomPluginRequest.Builder().apply(block).build())

/**
 * Creates a worker configuration using the specified properties.
 */
public suspend inline fun KafkaConnectClient.createWorkerConfiguration(crossinline block: CreateWorkerConfigurationRequest.Builder.() -> Unit): CreateWorkerConfigurationResponse = createWorkerConfiguration(CreateWorkerConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the specified connector.
 */
public suspend inline fun KafkaConnectClient.deleteConnector(crossinline block: DeleteConnectorRequest.Builder.() -> Unit): DeleteConnectorResponse = deleteConnector(DeleteConnectorRequest.Builder().apply(block).build())

/**
 * Deletes a custom plugin.
 */
public suspend inline fun KafkaConnectClient.deleteCustomPlugin(crossinline block: DeleteCustomPluginRequest.Builder.() -> Unit): DeleteCustomPluginResponse = deleteCustomPlugin(DeleteCustomPluginRequest.Builder().apply(block).build())

/**
 * Deletes the specified worker configuration.
 */
public suspend inline fun KafkaConnectClient.deleteWorkerConfiguration(crossinline block: DeleteWorkerConfigurationRequest.Builder.() -> Unit): DeleteWorkerConfigurationResponse = deleteWorkerConfiguration(DeleteWorkerConfigurationRequest.Builder().apply(block).build())

/**
 * Returns summary information about the connector.
 */
public suspend inline fun KafkaConnectClient.describeConnector(crossinline block: DescribeConnectorRequest.Builder.() -> Unit): DescribeConnectorResponse = describeConnector(DescribeConnectorRequest.Builder().apply(block).build())

/**
 * A summary description of the custom plugin.
 */
public suspend inline fun KafkaConnectClient.describeCustomPlugin(crossinline block: DescribeCustomPluginRequest.Builder.() -> Unit): DescribeCustomPluginResponse = describeCustomPlugin(DescribeCustomPluginRequest.Builder().apply(block).build())

/**
 * Returns information about a worker configuration.
 */
public suspend inline fun KafkaConnectClient.describeWorkerConfiguration(crossinline block: DescribeWorkerConfigurationRequest.Builder.() -> Unit): DescribeWorkerConfigurationResponse = describeWorkerConfiguration(DescribeWorkerConfigurationRequest.Builder().apply(block).build())

/**
 * Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name starts with the specified prefix. The response also includes a description of each of the listed connectors.
 */
public suspend inline fun KafkaConnectClient.listConnectors(crossinline block: ListConnectorsRequest.Builder.() -> Unit): ListConnectorsResponse = listConnectors(ListConnectorsRequest.Builder().apply(block).build())

/**
 * Returns a list of all of the custom plugins in this account and Region.
 */
public suspend inline fun KafkaConnectClient.listCustomPlugins(crossinline block: ListCustomPluginsRequest.Builder.() -> Unit): ListCustomPluginsResponse = listCustomPlugins(ListCustomPluginsRequest.Builder().apply(block).build())

/**
 * Lists all the tags attached to the specified resource.
 */
public suspend inline fun KafkaConnectClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of all of the worker configurations in this account and Region.
 */
public suspend inline fun KafkaConnectClient.listWorkerConfigurations(crossinline block: ListWorkerConfigurationsRequest.Builder.() -> Unit): ListWorkerConfigurationsResponse = listWorkerConfigurations(ListWorkerConfigurationsRequest.Builder().apply(block).build())

/**
 * Attaches tags to the specified resource.
 */
public suspend inline fun KafkaConnectClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the specified resource.
 */
public suspend inline fun KafkaConnectClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified connector.
 */
public suspend inline fun KafkaConnectClient.updateConnector(crossinline block: UpdateConnectorRequest.Builder.() -> Unit): UpdateConnectorResponse = updateConnector(UpdateConnectorRequest.Builder().apply(block).build())
