// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kafka.model.GetBootstrapBrokersResponse
import aws.sdk.kotlin.services.kafka.model.KafkaException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetBootstrapBrokersOperationDeserializer: HttpDeserialize<GetBootstrapBrokersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetBootstrapBrokersResponse {
        if (!response.status.isSuccess()) {
            throwGetBootstrapBrokersError(context, response)
        }
        val builder = GetBootstrapBrokersResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetBootstrapBrokersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeGetBootstrapBrokersOperationBody(builder: GetBootstrapBrokersResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BOOTSTRAPBROKERSTRING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerString"))
    val BOOTSTRAPBROKERSTRINGSASLIAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringSaslIam"))
    val BOOTSTRAPBROKERSTRINGSASLSCRAM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringSaslScram"))
    val BOOTSTRAPBROKERSTRINGTLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bootstrapBrokerStringTls"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BOOTSTRAPBROKERSTRING_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGSASLIAM_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGSASLSCRAM_DESCRIPTOR)
        field(BOOTSTRAPBROKERSTRINGTLS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BOOTSTRAPBROKERSTRING_DESCRIPTOR.index -> builder.bootstrapBrokerString = deserializeString()
                BOOTSTRAPBROKERSTRINGSASLIAM_DESCRIPTOR.index -> builder.bootstrapBrokerStringSaslIam = deserializeString()
                BOOTSTRAPBROKERSTRINGSASLSCRAM_DESCRIPTOR.index -> builder.bootstrapBrokerStringSaslScram = deserializeString()
                BOOTSTRAPBROKERSTRINGTLS_DESCRIPTOR.index -> builder.bootstrapBrokerStringTls = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetBootstrapBrokersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer()
        "ConflictException" -> ConflictExceptionDeserializer()
        "ForbiddenException" -> ForbiddenExceptionDeserializer()
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer()
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer()
        else -> throw KafkaException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
