// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kafka.model



class UpdateConfigurationRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the configuration.
     */
    val arn: String? = builder.arn
    /**
     * The description of the configuration revision.
     */
    val description: String? = builder.description
    /**
     * Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the contents of the file are base64 encoded.
     * When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.
     */
    val serverProperties: ByteArray? = builder.serverProperties

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateConfigurationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateConfigurationRequest(")
        append("arn=$arn,")
        append("description=$description,")
        append("serverProperties=$serverProperties)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (serverProperties?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateConfigurationRequest

        if (arn != other.arn) return false
        if (description != other.description) return false
        if (serverProperties != null) {
            if (other.serverProperties == null) return false
            if (!serverProperties.contentEquals(other.serverProperties)) return false
        } else if (other.serverProperties != null) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateConfigurationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateConfigurationRequest
        /**
         * The Amazon Resource Name (ARN) of the configuration.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The description of the configuration revision.
         */
        fun description(description: String): FluentBuilder
        /**
         * Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the contents of the file are base64 encoded.
         * When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.
         */
        fun serverProperties(serverProperties: ByteArray): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the configuration.
         */
        var arn: String?
        /**
         * The description of the configuration revision.
         */
        var description: String?
        /**
         * Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the contents of the file are base64 encoded.
         * When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.
         */
        var serverProperties: ByteArray?

        fun build(): UpdateConfigurationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var description: String? = null
        override var serverProperties: ByteArray? = null

        constructor(x: UpdateConfigurationRequest) : this() {
            this.arn = x.arn
            this.description = x.description
            this.serverProperties = x.serverProperties
        }

        override fun build(): UpdateConfigurationRequest = UpdateConfigurationRequest(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun serverProperties(serverProperties: ByteArray): FluentBuilder = apply { this.serverProperties = serverProperties }
    }
}
